/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;

public class SequenceWriter
implements Versioned,
Closeable,
Flushable {
    protected final DefaultSerializerProvider _provider;
    protected final SerializationConfig _config;
    protected final JsonGenerator _generator;
    protected final JsonSerializer<Object> _rootSerializer;
    protected final TypeSerializer _typeSerializer;
    protected final boolean _closeGenerator;
    protected final boolean _cfgFlush;
    protected final boolean _cfgCloseCloseable;
    protected PropertySerializerMap _dynamicSerializers;
    protected boolean _openArray;
    protected boolean _closed;

    public SequenceWriter(DefaultSerializerProvider defaultSerializerProvider, JsonGenerator jsonGenerator, boolean bl, ObjectWriter.Prefetch prefetch) throws IOException {
        this._provider = defaultSerializerProvider;
        this._generator = jsonGenerator;
        this._closeGenerator = bl;
        this._rootSerializer = prefetch.getValueSerializer();
        this._typeSerializer = prefetch.getTypeSerializer();
        this._config = defaultSerializerProvider.getConfig();
        this._cfgFlush = this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        this._cfgCloseCloseable = this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE);
        this._dynamicSerializers = PropertySerializerMap.emptyForRootValues();
    }

    public SequenceWriter init(boolean bl) throws IOException {
        if (bl) {
            this._generator.writeStartArray();
            this._openArray = true;
        }
        return this;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public SequenceWriter write(Object object) throws IOException {
        Class<?> clazz;
        if (object == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && object instanceof Closeable) {
            return this._writeCloseableValue(object);
        }
        JsonSerializer<Object> jsonSerializer = this._rootSerializer;
        if (jsonSerializer == null && (jsonSerializer = this._dynamicSerializers.serializerFor(clazz = object.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(clazz);
        }
        this._provider.serializeValue(this._generator, object, null, jsonSerializer);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter write(Object object, JavaType javaType) throws IOException {
        if (object == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && object instanceof Closeable) {
            return this._writeCloseableValue(object, javaType);
        }
        JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(javaType.getRawClass());
        if (jsonSerializer == null) {
            jsonSerializer = this._findAndAddDynamic(javaType);
        }
        this._provider.serializeValue(this._generator, object, javaType, jsonSerializer);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter writeAll(Object[] objectArray) throws IOException {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.write(objectArray[i]);
        }
        return this;
    }

    public <C extends Collection<?>> SequenceWriter writeAll(C c) throws IOException {
        for (Object obj : c) {
            this.write(obj);
        }
        return this;
    }

    public SequenceWriter writeAll(Iterable<?> iterable) throws IOException {
        for (Object obj : iterable) {
            this.write(obj);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (!this._closed) {
            this._generator.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (this._openArray) {
                this._openArray = false;
                this._generator.writeEndArray();
            }
            if (this._closeGenerator) {
                this._generator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceWriter _writeCloseableValue(Object object) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            Object object2;
            JsonSerializer<Object> jsonSerializer = this._rootSerializer;
            if (jsonSerializer == null && (jsonSerializer = this._dynamicSerializers.serializerFor((Class<?>)(object2 = object.getClass()))) == null) {
                jsonSerializer = this._findAndAddDynamic((Class<?>)object2);
            }
            this._provider.serializeValue(this._generator, object, null, jsonSerializer);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            object2 = closeable;
            closeable = null;
            object2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceWriter _writeCloseableValue(Object object, JavaType javaType) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(javaType.getRawClass());
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(javaType);
            }
            this._provider.serializeValue(this._generator, object, javaType, jsonSerializer);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    private final JsonSerializer<Object> _findAndAddDynamic(Class<?> clazz) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer(clazz, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer(clazz, (JsonSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findValueSerializer(clazz, null)));
        this._dynamicSerializers = serializerAndMapResult.map;
        return serializerAndMapResult.serializer;
    }

    private final JsonSerializer<Object> _findAndAddDynamic(JavaType javaType) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer(javaType, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer(javaType, (JsonSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findValueSerializer(javaType, null)));
        this._dynamicSerializers = serializerAndMapResult.map;
        return serializerAndMapResult.serializer;
    }
}

