/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.ext.Java7Support;
import com.fasterxml.jackson.databind.ext.NioPathDeserializer;
import com.fasterxml.jackson.databind.ext.NioPathSerializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import java.beans.ConstructorProperties;
import java.beans.Transient;
import java.nio.file.Path;

public class Java7SupportImpl
extends Java7Support {
    private final Class<?> _bogus;

    public Java7SupportImpl() {
        Class clazz = Transient.class;
        clazz = ConstructorProperties.class;
        this._bogus = clazz;
    }

    @Override
    public Class<?> getClassJavaNioFilePath() {
        return Path.class;
    }

    @Override
    public JsonDeserializer<?> getDeserializerForJavaNioFilePath(Class<?> clazz) {
        if (clazz == Path.class) {
            return new NioPathDeserializer();
        }
        return null;
    }

    @Override
    public JsonSerializer<?> getSerializerForJavaNioFilePath(Class<?> clazz) {
        if (Path.class.isAssignableFrom(clazz)) {
            return new NioPathSerializer();
        }
        return null;
    }

    @Override
    public Boolean findTransient(Annotated annotated) {
        Transient transient_ = annotated.getAnnotation(Transient.class);
        if (transient_ != null) {
            return transient_.value();
        }
        return null;
    }

    @Override
    public Boolean hasCreatorAnnotation(Annotated annotated) {
        ConstructorProperties constructorProperties = annotated.getAnnotation(ConstructorProperties.class);
        if (constructorProperties != null) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public PropertyName findConstructorName(AnnotatedParameter annotatedParameter) {
        ConstructorProperties constructorProperties;
        AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
        if (annotatedWithParams != null && (constructorProperties = annotatedWithParams.getAnnotation(ConstructorProperties.class)) != null) {
            String[] stringArray = constructorProperties.value();
            int n = annotatedParameter.getIndex();
            if (n < stringArray.length) {
                return PropertyName.construct(stringArray[n]);
            }
        }
        return null;
    }
}

