/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StdSubtypeResolver
extends SubtypeResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LinkedHashSet<NamedType> _registeredSubtypes;

    @Override
    public void registerSubtypes(NamedType ... namedTypeArray) {
        if (this._registeredSubtypes == null) {
            this._registeredSubtypes = new LinkedHashSet();
        }
        for (NamedType namedType : namedTypeArray) {
            this._registeredSubtypes.add(namedType);
        }
    }

    @Override
    public void registerSubtypes(Class<?> ... classArray) {
        NamedType[] namedTypeArray = new NamedType[classArray.length];
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            namedTypeArray[i] = new NamedType(classArray[i]);
        }
        this.registerSubtypes(namedTypeArray);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByClass(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        Object object;
        Object object2;
        Object object3;
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        Class<?> clazz = javaType == null ? annotatedMember.getRawType() : javaType.getRawClass();
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            object3 = this._registeredSubtypes.iterator();
            while (object3.hasNext()) {
                object2 = (NamedType)object3.next();
                if (!clazz.isAssignableFrom(((NamedType)object2).getType())) continue;
                object = AnnotatedClass.constructWithoutSuperTypes(((NamedType)object2).getType(), mapperConfig);
                this._collectAndResolve((AnnotatedClass)object, (NamedType)object2, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        if ((object3 = annotationIntrospector.findSubtypes(annotatedMember)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (NamedType)object2.next();
                AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(((NamedType)object).getType(), mapperConfig);
                this._collectAndResolve(annotatedClass, (NamedType)object, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        object2 = new NamedType(clazz, null);
        object = AnnotatedClass.constructWithoutSuperTypes(clazz, mapperConfig);
        this._collectAndResolve((AnnotatedClass)object, (NamedType)object2, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByClass(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        Serializable serializable;
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            serializable = annotatedClass.getRawType();
            for (NamedType namedType : this._registeredSubtypes) {
                if (!((Class)serializable).isAssignableFrom(namedType.getType())) continue;
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType.getType(), mapperConfig);
                this._collectAndResolve(annotatedClass2, namedType, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        serializable = new NamedType(annotatedClass.getRawType(), null);
        this._collectAndResolve(annotatedClass, (NamedType)serializable, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByTypeId(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        Class<?> clazz = javaType == null ? annotatedMember.getRawType() : javaType.getRawClass();
        HashSet hashSet = new HashSet();
        LinkedHashMap<String, NamedType> linkedHashMap = new LinkedHashMap<String, NamedType>();
        NamedType namedType = new NamedType(clazz, null);
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(clazz, mapperConfig);
        this._collectAndResolveByTypeId(annotatedClass, namedType, mapperConfig, hashSet, linkedHashMap);
        List<NamedType> list = annotationIntrospector.findSubtypes(annotatedMember);
        if (list != null) {
            for (NamedType namedType2 : list) {
                annotatedClass = AnnotatedClass.constructWithoutSuperTypes(namedType2.getType(), mapperConfig);
                this._collectAndResolveByTypeId(annotatedClass, namedType2, mapperConfig, hashSet, linkedHashMap);
            }
        }
        if (this._registeredSubtypes != null) {
            for (NamedType namedType2 : this._registeredSubtypes) {
                if (!clazz.isAssignableFrom(namedType2.getType())) continue;
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType2.getType(), mapperConfig);
                this._collectAndResolveByTypeId(annotatedClass2, namedType2, mapperConfig, hashSet, linkedHashMap);
            }
        }
        return this._combineNamedAndUnnamed(hashSet, linkedHashMap);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByTypeId(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        HashSet hashSet = new HashSet();
        LinkedHashMap<String, NamedType> linkedHashMap = new LinkedHashMap<String, NamedType>();
        NamedType namedType = new NamedType(annotatedClass.getRawType(), null);
        this._collectAndResolveByTypeId(annotatedClass, namedType, mapperConfig, hashSet, linkedHashMap);
        if (this._registeredSubtypes != null) {
            Class<?> clazz = annotatedClass.getRawType();
            for (NamedType namedType2 : this._registeredSubtypes) {
                if (!clazz.isAssignableFrom(namedType2.getType())) continue;
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType2.getType(), mapperConfig);
                this._collectAndResolveByTypeId(annotatedClass2, namedType2, mapperConfig, hashSet, linkedHashMap);
            }
        }
        return this._combineNamedAndUnnamed(hashSet, linkedHashMap);
    }

    protected void _collectAndResolve(AnnotatedClass annotatedClass, NamedType namedType, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, HashMap<NamedType, NamedType> hashMap) {
        List<NamedType> list;
        if (!namedType.hasName() && (list = annotationIntrospector.findTypeName(annotatedClass)) != null) {
            namedType = new NamedType(namedType.getType(), (String)((Object)list));
        }
        if (hashMap.containsKey(namedType)) {
            if (namedType.hasName() && !((NamedType)((Object)(list = hashMap.get(namedType)))).hasName()) {
                hashMap.put(namedType, namedType);
            }
            return;
        }
        hashMap.put(namedType, namedType);
        list = annotationIntrospector.findSubtypes(annotatedClass);
        if (list != null && !list.isEmpty()) {
            for (NamedType namedType2 : list) {
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType2.getType(), mapperConfig);
                this._collectAndResolve(annotatedClass2, namedType2, mapperConfig, annotationIntrospector, hashMap);
            }
        }
    }

    protected void _collectAndResolveByTypeId(AnnotatedClass annotatedClass, NamedType namedType, MapperConfig<?> mapperConfig, Set<Class<?>> set, Map<String, NamedType> map) {
        Object object;
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        if (!namedType.hasName() && (object = annotationIntrospector.findTypeName(annotatedClass)) != null) {
            namedType = new NamedType(namedType.getType(), (String)object);
        }
        if (namedType.hasName()) {
            map.put(namedType.getName(), namedType);
        }
        if (set.add(namedType.getType()) && (object = annotationIntrospector.findSubtypes(annotatedClass)) != null && !object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                NamedType namedType2 = (NamedType)iterator.next();
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType2.getType(), mapperConfig);
                this._collectAndResolveByTypeId(annotatedClass2, namedType2, mapperConfig, set, map);
            }
        }
    }

    protected Collection<NamedType> _combineNamedAndUnnamed(Set<Class<?>> set, Map<String, NamedType> map) {
        ArrayList<NamedType> arrayList = new ArrayList<NamedType>(map.values());
        for (NamedType serializable : map.values()) {
            set.remove(serializable.getType());
        }
        for (Class clazz : set) {
            arrayList.add(new NamedType(clazz));
        }
        return arrayList;
    }
}

