/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.usocket;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class JNAUSocketFactory
implements USocketFactory {
    public USocketFactory.Socket open(String string) throws IOException {
        int n = CLibrary.INSTANCE.socket(1, 1, 0);
        if (n < 0) {
            throw new IOException("failed to allocate usocket");
        }
        int n2 = CLibrary.INSTANCE.fcntl(n, 2, 8);
        if (n2 < 0) {
            CLibrary.INSTANCE.close(n);
            throw new IOException("failed to fctrl usocket: " + n2);
        }
        SockAddr sockAddr = new SockAddr();
        sockAddr.sun_family = 1;
        sockAddr.sun_path = new byte[108];
        System.arraycopy(string.getBytes(), 0, sockAddr.sun_path, 0, string.length());
        sockAddr.write();
        n2 = CLibrary.INSTANCE.connect(n, sockAddr.getPointer(), sockAddr.size());
        if (n2 < 0) {
            throw new IOException("failed to fctrl usocket: " + n2);
        }
        return new MySocket(n);
    }

    public class MySocket
    extends USocketFactory.Socket {
        private int sock;

        public int readFull(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            byte[] byArray2 = byArray;
            int n4 = n;
            for (int i = n2; i > 0; i -= n3) {
                if (n4 != 0) {
                    byArray2 = new byte[i];
                }
                if ((n3 = CLibrary.INSTANCE.read(this.sock, byArray2, i)) <= 0) {
                    return -1;
                }
                if (n4 != 0) {
                    System.arraycopy(byArray2, 0, byArray, n4, n3);
                }
                n4 += n3;
            }
            return n2;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = byArray;
            int n3 = n2;
            if (n != 0) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
            CLibrary.INSTANCE.write(this.sock, byArray2, n2);
        }

        MySocket(int n) throws IOException {
            this.sock = n;
        }

        public void close() throws IOException {
            CLibrary.INSTANCE.close(this.sock);
        }
    }

    public static class SockAddr
    extends Structure {
        public short sun_family;
        public byte[] sun_path;

        protected List getFieldOrder() {
            return Arrays.asList("sun_family", "sun_path");
        }
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int socket(int var1, int var2, int var3);

        public int fcntl(int var1, int var2, Object ... var3);

        public int connect(int var1, Pointer var2, int var3);

        public int close(int var1);

        public int read(int var1, byte[] var2, int var3);

        public int write(int var1, byte[] var2, int var3);
    }
}

