/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.Iterator;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

class TokenIterator
implements Iterator<Token> {
    private RSyntaxDocument doc;
    private int curLine;
    private Token token;

    public TokenIterator(RSyntaxDocument rSyntaxDocument) {
        this.doc = rSyntaxDocument;
        this.loadTokenListForCurLine();
        int n = this.getLineCount();
        while (!(this.token != null && this.token.isPaintable() || this.curLine >= n - 1)) {
            ++this.curLine;
            this.loadTokenListForCurLine();
        }
    }

    private int getLineCount() {
        return this.doc.getDefaultRootElement().getElementCount();
    }

    @Override
    public boolean hasNext() {
        return this.token != null;
    }

    private void loadTokenListForCurLine() {
        this.token = this.doc.getTokenListForLine(this.curLine);
        if (this.token != null && !this.token.isPaintable()) {
            this.token = null;
        }
    }

    @Override
    public Token next() {
        Token token = this.token;
        boolean bl = false;
        int n = this.getLineCount();
        if (this.token != null && this.token.isPaintable()) {
            this.token = this.token.getNextToken();
        } else if (this.curLine < n - 1) {
            token = new TokenImpl(token);
            bl = true;
            ++this.curLine;
            this.loadTokenListForCurLine();
        } else if (this.token != null && !this.token.isPaintable()) {
            this.token = null;
        }
        while (!(this.token != null && this.token.isPaintable() || this.curLine >= n - 1)) {
            if (!bl) {
                token = new TokenImpl(token);
                bl = true;
            }
            ++this.curLine;
            this.loadTokenListForCurLine();
        }
        if (this.token != null && !this.token.isPaintable() && this.curLine == n - 1) {
            this.token = null;
        }
        return token;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

