/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.ctcp;

import com.ircclouds.irc.api.ctcp.DCCReceiveCallback;
import com.ircclouds.irc.api.ctcp.DCCReceiveException;
import com.ircclouds.irc.api.ctcp.DCCReceiveProgressCallback;
import com.ircclouds.irc.api.ctcp.DCCReceiveResult;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import nl.dannyvanheumen.nio.ProxiedSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(DCCReceiver.class);
    private final ByteBuffer bb = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
    private final DCCReceiveCallback callback;
    private final Proxy proxy;
    private int totalBytesReceived;
    private int totalAcksSent;
    private IOException exc;

    public DCCReceiver(DCCReceiveCallback aCallback, Proxy aProxy) {
        this.proxy = aProxy;
        this.callback = aCallback;
    }

    public void receive(final File aFile, final Integer aResumePos, final Integer aSize, final SocketAddress aAddress) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long _timeBefore;
                FileOutputStream _fos;
                FileChannel _fc;
                block14: {
                    SocketChannel _sc = null;
                    _fc = null;
                    _fos = null;
                    _timeBefore = 0L;
                    try {
                        _timeBefore = System.currentTimeMillis();
                        if (DCCReceiver.this.proxy == null) {
                            _sc = SocketChannel.open(aAddress);
                        } else {
                            _sc = new ProxiedSocketChannel(DCCReceiver.this.proxy);
                            _sc.connect(aAddress);
                        }
                        _fos = new FileOutputStream(aFile);
                        _fc = _fos.getChannel();
                        for (long _read = (long)aResumePos.intValue(); _read < (long)aSize.intValue(); _read += _fc.transferFrom(_sc, (long)aResumePos.intValue() + _read, aSize.intValue())) {
                            DCCReceiver.this.writeTotalBytesReceived(_sc, (int)_read);
                        }
                        if (_sc == null) break block14;
                    }
                    catch (IOException aExc) {
                        block15: {
                            try {
                                DCCReceiver.this.exc = aExc;
                                LOG.error("", (Throwable)aExc);
                                if (_sc == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (_sc != null) {
                                    DCCReceiver.this.close(_sc);
                                }
                                if (_fos != null) {
                                    DCCReceiver.this.close(_fos);
                                }
                                if (_fc != null) {
                                    DCCReceiver.this.close(_fc);
                                }
                                DCCReceiver.this.callBack(aSize, System.currentTimeMillis() - _timeBefore);
                                throw throwable;
                            }
                            DCCReceiver.this.close(_sc);
                        }
                        if (_fos != null) {
                            DCCReceiver.this.close(_fos);
                        }
                        if (_fc != null) {
                            DCCReceiver.this.close(_fc);
                        }
                        DCCReceiver.this.callBack(aSize, System.currentTimeMillis() - _timeBefore);
                    }
                    DCCReceiver.this.close(_sc);
                }
                if (_fos != null) {
                    DCCReceiver.this.close(_fos);
                }
                if (_fc != null) {
                    DCCReceiver.this.close(_fc);
                }
                DCCReceiver.this.callBack(aSize, System.currentTimeMillis() - _timeBefore);
            }
        }).start();
    }

    private void callBack(int aPromisedFileSize, final long aTimeTaken) {
        DCCReceiveResult _dccRecRes = new DCCReceiveResult(){

            @Override
            public long totalTime() {
                return aTimeTaken;
            }

            @Override
            public int totalBytesReceived() {
                return DCCReceiver.this.totalBytesReceived;
            }

            @Override
            public int getNumberOfAcksSent() {
                return DCCReceiver.this.totalAcksSent;
            }
        };
        if (this.totalBytesReceived == aPromisedFileSize) {
            this.callback.onSuccess(_dccRecRes);
        } else {
            this.callback.onFailure(new DCCReceiveException(_dccRecRes, this.exc));
        }
    }

    private void writeTotalBytesReceived(SocketChannel aSocketChannel, int aCount) throws IOException {
        this.bb.clear();
        this.bb.putInt(aCount);
        aSocketChannel.write(this.bb);
        if (this.callback instanceof DCCReceiveProgressCallback) {
            ((DCCReceiveProgressCallback)this.callback).onProgress(aCount);
        }
    }

    private void close(Closeable aCloseable) {
        try {
            aCloseable.close();
        }
        catch (IOException aExc) {
            LOG.error("", (Throwable)aExc);
        }
    }
}

