/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Vector;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.crypto.OtrCryptoException;
import net.java.sip.communicator.plugin.otr.OtrConfigurator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManager;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManagerListener;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;

public class ScOtrKeyManagerImpl
implements ScOtrKeyManager {
    private final OtrConfigurator configurator = new OtrConfigurator();
    private final List<ScOtrKeyManagerListener> listeners = new Vector<ScOtrKeyManagerListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ScOtrKeyManagerListener l) {
        List<ScOtrKeyManagerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScOtrKeyManagerListener[] getListeners() {
        List<ScOtrKeyManagerListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new ScOtrKeyManagerListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ScOtrKeyManagerListener l) {
        List<ScOtrKeyManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void verify(OtrContactManager.OtrContact otrContact, String fingerprint) {
        if (fingerprint == null || otrContact == null) {
            return;
        }
        this.configurator.setProperty(otrContact.contact.getAddress() + fingerprint + ".fingerprint.verified", true);
        for (ScOtrKeyManagerListener l : this.getListeners()) {
            l.contactVerificationStatusChanged(otrContact);
        }
    }

    @Override
    public void unverify(OtrContactManager.OtrContact otrContact, String fingerprint) {
        if (fingerprint == null || otrContact == null) {
            return;
        }
        this.configurator.setProperty(otrContact.contact.getAddress() + fingerprint + ".fingerprint.verified", false);
        for (ScOtrKeyManagerListener l : this.getListeners()) {
            l.contactVerificationStatusChanged(otrContact);
        }
    }

    @Override
    public boolean isVerified(Contact contact, String fingerprint) {
        if (fingerprint == null || contact == null) {
            return false;
        }
        return this.configurator.getPropertyBoolean(contact.getAddress() + fingerprint + ".fingerprint.verified", false);
    }

    @Override
    public List<String> getAllRemoteFingerprints(Contact contact) {
        if (contact == null) {
            return null;
        }
        String userID = contact.getAddress();
        byte[] b64PubKey = this.configurator.getPropertyBytes(userID + ".publicKey");
        if (b64PubKey != null) {
            this.configurator.removeProperty(userID + ".publicKey");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(b64PubKey);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                PublicKey pubKey = keyFactory.generatePublic(publicKeySpec);
                boolean isVerified = this.configurator.getPropertyBoolean(userID + ".publicKey.verified", false);
                this.configurator.removeProperty(userID + ".publicKey.verified");
                String fingerprint = this.getFingerprintFromPublicKey(pubKey);
                if (isVerified) {
                    this.verify(OtrContactManager.getOtrContact(contact, null), fingerprint);
                } else {
                    this.unverify(OtrContactManager.getOtrContact(contact, null), fingerprint);
                }
                this.configurator.appendProperty(userID + ".fingerprints", fingerprint);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (InvalidKeySpecException e) {
                e.printStackTrace();
            }
        }
        return this.configurator.getAppendedProperties(contact.getAddress() + ".fingerprints");
    }

    @Override
    public String getFingerprintFromPublicKey(PublicKey pubKey) {
        try {
            return new OtrCryptoEngineImpl().getFingerprint(pubKey);
        }
        catch (OtrCryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getLocalFingerprint(AccountID account) {
        KeyPair keyPair = this.loadKeyPair(account);
        if (keyPair == null) {
            return null;
        }
        PublicKey pubKey = keyPair.getPublic();
        try {
            return new OtrCryptoEngineImpl().getFingerprint(pubKey);
        }
        catch (OtrCryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] getLocalFingerprintRaw(AccountID account) {
        KeyPair keyPair = this.loadKeyPair(account);
        if (keyPair == null) {
            return null;
        }
        PublicKey pubKey = keyPair.getPublic();
        try {
            return new OtrCryptoEngineImpl().getFingerprintRaw(pubKey);
        }
        catch (OtrCryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void saveFingerprint(Contact contact, String fingerprint) {
        if (contact == null) {
            return;
        }
        this.configurator.appendProperty(contact.getAddress() + ".fingerprints", fingerprint);
        this.configurator.setProperty(contact.getAddress() + fingerprint + ".fingerprint.verified", false);
    }

    @Override
    public KeyPair loadKeyPair(AccountID account) {
        PrivateKey privateKey;
        PublicKey publicKey;
        if (account == null) {
            return null;
        }
        String accountID = account.getAccountUniqueID();
        byte[] b64PrivKey = this.configurator.getPropertyBytes(accountID + ".privateKey");
        if (b64PrivKey == null) {
            return null;
        }
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(b64PrivKey);
        byte[] b64PubKey = this.configurator.getPropertyBytes(accountID + ".publicKey");
        if (b64PubKey == null) {
            return null;
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(b64PubKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            publicKey = keyFactory.generatePublic(publicKeySpec);
            privateKey = keyFactory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
        return new KeyPair(publicKey, privateKey);
    }

    @Override
    public void generateKeyPair(AccountID account) {
        KeyPair keyPair;
        if (account == null) {
            return;
        }
        String accountID = account.getAccountUniqueID();
        try {
            keyPair = KeyPairGenerator.getInstance("DSA").genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return;
        }
        PublicKey pubKey = keyPair.getPublic();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(pubKey.getEncoded());
        this.configurator.setProperty(accountID + ".publicKey", x509EncodedKeySpec.getEncoded());
        PrivateKey privKey = keyPair.getPrivate();
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privKey.getEncoded());
        this.configurator.setProperty(accountID + ".privateKey", pkcs8EncodedKeySpec.getEncoded());
    }
}

