/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.addins;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class AddinsReqRvCmd
extends AbstractRequestRvCmd {
    public static final int CODE_DEFAULT = 0;
    public static final long FLAGS_DEFAULT = 0L;
    private static final int TYPE_ADDINURI = 7;
    private final int code;
    private final String addinUri;
    private final ByteBlock uuid;
    private final String addinName;
    private final String computerName;
    private final long flags;
    private final InvitationMessage invMessage;

    public AddinsReqRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getRvTlvs();
        this.addinUri = chain.getString(7);
        ByteBlock rvData = this.getServiceData();
        int code = -1;
        ByteBlock uuid = null;
        String addinName = null;
        String computerName = null;
        long flags = -1L;
        if (rvData != null && rvData.getLength() >= 2) {
            code = BinaryTools.getUShort(rvData, 0);
            if (rvData.getLength() > 10) {
                uuid = ByteBlock.wrap(rvData.subBlock(2, 16).toByteArray());
                if (rvData.getLength() >= 22) {
                    int addinNameLen = BinaryTools.getUShort(rvData, 18);
                    int compNameLen = BinaryTools.getUShort(rvData, 20);
                    if (rvData.getLength() >= 22 + addinNameLen + compNameLen) {
                        StringBlock addinNameBlock = BinaryTools.getNullPadded(rvData.subBlock(22));
                        addinName = addinNameBlock.getString();
                        StringBlock compNameBlock = BinaryTools.getNullPadded(rvData.subBlock(22 + addinNameBlock.getTotalSize() + 1));
                        computerName = compNameBlock.getString();
                        flags = BinaryTools.getUInt(rvData, 22 + addinNameBlock.getTotalSize() + 1 + compNameBlock.getTotalSize() + 1);
                    }
                }
            }
        }
        this.code = code;
        this.uuid = uuid;
        this.addinName = addinName;
        this.computerName = computerName;
        this.flags = flags;
        this.invMessage = InvitationMessage.readInvitationMessage(chain);
    }

    public AddinsReqRvCmd(int code, String addinUri, ByteBlock uuid, String addinName, String computerName, long flags, InvitationMessage invMessage) {
        super(CapabilityBlock.BLOCK_ADDINS);
        DefensiveTools.checkRange(code, "code", -1);
        DefensiveTools.checkRange(flags, "flags", -1L);
        if (uuid != null && uuid.getLength() != 16) {
            throw new IllegalArgumentException("uuid length (" + uuid.getLength() + ") must be 16 if uuid is non-null");
        }
        this.code = code;
        this.addinUri = addinUri;
        this.uuid = uuid;
        this.addinName = addinName;
        this.computerName = computerName;
        this.flags = flags;
        this.invMessage = invMessage;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getAddinUri() {
        return this.addinUri;
    }

    public final ByteBlock getAddinUuid() {
        return this.uuid;
    }

    public final String getAddinName() {
        return this.addinName;
    }

    public final String getComputerName() {
        return this.computerName;
    }

    public final long getFlags() {
        return this.flags;
    }

    protected void writeRvTlvs(OutputStream out) throws IOException {
        if (this.addinUri != null) {
            Tlv.getStringInstance(7, this.addinUri).write(out);
        }
        if (this.invMessage != null) {
            this.invMessage.write(out);
        }
    }

    protected boolean hasServiceData() {
        return true;
    }

    protected void writeServiceData(OutputStream out) throws IOException {
        if (this.code != -1) {
            BinaryTools.writeUShort(out, this.code);
            if (this.uuid != null) {
                this.uuid.write(out);
                if (this.addinName != null && this.computerName != null) {
                    byte[] addinNameBytes = BinaryTools.getAsciiBytes(this.addinName);
                    byte[] compNameBytes = BinaryTools.getAsciiBytes(this.computerName);
                    BinaryTools.writeUShort(out, addinNameBytes.length);
                    BinaryTools.writeUShort(out, compNameBytes.length);
                    out.write(addinNameBytes);
                    out.write(0);
                    out.write(compNameBytes);
                    out.write(0);
                    if (this.flags != -1L) {
                        BinaryTools.writeUInt(out, this.flags);
                    }
                }
            }
        }
    }

    public String toString() {
        return "AddinsReqRvCmd: code=" + this.code + ", addinName=" + this.addinName + ", computerName=" + this.computerName + ", flags=0x" + Long.toHexString(this.flags) + ", message=<" + this.invMessage + ">, uri=" + this.addinUri;
    }
}

