/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.rooms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExchangeInfo;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.rooms.RoomCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomResponse
extends RoomCommand {
    private static final int TYPE_MAX_ROOMS = 2;
    private static final int TYPE_EXCHANGE_INFO = 3;
    private static final int TYPE_ROOM_INFO = 4;
    private final int maxRooms;
    private final List<ExchangeInfo> exchangeInfos;
    private final FullRoomInfo roomInfo;

    protected RoomResponse(SnacPacket packet) {
        super(9);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        Tlv maxRoomTlv = chain.getLastTlv(2);
        this.maxRooms = maxRoomTlv == null ? -1 : (int)BinaryTools.getUByte(maxRoomTlv.getData(), 0);
        LinkedList<ExchangeInfo> exchangeList = new LinkedList<ExchangeInfo>();
        for (Tlv exchangeTlv : chain.getTlvs(3)) {
            ByteBlock exTlvBlock = exchangeTlv.getData();
            ExchangeInfo exchange = ExchangeInfo.readExchangeInfo(exTlvBlock);
            if (exchange == null) continue;
            exchangeList.add(exchange);
        }
        this.exchangeInfos = exchangeList.isEmpty() ? null : exchangeList;
        Tlv roomInfoTlv = chain.getLastTlv(4);
        if (roomInfoTlv == null) {
            this.roomInfo = null;
        } else {
            ByteBlock roomInfoBlock = roomInfoTlv.getData();
            this.roomInfo = FullRoomInfo.readRoomInfo(roomInfoBlock);
        }
    }

    public RoomResponse(FullRoomInfo roomInfo) {
        this(-1, null, roomInfo);
    }

    public RoomResponse(int maxRooms, Collection<ExchangeInfo> exchangeInfos) {
        this(maxRooms, exchangeInfos, null);
    }

    public RoomResponse(int maxRooms, Collection<ExchangeInfo> exchangeInfos, FullRoomInfo roomInfo) {
        super(9);
        DefensiveTools.checkRange(maxRooms, "maxRooms", -1);
        this.maxRooms = maxRooms;
        this.exchangeInfos = DefensiveTools.getUnmodifiableCopy(exchangeInfos);
        this.roomInfo = roomInfo;
    }

    public final int getMaxRooms() {
        return this.maxRooms;
    }

    public final List<ExchangeInfo> getExchangeInfos() {
        return this.exchangeInfos;
    }

    public final FullRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        if (this.maxRooms != -1) {
            Tlv.getUShortInstance(2, this.maxRooms).write(out);
        }
        if (this.exchangeInfos != null) {
            for (int i = 0; i < this.exchangeInfos.size(); ++i) {
                new Tlv(3, ByteBlock.createByteBlock(this.exchangeInfos.get(i))).write(out);
            }
        }
        if (this.roomInfo != null) {
            new Tlv(4, ByteBlock.createByteBlock(this.roomInfo)).write(out);
        }
    }

    public String toString() {
        return "RoomResponse: maxRooms=" + this.maxRooms + ", exchangeInfos=" + (this.exchangeInfos == null ? -1 : this.exchangeInfos.size()) + ", roomInfo=" + this.roomInfo;
    }
}

