/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gdata.model.AdaptationRegistry;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementTransform;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.QName;
import com.google.gdata.model.Schema;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class AdaptationRegistryFactory {
    private static final Logger logger = Logger.getLogger(AdaptationRegistryFactory.class.getName());

    static AdaptationRegistry create(Schema schema, ElementTransform transform) {
        return new AdaptationRegistry(transform.getAdaptations(), AdaptationRegistryFactory.unionAttributes(schema, transform), AdaptationRegistryFactory.unionElements(schema, transform));
    }

    private static Map<QName, AttributeKey<?>> unionAttributes(Schema schema, ElementTransform transform) {
        LinkedHashMap union = Maps.newLinkedHashMap();
        Set<QName> base = AdaptationRegistryFactory.getAttributeNames(transform);
        HashSet invalid = Sets.newHashSet();
        for (ElementKey<?, ?> adaptorKey : transform.getAdaptations().values()) {
            ElementTransform adaptor = schema.getTransform((ElementKey<?, ?>)null, adaptorKey, (MetadataContext)null);
            if (adaptor == null) {
                throw new IllegalStateException("Invalid adaptor key " + adaptorKey);
            }
            for (ElementCreatorImpl.AttributeInfo info : adaptor.getAttributes().values()) {
                AttributeKey<?> key = info.key;
                QName id = key.getId();
                if (base.contains(id) || invalid.contains(id)) continue;
                AttributeKey existing = (AttributeKey)union.get(id);
                if (existing != null) {
                    if (AdaptationRegistryFactory.checkCompatible(existing, key)) continue;
                    union.remove(id);
                    invalid.add(id);
                    continue;
                }
                union.put(id, key);
            }
        }
        return ImmutableMap.copyOf((Map)union);
    }

    private static Set<QName> getAttributeNames(ElementTransform transform) {
        HashSet result = Sets.newHashSet();
        for (ElementCreatorImpl.AttributeInfo info : transform.getAttributes().values()) {
            result.add(info.key.getId());
        }
        return result;
    }

    private static Map<QName, ElementKey<?, ?>> unionElements(Schema schema, ElementTransform transform) {
        LinkedHashMap union = Maps.newLinkedHashMap();
        HashSet invalid = Sets.newHashSet();
        Set<QName> base = AdaptationRegistryFactory.getElementNames(transform);
        for (ElementKey<?, ?> adaptorKey : transform.getAdaptations().values()) {
            ElementTransform adaptor = schema.getTransform((ElementKey<?, ?>)null, adaptorKey, (MetadataContext)null);
            for (ElementCreatorImpl.ElementInfo info : adaptor.getElements().values()) {
                ElementKey<?, ?> key = info.key;
                QName id = key.getId();
                if (base.contains(id) || invalid.contains(id)) continue;
                ElementKey existing = (ElementKey)union.get(id);
                ElementKey<?, ?> compatible = key;
                if (existing != null) {
                    compatible = AdaptationRegistryFactory.checkCompatibleElements(existing, key);
                }
                if (compatible == null) {
                    union.remove(id);
                    invalid.add(id);
                    continue;
                }
                if (compatible != key) continue;
                union.put(id, key);
            }
        }
        return ImmutableMap.copyOf((Map)union);
    }

    private static Set<QName> getElementNames(ElementTransform transform) {
        HashSet result = Sets.newHashSet();
        for (ElementCreatorImpl.ElementInfo info : transform.getElements().values()) {
            result.add(info.key.getId());
        }
        return result;
    }

    private static boolean checkCompatible(MetadataKey<?> first, MetadataKey<?> second) {
        Class<?> secondType;
        boolean compatible = true;
        Class<?> firstType = first.getDatatype();
        if (firstType != (secondType = second.getDatatype())) {
            logger.warning("Incompatible datatypes.  First(" + first + "): " + firstType + " but Second(" + second + "): " + secondType);
            compatible = false;
        }
        return compatible;
    }

    private static ElementKey<?, ?> checkCompatibleElements(ElementKey<?, ?> first, ElementKey<?, ?> second) {
        Class<?> secondType;
        Class<?> firstType;
        ElementKey<?, ?> match = first;
        boolean compatible = true;
        if (!AdaptationRegistryFactory.checkCompatible(first, second)) {
            compatible = false;
        }
        if ((firstType = first.getElementType()) != (secondType = second.getElementType()) && !firstType.isAssignableFrom(secondType)) {
            if (secondType.isAssignableFrom(firstType)) {
                match = second;
            } else {
                logger.warning("Incompatible element types. First(" + first + "): " + firstType + " but Second(" + second + "): " + secondType);
                compatible = false;
            }
        }
        return compatible ? match : null;
    }

    private AdaptationRegistryFactory() {
    }
}

