/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gdata.model.AttributeCreatorImpl;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadataRegistry;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.Schema;
import com.google.gdata.model.TransformKey;
import com.google.gdata.util.common.base.Preconditions;
import java.util.Map;
import java.util.SortedMap;

final class AttributeMetadataRegistryBuilder {
    private final MetadataRegistry root;
    private final SortedMap<TransformKey, AttributeCreatorImpl> creators = Maps.newTreeMap();

    AttributeMetadataRegistryBuilder(MetadataRegistry root) {
        this.root = root;
    }

    void merge(AttributeMetadataRegistryBuilder other) {
        for (Map.Entry<TransformKey, AttributeCreatorImpl> entry : other.creators.entrySet()) {
            TransformKey key = entry.getKey();
            AttributeCreatorImpl creator = (AttributeCreatorImpl)this.creators.get(key);
            if (creator == null) {
                creator = new AttributeCreatorImpl(this.root, key);
                this.creators.put(key, creator);
            }
            creator.merge(entry.getValue());
        }
    }

    AttributeMetadataRegistry create(Schema schema) {
        return new AttributeMetadataRegistry(schema, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AttributeCreatorImpl build(ElementKey<?, ?> parent, AttributeKey<?> key, MetadataContext context) {
        Preconditions.checkNotNull(parent, "parent");
        Preconditions.checkNotNull(key, "key");
        TransformKey transformKey = TransformKey.forTransform(parent, key, context);
        MetadataRegistry metadataRegistry = this.root;
        synchronized (metadataRegistry) {
            AttributeCreatorImpl creator = (AttributeCreatorImpl)this.creators.get(transformKey);
            if (creator == null) {
                creator = new AttributeCreatorImpl(this.root, transformKey);
                this.creators.put(transformKey, creator);
                this.root.dirty();
            }
            return creator;
        }
    }

    Map<TransformKey, AttributeCreatorImpl> getCreators() {
        return ImmutableMap.copyOf(this.creators);
    }
}

