/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;

public class ChatRoomDestroyReasonDialog
extends MessageDialog {
    private static Logger logger = Logger.getLogger(ChatRoomDestroyReasonDialog.class);
    private static final long serialVersionUID = -916498752420264164L;
    private SIPCommTextField alternateAddress = new SIPCommTextField("chatroom@example.com");
    private JTextField reasonField = new JTextField();

    public ChatRoomDestroyReasonDialog(String title, String message) {
        super(null, title, message, DesktopUtilActivator.getResources().getI18NString("service.gui.OK"), false);
        this.setIcon((ImageIcon)null);
        this.alternateAddress.setFont(this.alternateAddress.getFont().deriveFont(12.0f));
        JLabel altAddressLabel = new JLabel(DesktopUtilActivator.getResources().getI18NString("service.gui.ALTERNATE_ADDRESS") + ":");
        JLabel reasonLabel = new JLabel(DesktopUtilActivator.getResources().getI18NString("service.gui.REASON") + ":");
        JPanel labelsPanel = new JPanel(new GridLayout(2, 1));
        labelsPanel.add(reasonLabel);
        labelsPanel.add(altAddressLabel);
        JPanel valuesPanel = new JPanel(new GridLayout(2, 1));
        valuesPanel.add(this.reasonField);
        valuesPanel.add(this.alternateAddress);
        JPanel fieldsPanel = new JPanel(new BorderLayout());
        fieldsPanel.add((Component)labelsPanel, "West");
        fieldsPanel.add((Component)valuesPanel, "Center");
        fieldsPanel.add((Component)new JLabel("          "), "East");
        fieldsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        fieldsPanel.setOpaque(false);
        this.replaceCheckBoxPanel(fieldsPanel);
        this.pack();
    }

    public String getAlternateAddress() {
        return this.alternateAddress.getText();
    }

    public String getReason() {
        return this.reasonField.getText();
    }

    public static String[] getDestroyOptions() {
        final ChatRoomDestroyReasonDialog[] res = new ChatRoomDestroyReasonDialog[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ResourceManagementService R = DesktopUtilActivator.getResources();
                    res[0] = new ChatRoomDestroyReasonDialog(R.getI18NString("service.gui.DESTROY_CHATROOM"), R.getI18NString("service.gui.DESTROY_MESSAGE"));
                }
            });
        }
        catch (Throwable t) {
            logger.error((Object)"Error creating dialog", t);
            return null;
        }
        ChatRoomDestroyReasonDialog reasonDialog = res[0];
        int result = reasonDialog.showDialog();
        String[] destroyOptions = new String[2];
        if (result == 0) {
            destroyOptions[0] = ChatRoomDestroyReasonDialog.proccessFieldValues(reasonDialog.getReason());
            destroyOptions[1] = ChatRoomDestroyReasonDialog.proccessFieldValues(reasonDialog.getAlternateAddress());
        } else {
            destroyOptions = null;
        }
        return destroyOptions;
    }

    private static String proccessFieldValues(String value) {
        if (value != null && (value = value.trim()).equals("")) {
            value = null;
        }
        return value;
    }
}

