/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.chat.ChatOperationReasonDialog;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.UtilActivator;

public class ChatRoomJoinOptionsDialog
extends ChatOperationReasonDialog {
    private static final long serialVersionUID = -916498752420264164L;
    private SIPCommTextField subject = new SIPCommTextField(DesktopUtilActivator.getResources().getI18NString("service.gui.SUBJECT"));
    private JLabel cmdExpandSubjectFields;
    private JPanel subjectFieldsPannel = new JPanel(new BorderLayout());

    public ChatRoomJoinOptionsDialog(String title, String message, boolean showReasonLabel, boolean disableOKIfReasonIsEmpty, boolean dontDisplaySubjectFields) {
        super(title, message, showReasonLabel, disableOKIfReasonIsEmpty);
        if (dontDisplaySubjectFields) {
            return;
        }
        JPanel subjectPanel = new JPanel(new BorderLayout());
        subjectPanel.setOpaque(false);
        subjectPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.subjectFieldsPannel.setBorder(BorderFactory.createEmptyBorder(10, 30, 0, 0));
        this.subjectFieldsPannel.setOpaque(false);
        this.subjectFieldsPannel.add((Component)this.subject, "Center");
        this.subjectFieldsPannel.setVisible(false);
        this.subject.setFont(this.getFont().deriveFont(12.0f));
        this.cmdExpandSubjectFields = new JLabel();
        this.cmdExpandSubjectFields.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.cmdExpandSubjectFields.setIcon(DesktopUtilActivator.getResources().getImage("service.gui.icons.RIGHT_ARROW_ICON"));
        this.cmdExpandSubjectFields.setText(DesktopUtilActivator.getResources().getI18NString("service.gui.SET_SUBJECT"));
        this.cmdExpandSubjectFields.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatRoomJoinOptionsDialog.this.cmdExpandSubjectFields.setIcon(UtilActivator.getResources().getImage(ChatRoomJoinOptionsDialog.this.subjectFieldsPannel.isVisible() ? "service.gui.icons.RIGHT_ARROW_ICON" : "service.gui.icons.DOWN_ARROW_ICON"));
                ChatRoomJoinOptionsDialog.this.subjectFieldsPannel.setVisible(!ChatRoomJoinOptionsDialog.this.subjectFieldsPannel.isVisible());
                ChatRoomJoinOptionsDialog.this.pack();
            }
        });
        subjectPanel.add((Component)this.cmdExpandSubjectFields, "North");
        subjectPanel.add((Component)this.subjectFieldsPannel, "Center");
        this.addToReasonFieldPannel(subjectPanel);
        this.pack();
    }

    public String getSubject() {
        return this.subject.getText();
    }

    public static String[] getJoinOptions(ProtocolProviderService pps, String chatRoomId, String defaultNickname) {
        return ChatRoomJoinOptionsDialog.getJoinOptions(false, pps, chatRoomId, defaultNickname);
    }

    public static String[] getJoinOptions(boolean dontDisplaySubjectFields, ProtocolProviderService pps, String chatRoomId, String defaultNickname) {
        int result;
        String nickName = null;
        ChatRoomJoinOptionsDialog reasonDialog = new ChatRoomJoinOptionsDialog(DesktopUtilActivator.getResources().getI18NString("service.gui.CHANGE_NICKNAME"), DesktopUtilActivator.getResources().getI18NString("service.gui.CHANGE_NICKNAME_LABEL"), false, true, dontDisplaySubjectFields);
        reasonDialog.setIcon(new ImageIcon(DesktopUtilActivator.getImage("service.gui.icons.CHANGE_NICKNAME_16x16")));
        if (defaultNickname != null) {
            reasonDialog.setReasonFieldText(defaultNickname);
        }
        if ((result = reasonDialog.showDialog()) == 0) {
            nickName = reasonDialog.getReason().trim();
            ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)pps, (String)chatRoomId, (String)"userNickName", (String)nickName);
        }
        String[] joinOptions = new String[]{nickName, reasonDialog.getSubject()};
        return joinOptions;
    }
}

