/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence.avatar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.FramedImageWithMenu;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommLinkButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.AvatarStackManager;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker.ImagePickerDialog;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.OperationSetAvatar;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountUtils;

public class SelectAvatarMenu
extends SIPCommPopupMenu
implements ActionListener {
    private static final Logger logger = Logger.getLogger(SelectAvatarMenu.class);
    private static final String CHOSE_BUTTON_NAME = "chooseButton";
    private static final String REMOVE_BUTTON_NAME = "removeButton";
    private static final String CLEAR_BUTTON_NAME = "clearButton";
    private static final int MAX_STORED_IMAGES = 8;
    private static final int IMAGES_PER_COLUMN = 4;
    private static final int THUMB_WIDTH = 48;
    private static final int THUMB_HEIGHT = 48;
    private SIPCommButton[] recentImagesButtons = new SIPCommButton[8];
    private int nextImageIndex = 0;
    private FramedImageWithMenu avatarImage;
    private AccountID accountID;

    public SelectAvatarMenu(FramedImageWithMenu avatarImage) {
        this.avatarImage = avatarImage;
        this.init();
        this.pack();
    }

    public void setAccountID(AccountID accountID) {
        this.accountID = accountID;
    }

    private void init() {
        TransparentPanel panel = new TransparentPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel titleLabel = new JLabel(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.RECENT_ICONS"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        titleLabel.setForeground(new JMenuItem().getForeground());
        panel.add(titleLabel, "North");
        TransparentPanel recentImagesGrid = new TransparentPanel();
        recentImagesGrid.setLayout(new GridLayout(0, 4));
        Dimension thumbsize = new Dimension(48, 48);
        for (int i = 0; i < 8; ++i) {
            this.recentImagesButtons[i] = new SIPCommButton(null);
            this.recentImagesButtons[i].setBorder(BorderFactory.createEtchedBorder());
            this.recentImagesButtons[i].setMaximumSize(thumbsize);
            this.recentImagesButtons[i].setMinimumSize(thumbsize);
            this.recentImagesButtons[i].setPreferredSize(thumbsize);
            this.recentImagesButtons[i].addActionListener(this);
            this.recentImagesButtons[i].setName("" + i);
            recentImagesGrid.add(this.recentImagesButtons[i]);
        }
        panel.add((Component)((Object)recentImagesGrid), "Center");
        TransparentPanel buttonsPanel = new TransparentPanel();
        buttonsPanel.setLayout(new GridLayout(0, 1));
        Color linkColor = new JMenuItem().getForeground();
        SelectAvatarMenu.addActionButton(buttonsPanel, this, DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.CHOOSE_ICON"), CHOSE_BUTTON_NAME, linkColor);
        SelectAvatarMenu.addActionButton(buttonsPanel, this, DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.REMOVE_ICON"), REMOVE_BUTTON_NAME, linkColor);
        SelectAvatarMenu.addActionButton(buttonsPanel, this, DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.CLEAR_RECENT"), CLEAR_BUTTON_NAME, linkColor);
        panel.add((Component)((Object)buttonsPanel), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)panel), "Center");
    }

    private static void addActionButton(TransparentPanel buttonsPanel, ActionListener listener, String text, String name, Color linkColor) {
        SIPCommLinkButton button = new SIPCommLinkButton(text);
        button.setName(name);
        button.addActionListener(listener);
        button.setOpaque(false);
        button.setLinkColor(linkColor);
        TransparentPanel panel = new TransparentPanel(new BorderLayout());
        panel.add(button, "West");
        buttonsPanel.add((Component)((Object)panel));
    }

    @Override
    public void setVisible(boolean b) {
        this.refreshRecentImages();
        super.setVisible(b);
    }

    public void refreshRecentImages() {
        BufferedImage image;
        int i;
        for (i = 0; i < 8 && (image = AvatarStackManager.loadImage(i)) != null; ++i) {
            this.recentImagesButtons[i].setImage(SelectAvatarMenu.createThumbnail(image));
            this.recentImagesButtons[i].setEnabled(true);
        }
        if (i < 8) {
            this.nextImageIndex = i;
            while (i < 8) {
                this.recentImagesButtons[i].setImage(null);
                this.recentImagesButtons[i].setEnabled(false);
                ++i;
            }
        } else {
            this.nextImageIndex = 8;
        }
    }

    private static BufferedImage createThumbnail(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (width < 48 && height < 48) {
            return image;
        }
        Image i = width > height ? image.getScaledInstance(48, -1, 4) : image.getScaledInstance(-1, 48, 4);
        return ImageUtils.getBufferedImage(i);
    }

    private void setNewImage(final BufferedImage image) {
        new Thread(){

            @Override
            public void run() {
                AccountManager accountManager = DesktopUtilActivator.getAccountManager();
                for (AccountID accountID : accountManager.getStoredAccounts()) {
                    byte[] imageByte;
                    ProtocolProviderService protocolProvider;
                    if (!accountManager.isAccountLoaded(accountID) || (protocolProvider = AccountUtils.getRegisteredProviderForAccount((AccountID)accountID)) == null || !protocolProvider.isRegistered()) continue;
                    if (SelectAvatarMenu.this.accountID != null) {
                        OperationSetServerStoredAccountInfo opSet;
                        if (!accountID.equals((Object)SelectAvatarMenu.this.accountID) || (opSet = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class)) == null) continue;
                        imageByte = null;
                        if (image != null) {
                            imageByte = ImageUtils.toByteArray(image);
                        }
                        SelectAvatarMenu.this.avatarImage.setImageIcon(imageByte);
                        ServerStoredDetails.ImageDetail newDetail = new ServerStoredDetails.ImageDetail("avatar", imageByte);
                        Iterator oldDetail = opSet.getDetails(ServerStoredDetails.ImageDetail.class);
                        try {
                            if (oldDetail.hasNext()) {
                                opSet.replaceDetail((ServerStoredDetails.GenericDetail)oldDetail.next(), (ServerStoredDetails.GenericDetail)newDetail);
                                continue;
                            }
                            opSet.addDetail((ServerStoredDetails.GenericDetail)newDetail);
                        }
                        catch (Throwable t) {
                            logger.error((Object)"Error setting image", t);
                        }
                        continue;
                    }
                    OperationSetAvatar opSetAvatar = (OperationSetAvatar)protocolProvider.getOperationSet(OperationSetAvatar.class);
                    if (opSetAvatar == null) continue;
                    imageByte = null;
                    if (image != null) {
                        imageByte = ImageUtils.toByteArray(image);
                    }
                    try {
                        opSetAvatar.setAvatar(imageByte);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Error setting image", t);
                    }
                }
            }
        }.start();
    }

    private void clearRecentImages() {
        for (int i = 0; i < 8; ++i) {
            this.recentImagesButtons[i].setImage(null);
            this.recentImagesButtons[i].setEnabled(false);
            AvatarStackManager.deleteImage(i);
        }
        this.nextImageIndex = 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton src = (JButton)e.getSource();
        if (src instanceof SIPCommButton) {
            int index = Integer.parseInt(src.getName());
            BufferedImage image = AvatarStackManager.loadImage(index);
            this.setNewImage(image);
        } else if (src.getName().equals(CHOSE_BUTTON_NAME)) {
            ImagePickerDialog dialog = new ImagePickerDialog(96, 96);
            Image currentImage = this.avatarImage.getAvatar();
            byte[] bimage = dialog.showDialog(currentImage);
            if (bimage == null) {
                return;
            }
            BufferedImage image = ImageUtils.getBufferedImage(new ImageIcon(bimage).getImage());
            if (this.nextImageIndex == 8) {
                AvatarStackManager.popFirstImage(8);
                this.nextImageIndex = 7;
            }
            AvatarStackManager.storeImage(image, this.nextImageIndex);
            this.setNewImage(image);
        } else if (src.getName().equals(REMOVE_BUTTON_NAME)) {
            this.setNewImage(null);
        } else if (src.getName().equals(CLEAR_BUTTON_NAME)) {
            this.clearRecentImages();
        }
        this.setVisible(false);
    }
}

