/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.msoutlook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.sip.communicator.plugin.addrbook.AbstractAddrBookContactQuery;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactDetail;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactSourceService;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookSourceContact;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookMAPIHResultException;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.util.Logger;

public class MsOutlookAddrBookContactQuery
extends AbstractAddrBookContactQuery<MsOutlookAddrBookContactSourceService> {
    private static final Logger logger = Logger.getLogger(MsOutlookAddrBookContactQuery.class);
    public static final int dispidEmail1EmailAddress = 12;
    public static final int dispidEmail2EmailAddress = 13;
    public static final int dispidEmail3EmailAddress = 14;
    private static final long MAPI_MAILUSER = 6L;
    public static final long[] MAPI_MAILUSER_PROP_IDS = new long[]{12289L, 12291L, 14854L, 14916L, 14865L, 14856L, 14875L, 14857L, 14895L, 14876L, 14879L, 4094L, 32900L, 32916L, 32932L, 14870L, 4095L, 14884L, 14885L, 14883L, 14927L, 14917L, 14928L, 14929L, 14871L, 32866L, 32838L, 32841L, 32840L, 32839L, 32837L, 14937L, 14938L, 14939L, 14940L, 14941L, 32794L, 32795L};
    private static final long MAPI_MESSAGE = 5L;
    public static final long MAPI_UNICODE = Integer.MIN_VALUE;
    public static final long PR_ATTACHMENT_CONTACTPHOTO = 32767L;
    public static final int PR_BUSINESS_TELEPHONE_NUMBER = 5;
    public static final int PR_BUSINESS2_TELEPHONE_NUMBER = 6;
    public static final int PR_COMPANY_NAME = 15;
    public static final int PR_DISPLAY_NAME = 0;
    public static final int PR_EMAIL_ADDRESS = 1;
    public static final int PR_GIVEN_NAME = 2;
    public static final int PR_HOME_TELEPHONE_NUMBER = 7;
    public static final int PR_HOME2_TELEPHONE_NUMBER = 8;
    public static final int PR_MIDDLE_NAME = 3;
    public static final int PR_MOBILE_TELEPHONE_NUMBER = 9;
    public static final int PR_OTHER_TELEPHONE_NUMBER = 10;
    public static final int PR_OBJECT_TYPE = 11;
    public static final int PR_SURNAME = 4;
    public static final int PR_ORIGINAL_ENTRYID = 16;
    public static final int dispidFax1EmailAddress = 17;
    public static final int dispidFax2EmailAddress = 18;
    public static final int dispidFax3EmailAddress = 19;
    public static final int PR_NICKNAME = 20;
    public static final int PR_DISPLAY_NAME_PREFIX = 21;
    public static final int PR_PERSONAL_HOME_PAGE = 22;
    public static final int PR_BUSINESS_HOME_PAGE = 23;
    public static final int PR_TITLE = 24;
    public static final int dispidInstMsg = 25;
    public static final int PR_BUSINESS_ADDRESS_CITY = 26;
    public static final int PR_BUSINESS_ADDRESS_COUNTRY = 27;
    public static final int PR_BUSINESS_ADDRESS_POSTAL_CODE = 28;
    public static final int PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE = 29;
    public static final int PR_BUSINESS_ADDRESS_STREET = 30;
    public static final int PR_HOME_ADDRESS_CITY = 31;
    public static final int PR_HOME_ADDRESS_COUNTRY = 32;
    public static final int PR_HOME_ADDRESS_POSTAL_CODE = 33;
    public static final int PR_HOME_ADDRESS_STATE_OR_PROVINCE = 34;
    public static final int PR_HOME_ADDRESS_STREET = 35;
    public static final int dispidHomeAddress = 36;
    public static final int dispidWorkAddress = 37;
    public static final int[] CONTACT_DETAIL_PROP_INDEXES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
    private static final int[] CONTACT_OPERATION_SET_ABLE_PROP_INDEXES = new int[]{1, 5, 6, 7, 8, 9, 10, 12, 13, 14, 17, 18, 19, 25};
    private int mapiMessageCount;
    private boolean firstIMAPIPropGetPropFailureLogged = false;

    public MsOutlookAddrBookContactQuery(MsOutlookAddrBookContactSourceService msoabcss, Pattern query) {
        super(msoabcss, query);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating new query:" + query));
        }
    }

    public static native void foreachMailUser(String var0, PtrOutlookContactCallback var1);

    public static ContactDetail.Category getCategory(int propIndex) {
        switch (propIndex) {
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 21: 
            case 22: {
                return ContactDetail.Category.Personal;
            }
            case 15: 
            case 23: 
            case 24: {
                return ContactDetail.Category.Organization;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: {
                return ContactDetail.Category.Email;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: {
                return ContactDetail.Category.Phone;
            }
            case 25: {
                return ContactDetail.Category.InstantMessaging;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return ContactDetail.Category.Address;
            }
        }
        return null;
    }

    public static ContactDetail.SubCategory[] getSubCategories(int propIndex) {
        switch (propIndex) {
            case 2: 
            case 3: 
            case 15: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Name};
            }
            case 4: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.LastName};
            }
            case 20: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Nickname};
            }
            case 1: 
            case 5: 
            case 6: 
            case 13: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work};
            }
            case 7: 
            case 8: 
            case 12: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home};
            }
            case 9: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Mobile};
            }
            case 10: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Other};
            }
            case 17: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Fax};
            }
            case 14: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Other};
            }
            case 24: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.JobTitle};
            }
            case 26: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work, ContactDetail.SubCategory.City};
            }
            case 27: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work, ContactDetail.SubCategory.Country};
            }
            case 28: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work, ContactDetail.SubCategory.PostalCode};
            }
            case 29: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work, ContactDetail.SubCategory.State};
            }
            case 30: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work, ContactDetail.SubCategory.Street};
            }
            case 31: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home, ContactDetail.SubCategory.City};
            }
            case 32: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home, ContactDetail.SubCategory.Country};
            }
            case 33: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home, ContactDetail.SubCategory.PostalCode};
            }
            case 34: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home, ContactDetail.SubCategory.State};
            }
            case 35: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home, ContactDetail.SubCategory.Street};
            }
            case 36: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home};
            }
            case 37: {
                return new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work};
            }
        }
        return null;
    }

    public static long getProperty(ContactDetail.Category category, Collection<ContactDetail.SubCategory> subCategories) {
        int i = -1;
        switch (category) {
            case Personal: {
                if (subCategories.contains(ContactDetail.SubCategory.Name)) {
                    i = 2;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.LastName)) {
                    i = 4;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Nickname)) {
                    i = 20;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.HomePage)) {
                    i = 22;
                    break;
                }
                i = 21;
                break;
            }
            case Organization: {
                if (subCategories.contains(ContactDetail.SubCategory.Name)) {
                    i = 15;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.JobTitle)) {
                    i = 24;
                    break;
                }
                i = 23;
                break;
            }
            case Email: {
                if (subCategories.contains(ContactDetail.SubCategory.Work)) {
                    i = 13;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Home)) {
                    i = 12;
                    break;
                }
                if (!subCategories.contains(ContactDetail.SubCategory.Other)) break;
                i = 14;
                break;
            }
            case Phone: {
                if (subCategories.contains(ContactDetail.SubCategory.Fax)) {
                    i = 17;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Work)) {
                    i = 5;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Home)) {
                    i = 7;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Mobile)) {
                    i = 9;
                    break;
                }
                if (!subCategories.contains(ContactDetail.SubCategory.Other)) break;
                i = 10;
                break;
            }
            case InstantMessaging: {
                i = 25;
                break;
            }
            case Address: {
                if (subCategories.contains(ContactDetail.SubCategory.Work)) {
                    if (subCategories.contains(ContactDetail.SubCategory.City)) {
                        i = 26;
                        break;
                    }
                    if (subCategories.contains(ContactDetail.SubCategory.Country)) {
                        i = 27;
                        break;
                    }
                    if (subCategories.contains(ContactDetail.SubCategory.PostalCode)) {
                        i = 28;
                        break;
                    }
                    if (subCategories.contains(ContactDetail.SubCategory.State)) {
                        i = 29;
                        break;
                    }
                    if (subCategories.contains(ContactDetail.SubCategory.Street)) {
                        i = 30;
                        break;
                    }
                    i = 37;
                    break;
                }
                if (!subCategories.contains(ContactDetail.SubCategory.Home)) break;
                if (subCategories.contains(ContactDetail.SubCategory.City)) {
                    i = 31;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Country)) {
                    i = 32;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.PostalCode)) {
                    i = 33;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.State)) {
                    i = 34;
                    break;
                }
                if (subCategories.contains(ContactDetail.SubCategory.Street)) {
                    i = 35;
                    break;
                }
                i = 36;
                break;
            }
        }
        return i >= 0 ? MAPI_MAILUSER_PROP_IDS[i] : -1L;
    }

    public static native Object[] IMAPIProp_GetProps(String var0, long[] var1, long var2) throws MsOutlookMAPIHResultException;

    public static native boolean IMAPIProp_SetPropString(long var0, String var2, String var3);

    public static native boolean IMAPIProp_DeleteProp(long var0, String var2);

    public static native boolean deleteContact(String var0);

    public static native String createContact();

    public static native boolean compareEntryIds(String var0, String var1);

    private static boolean isPhoneNumber(int propIndex) {
        switch (propIndex) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private boolean matches(int property, String value) {
        return this.query.matcher(value).find() || MsOutlookAddrBookContactQuery.isPhoneNumber(property) && this.phoneNumberMatches(value);
    }

    private synchronized boolean onMailUser(String id) throws MsOutlookMAPIHResultException {
        Object[] props = null;
        try {
            props = MsOutlookAddrBookContactQuery.IMAPIProp_GetProps(id, MAPI_MAILUSER_PROP_IDS, Integer.MIN_VALUE);
        }
        catch (MsOutlookMAPIHResultException ex) {
            String hresult = ex.getHresultString();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(MsOutlookAddrBookContactQuery.class.getSimpleName() + "#onMailUser(String)"), (Throwable)ex);
            }
            if ("MAPI_E_0x57".equals(hresult)) {
                if (!this.firstIMAPIPropGetPropFailureLogged) {
                    this.firstIMAPIPropGetPropFailureLogged = true;
                    throw ex;
                }
            } else {
                throw ex;
            }
            return true;
        }
        long objType = 0L;
        if (props == null || props[11] == null || !(props[11] instanceof Long)) {
            logger.error((Object)"Wrong object types. We are canceling the query.");
            return false;
        }
        objType = (Long)props[11];
        if (6L == objType && this.mapiMessageCount != 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Duplicate contacts. We are canceling the query.");
            }
            return false;
        }
        int propIndex = 0;
        boolean matches = false;
        for (int i = 0; i < props.length; ++i) {
            Object prop = props[i];
            if (prop instanceof String && this.matches(propIndex, (String)prop) && i != 16) {
                matches = true;
                break;
            }
            ++propIndex;
        }
        if (matches) {
            List<ContactDetail> contactDetails = MsOutlookAddrBookContactQuery.getContactDetails(props);
            if (!contactDetails.isEmpty()) {
                MsOutlookAddrBookSourceContact sourceContact;
                block19: {
                    String displayName = MsOutlookAddrBookContactQuery.getDisplayName(props);
                    sourceContact = new MsOutlookAddrBookSourceContact(this.getContactSource(), (String)props[16], displayName, MsOutlookAddrBookContactQuery.getOrganization(props), contactDetails);
                    if (5L == objType) {
                        ++this.mapiMessageCount;
                        try {
                            Object[] images = MsOutlookAddrBookContactQuery.IMAPIProp_GetProps(id, new long[]{32767L}, 0L);
                            Object image = images[0];
                            if (image instanceof byte[]) {
                                sourceContact.setImage((byte[])image);
                            }
                        }
                        catch (MsOutlookMAPIHResultException ex) {
                            if (!logger.isTraceEnabled()) break block19;
                            logger.trace((Object)"Retrieving the image property of the contact failed.", (Throwable)ex);
                        }
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("For query: " + this.query + " found contact:" + sourceContact.getDisplayName() + ", " + sourceContact.getContactAddress()));
                }
                this.addQueryResult((SourceContact)sourceContact);
            } else {
                logger.error((Object)"Error creating the found contact. Contact details are empty.");
            }
        }
        return this.getStatus() == 3;
    }

    public static List<ContactDetail> getContactDetails(Object[] values) {
        ArrayList<Class> supportedOpSets = new ArrayList<Class>(2);
        supportedOpSets.add(OperationSetBasicTelephony.class);
        supportedOpSets.add(OperationSetPersistentPresence.class);
        LinkedList<ContactDetail> contactDetails = new LinkedList<ContactDetail>();
        for (int i = 0; i < CONTACT_DETAIL_PROP_INDEXES.length; ++i) {
            String stringValue;
            int property = CONTACT_DETAIL_PROP_INDEXES[i];
            Object value = values[property];
            if (!(value instanceof String) || (stringValue = (String)value).length() == 0) continue;
            if (MsOutlookAddrBookContactQuery.isPhoneNumber(property)) {
                stringValue = AddrBookActivator.getPhoneNumberI18nService().normalize(stringValue);
            }
            MsOutlookAddrBookContactDetail contactDetail = new MsOutlookAddrBookContactDetail(stringValue, MsOutlookAddrBookContactQuery.getCategory(property), MsOutlookAddrBookContactQuery.getSubCategories(property), MAPI_MAILUSER_PROP_IDS[property]);
            for (int j = 0; j < CONTACT_OPERATION_SET_ABLE_PROP_INDEXES.length; ++j) {
                if (property != CONTACT_OPERATION_SET_ABLE_PROP_INDEXES[j]) continue;
                contactDetail.setSupportedOpSets(supportedOpSets);
                j = CONTACT_OPERATION_SET_ABLE_PROP_INDEXES.length;
            }
            contactDetails.add((ContactDetail)contactDetail);
        }
        return contactDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        Class<MsOutlookAddrBookContactQuery> clazz = MsOutlookAddrBookContactQuery.class;
        synchronized (MsOutlookAddrBookContactQuery.class) {
            long start = System.currentTimeMillis();
            MsOutlookAddrBookContactQuery.foreachMailUser(this.query.toString(), new PtrOutlookContactCallback());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Query " + this.query + " took " + (System.currentTimeMillis() - start) + " ms."));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inserted(String id) {
        Class<MsOutlookAddrBookContactQuery> clazz = MsOutlookAddrBookContactQuery.class;
        synchronized (MsOutlookAddrBookContactQuery.class) {
            this.insertedOrUpdated(id, 0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String id) {
        Class<MsOutlookAddrBookContactQuery> clazz = MsOutlookAddrBookContactQuery.class;
        synchronized (MsOutlookAddrBookContactQuery.class) {
            this.insertedOrUpdated(id, 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void insertedOrUpdated(String id, int maxLevel) {
        block4: {
            SourceContact sourceContact = this.findSourceContactByID(id, maxLevel);
            if (sourceContact != null && sourceContact instanceof MsOutlookAddrBookSourceContact) {
                ((MsOutlookAddrBookSourceContact)sourceContact).updated();
                this.fireContactChanged(sourceContact);
            } else {
                try {
                    this.onMailUser(id);
                }
                catch (MsOutlookMAPIHResultException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)(MsOutlookAddrBookContactQuery.class.getSimpleName() + "#onMailUser(String)"), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleted(String id) {
        if (id == null) return;
        Class<MsOutlookAddrBookContactQuery> clazz = MsOutlookAddrBookContactQuery.class;
        synchronized (MsOutlookAddrBookContactQuery.class) {
            SourceContact sourceContact = this.findSourceContactByID(id, 1);
            if (sourceContact == null) return;
            this.fireContactRemoved(sourceContact);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addEmptyContact(String id) {
        if (id != null) {
            MsOutlookAddrBookSourceContact sourceContact = new MsOutlookAddrBookSourceContact(this.getContactSource(), id, null, null, new LinkedList<ContactDetail>());
            this.addQueryResult((SourceContact)sourceContact);
        }
    }

    public static String getDisplayName(Object[] values) {
        String displayName = (String)values[20];
        if (displayName == null || displayName.length() == 0) {
            String firstName = (String)values[2];
            String lastName = (String)values[4];
            if (lastName == null || lastName.length() == 0) {
                lastName = (String)values[3];
            }
            if (firstName == null || firstName.length() == 0) {
                displayName = lastName;
            } else {
                displayName = firstName;
                if (lastName != null && lastName.length() != 0) {
                    displayName = displayName + " " + lastName;
                }
            }
        }
        if (displayName == null || displayName.length() == 0) {
            displayName = (String)values[15];
        }
        if (displayName == null || displayName.length() == 0) {
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] instanceof String) || (displayName = (String)values[i]) == null || displayName.length() == 0) continue;
                return displayName;
            }
        }
        return displayName;
    }

    public static String getOrganization(Object[] values) {
        return (String)values[15];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceContact findSourceContactByID(String id, int maxLevel) {
        List list = this.sourceContacts;
        synchronized (list) {
            for (int level = 0; level <= maxLevel; ++level) {
                for (SourceContact sc : this.sourceContacts) {
                    if (!(sc instanceof MsOutlookAddrBookSourceContact) || !((MsOutlookAddrBookSourceContact)sc).match(id, level)) continue;
                    return sc;
                }
            }
        }
        return null;
    }

    static {
        System.loadLibrary("jmsoutlookaddrbook");
    }

    public class PtrOutlookContactCallback {
        boolean callback(String id) {
            try {
                return MsOutlookAddrBookContactQuery.this.onMailUser(id);
            }
            catch (MsOutlookMAPIHResultException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(MsOutlookAddrBookContactQuery.class.getSimpleName() + "#onMailUser(String)"), (Throwable)e);
                }
                return false;
            }
        }
    }
}

