/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.usersearch;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.sip.communicator.plugin.usersearch.UserSearchActivator;
import net.java.sip.communicator.plugin.usersearch.UserSearchContactSource;
import net.java.sip.communicator.plugin.usersearch.UserSearchSupportedProviderListener;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SortedGenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetUserSearch;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class UserSearchQuery
extends AsyncContactQuery<ContactSourceService>
implements UserSearchSupportedProviderListener {
    private String queryString;
    private List<UserSearchContact> contacts = new LinkedList<UserSearchContact>();
    private List<ProtocolProviderService> displayedProviders = new LinkedList<ProtocolProviderService>();
    private int contactQueryListenersCount = 0;

    public UserSearchQuery(String queryString, UserSearchContactSource contactSource) {
        super((ContactSourceService)contactSource, Pattern.compile(queryString, 18), true);
        this.queryString = queryString;
    }

    protected void run() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.getStatus() == 1) {
            return;
        }
        for (ProtocolProviderService provider : UserSearchActivator.getSupportedProviders()) {
            this.providerAdded(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void providerAdded(ProtocolProviderService provider) {
        List<ProtocolProviderService> list = this.displayedProviders;
        synchronized (list) {
            if (this.displayedProviders.contains(provider)) {
                return;
            }
            this.displayedProviders.add(provider);
        }
        OperationSetUserSearch opSetUserSearch = (OperationSetUserSearch)provider.getOperationSet(OperationSetUserSearch.class);
        if (opSetUserSearch == null) {
            return;
        }
        opSetUserSearch.createSearchManager();
        List jidList = opSetUserSearch.search(this.queryString);
        if (jidList == null || jidList.isEmpty()) {
            return;
        }
        ArrayList<Class> supportedOpSets = new ArrayList<Class>(2);
        supportedOpSets.add(OperationSetPersistentPresence.class);
        supportedOpSets.add(OperationSetBasicInstantMessaging.class);
        ContactDetail detail = new ContactDetail(this.queryString);
        for (String jid : jidList) {
            LinkedList<ContactDetail> contactDetails = new LinkedList<ContactDetail>();
            ContactDetail jidDetail = new ContactDetail(jid);
            jidDetail.setSupportedOpSets(supportedOpSets);
            contactDetails.add(jidDetail);
            contactDetails.add(detail);
            UserSearchContact contact = new UserSearchContact((ContactQuery)this, this.getContactSource(), jid, contactDetails, provider);
            contact.setContactAddress(jid);
            List<UserSearchContact> list2 = this.contacts;
            synchronized (list2) {
                this.contacts.add(contact);
            }
            this.fireContactReceived((SourceContact)contact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void providerRemoved(ProtocolProviderService provider) {
        LinkedList<UserSearchContact> tmpContacts;
        List<ProtocolProviderService> list = this.displayedProviders;
        synchronized (list) {
            this.displayedProviders.remove(provider);
        }
        OperationSetUserSearch opSetUserSearch = (OperationSetUserSearch)provider.getOperationSet(OperationSetUserSearch.class);
        if (opSetUserSearch == null) {
            return;
        }
        opSetUserSearch.removeSearchManager();
        List<UserSearchContact> list2 = this.contacts;
        synchronized (list2) {
            tmpContacts = new LinkedList<UserSearchContact>(this.contacts);
        }
        for (UserSearchContact contact : tmpContacts) {
            if (!contact.getProvider().equals(provider)) continue;
            List<UserSearchContact> list3 = this.contacts;
            synchronized (list3) {
                this.contacts.remove((Object)contact);
            }
            this.fireContactRemoved((SourceContact)contact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        UserSearchActivator.removeUserSearchSupportedProviderListener(this);
        List<UserSearchContact> list = this.contacts;
        synchronized (list) {
            this.contacts.clear();
        }
        list = this.displayedProviders;
        synchronized (list) {
            this.displayedProviders.clear();
        }
    }

    public void cancel() {
        this.dispose();
        super.cancel();
    }

    public void setStatus(int status) {
        if (status == 1) {
            this.dispose();
        }
        super.setStatus(status);
    }

    public void addContactQueryListener(ContactQueryListener l) {
        super.addContactQueryListener(l);
        ++this.contactQueryListenersCount;
        if (this.contactQueryListenersCount == 1) {
            UserSearchActivator.addUserSearchSupportedProviderListener(this);
        }
    }

    public void removeContactQueryListener(ContactQueryListener l) {
        super.removeContactQueryListener(l);
        --this.contactQueryListenersCount;
        if (this.contactQueryListenersCount == 0) {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SourceContact> getQueryResults() {
        LinkedList<UserSearchContact> queryResults;
        List<UserSearchContact> list = this.contacts;
        synchronized (list) {
            queryResults = new LinkedList<UserSearchContact>(this.contacts);
        }
        return queryResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryResultCount() {
        List<UserSearchContact> list = this.contacts;
        synchronized (list) {
            return this.contacts.size();
        }
    }

    private class UserSearchContact
    extends SortedGenericSourceContact {
        private ProtocolProviderService provider;

        public UserSearchContact(ContactQuery parentQuery, ContactSourceService cSourceService, String displayName, List<ContactDetail> contactDetails, ProtocolProviderService provider) {
            super(parentQuery, cSourceService, displayName, contactDetails);
            this.provider = provider;
        }

        public ProtocolProviderService getProvider() {
            return this.provider;
        }
    }
}

