/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.contactsource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.contactsource.AbstractContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceActivator;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;

public abstract class AsyncContactQuery<T extends ContactSourceService>
extends AbstractContactQuery<T> {
    private String phoneNumberQuery;
    protected final Pattern query;
    private boolean queryIsConvertedToPhoneNumber;
    private Collection<SourceContact> queryResults = new LinkedList<SourceContact>();
    private Thread thread;

    protected AsyncContactQuery(T contactSource, Pattern query, boolean isSorted) {
        super(contactSource);
        this.query = query;
        if (isSorted) {
            this.queryResults = new TreeSet<SourceContact>();
        }
    }

    protected AsyncContactQuery(T contactSource, Pattern query) {
        super(contactSource);
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addQueryResult(SourceContact sourceContact, boolean showMoreEnabled) {
        boolean changed;
        Collection<SourceContact> collection = this.queryResults;
        synchronized (collection) {
            changed = this.queryResults.add(sourceContact);
        }
        if (changed) {
            this.fireContactReceived(sourceContact, showMoreEnabled);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addQueryResult(SourceContact sourceContact) {
        boolean changed;
        Collection<SourceContact> collection = this.queryResults;
        synchronized (collection) {
            changed = this.queryResults.add(sourceContact);
        }
        if (changed) {
            this.fireContactReceived(sourceContact);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeQueryResult(SourceContact sourceContact) {
        boolean changed;
        Collection<SourceContact> collection = this.queryResults;
        synchronized (collection) {
            changed = this.queryResults.remove(sourceContact);
        }
        if (changed) {
            this.fireContactRemoved(sourceContact);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addQueryResults(Set<? extends SourceContact> sourceContacts) {
        boolean changed;
        Collection<SourceContact> collection = this.queryResults;
        synchronized (collection) {
            changed = this.queryResults.addAll(sourceContacts);
        }
        if (changed) {
            for (SourceContact sourceContact : sourceContacts) {
                this.fireContactReceived(sourceContact, false);
            }
        }
        return changed;
    }

    protected String getPhoneNumberQuery() {
        if (this.phoneNumberQuery == null && !this.queryIsConvertedToPhoneNumber) {
            try {
                String pattern = this.query.pattern();
                if (pattern != null) {
                    int patternLength = pattern.length();
                    if (patternLength > 2 && pattern.charAt(0) == '^' && pattern.charAt(patternLength - 1) == '$') {
                        this.phoneNumberQuery = pattern.substring(1, patternLength - 1);
                    } else if (patternLength > 4 && pattern.charAt(0) == '\\' && pattern.charAt(1) == 'Q' && pattern.charAt(patternLength - 2) == '\\' && pattern.charAt(patternLength - 1) == 'E') {
                        this.phoneNumberQuery = pattern.substring(2, patternLength - 2);
                    }
                }
            }
            finally {
                this.queryIsConvertedToPhoneNumber = true;
            }
        }
        return this.phoneNumberQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryResultCount() {
        Collection<SourceContact> collection = this.queryResults;
        synchronized (collection) {
            return this.queryResults.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceContact> getQueryResults() {
        ArrayList<SourceContact> qr;
        Collection<SourceContact> collection = this.queryResults;
        synchronized (collection) {
            qr = new ArrayList<SourceContact>(this.queryResults.size());
            qr.addAll(this.queryResults);
        }
        return qr;
    }

    @Override
    public String getQueryString() {
        return this.query.toString();
    }

    protected abstract void run();

    @Override
    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalStateException("thread");
        }
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean completed = false;
                try {
                    AsyncContactQuery.this.run();
                    completed = true;
                }
                finally {
                    AsyncContactQuery asyncContactQuery = AsyncContactQuery.this;
                    synchronized (asyncContactQuery) {
                        if (AsyncContactQuery.this.thread == Thread.currentThread()) {
                            AsyncContactQuery.this.stopped(completed);
                        }
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void stopped(boolean completed) {
        if (this.getStatus() == 3) {
            this.setStatus(completed ? 0 : 2);
        }
    }

    protected boolean phoneNumberMatches(String phoneNumber) {
        boolean phoneNumberMatches = false;
        if (this.query.matcher(ContactSourceActivator.getPhoneNumberI18nService().normalize(phoneNumber)).find()) {
            phoneNumberMatches = true;
        } else {
            String phoneNumberQuery = this.getPhoneNumberQuery();
            if (phoneNumberQuery != null && phoneNumberQuery.length() != 0) {
                try {
                    phoneNumberMatches = ContactSourceActivator.getPhoneNumberI18nService().phoneNumbersMatch(phoneNumberQuery, phoneNumber);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return phoneNumberMatches;
    }
}

