/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.address.Address;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.DesktopSharingCallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.DesktopSharingProtocolSipImpl;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSubscriber;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorListener;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetDesktopStreamingSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.hid.HIDService;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.VideoMediaFormat;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OperationSetDesktopSharingServerSipImpl
extends OperationSetDesktopStreamingSipImpl
implements OperationSetDesktopSharingServer,
MethodProcessorListener {
    private static final Logger logger = Logger.getLogger(OperationSetDesktopSharingServerSipImpl.class);
    private final CallPeerListener callPeerListener = new CallPeerAdapter(){

        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeer peer = evt.getSourceCallPeer();
            CallPeerState state = peer.getState();
            if (OperationSetDesktopSharingServerSipImpl.this.remoteControlEnabled && state != null && (state.equals(CallPeerState.DISCONNECTED) || state.equals(CallPeerState.FAILED))) {
                OperationSetDesktopSharingServerSipImpl.this.remoteControlEnabled = false;
                try {
                    OperationSetDesktopSharingServerSipImpl.this.subscriber.removeSubscription(OperationSetDesktopSharingServerSipImpl.this.parentProvider.parseAddressString(peer.getAddress()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    };
    private boolean remoteControlEnabled = false;
    private final EventPackageSubscriber subscriber;
    private final ProtocolProviderServiceSipImpl parentProvider;
    private final TimerScheduler timer = new TimerScheduler();
    private HIDService hidService = null;

    public OperationSetDesktopSharingServerSipImpl(OperationSetBasicTelephonySipImpl basicTelephony) {
        super(basicTelephony);
        this.parentProvider = basicTelephony.getProtocolProvider();
        this.hidService = SipActivator.getHIDService();
        this.subscriber = new EventPackageSubscriber(this.parentProvider, "remote-control", 3600, "remote-control+xml", this.timer, 60){

            @Override
            protected void populateSubscribeRequest(Request req, EventPackageSubscriber.Subscription subscription, int expires) throws OperationFailedException {
                super.populateSubscribeRequest(req, subscription, expires);
                RemoteControlSubscriberSubscription rControlSubs = (RemoteControlSubscriberSubscription)subscription;
                if (rControlSubs.callPeer.getCall() instanceof DesktopSharingCallSipImpl) {
                    try {
                        Header dssidHeader = OperationSetDesktopSharingServerSipImpl.this.parentProvider.getHeaderFactory().createHeader("DSSID", ((DesktopSharingCallSipImpl)rControlSubs.callPeer.getCall()).getDesktopSharingSessionID());
                        req.setHeader(dssidHeader);
                    }
                    catch (ParseException ex) {
                        logger.error((Object)"error ", (Throwable)ex);
                    }
                }
            }
        };
    }

    @Override
    public Call createVideoCall(String uri, MediaDevice device) throws OperationFailedException, ParseException {
        CallSipImpl call = (CallSipImpl)super.createVideoCall(uri, device);
        CallPeerSipImpl callPeer = (CallPeerSipImpl)((Object)call.getCallPeers().next());
        callPeer.addMethodProcessorListener(this);
        callPeer.addCallPeerListener(this.callPeerListener);
        this.size = ((VideoMediaFormat)call.getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.origin = OperationSetDesktopSharingServerSipImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    public Call createVideoCall(Contact callee, MediaDevice device) throws OperationFailedException {
        CallSipImpl call = (CallSipImpl)super.createVideoCall(callee, device);
        CallPeerSipImpl callPeer = (CallPeerSipImpl)((Object)call.getCallPeers().next());
        callPeer.addMethodProcessorListener(this);
        callPeer.addCallPeerListener(this.callPeerListener);
        this.size = ((VideoMediaFormat)call.getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.origin = OperationSetDesktopSharingServerSipImpl.getOriginForMediaDevice(device);
        return call;
    }

    public void enableRemoteControl(CallPeer callPeer) {
        RemoteControlSubscriberSubscription subscription = new RemoteControlSubscriberSubscription((CallPeerSipImpl)callPeer);
        try {
            this.subscriber.subscribe(subscription);
        }
        catch (OperationFailedException ofe) {
            logger.error((Object)"Failed to create or send a remote-control subscription", (Throwable)ofe);
        }
    }

    public void disableRemoteControl(CallPeer callPeer) {
        try {
            Address addr = this.parentProvider.parseAddressString(callPeer.getAddress());
            this.subscriber.unsubscribe(addr, false);
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to parse address", (Throwable)ex);
        }
        catch (OperationFailedException ofe) {
            logger.error((Object)"Failed to create or send a remote-control unsubscription", (Throwable)ofe);
            return;
        }
        this.remoteControlEnabled = false;
    }

    @Override
    public void requestProcessed(CallPeerSipImpl sourceCallPeer, Request request, Response response) {
    }

    @Override
    public void responseProcessed(CallPeerSipImpl sourceCallPeer, Response response, Request request) {
        CSeqHeader cseqHeader;
        if (200 != response.getStatusCode() || (cseqHeader = (CSeqHeader)response.getHeader("CSeq")) == null || "INVITE".equalsIgnoreCase(cseqHeader.getMethod())) {
            // empty if block
        }
    }

    public void processKeyboardEvent(KeyEvent event) {
        if (this.remoteControlEnabled && this.hidService != null) {
            int keycode = 0;
            if (event.getKeyChar() != '\u0000' && event.getID() == 400) {
                this.hidService.keyPress(event.getKeyChar());
                this.hidService.keyRelease(event.getKeyChar());
                return;
            }
            keycode = event.getKeyCode();
            if (keycode == 0) {
                return;
            }
            switch (event.getID()) {
                case 401: {
                    this.hidService.keyPress(keycode);
                    break;
                }
                case 402: {
                    this.hidService.keyRelease(keycode);
                    break;
                }
            }
        }
    }

    public void processMouseEvent(MouseEvent event) {
        if (this.remoteControlEnabled && this.hidService != null) {
            switch (event.getID()) {
                case 501: {
                    this.hidService.mousePress(event.getModifiers());
                    break;
                }
                case 502: {
                    this.hidService.mouseRelease(event.getModifiers());
                    break;
                }
                case 503: {
                    this.hidService.mouseMove(event.getX(), event.getY());
                    break;
                }
                case 507: {
                    MouseWheelEvent evt = (MouseWheelEvent)event;
                    this.hidService.mouseWheel(evt.getWheelRotation());
                    break;
                }
            }
        }
    }

    public boolean isRemoteControlAvailable(CallPeer callPeer) {
        return true;
    }

    private class RemoteControlSubscriberSubscription
    extends EventPackageSubscriber.Subscription {
        private final CallPeerSipImpl callPeer;

        public RemoteControlSubscriberSubscription(CallPeerSipImpl callPeer) {
            super(callPeer.getPeerAddress());
            this.callPeer = callPeer;
        }

        @Override
        protected Dialog getDialog() {
            Dialog dialog = super.getDialog();
            if (dialog == null || DialogState.TERMINATED.equals((Object)dialog.getState())) {
                dialog = this.callPeer.getDialog();
            }
            return dialog;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void processActiveRequest(RequestEvent requestEvent, byte[] rawContent) {
            void var4_9;
            if (requestEvent.getDialog() != this.callPeer.getDialog()) {
                if (!(this.callPeer.getCall() instanceof DesktopSharingCallSipImpl)) return;
                Header dssidHeader = requestEvent.getRequest().getHeader("DSSID");
                if (dssidHeader == null) return;
                String string = dssidHeader.toString().replaceAll(dssidHeader.getName() + ":", "").trim();
                if (!string.equals(((DesktopSharingCallSipImpl)this.callPeer.getCall()).getDesktopSharingSessionID())) {
                    return;
                }
            }
            if (rawContent == null) return;
            Document document = null;
            Object var4_5 = null;
            try {
                DocumentBuilderFactory factory = XMLUtils.newDocumentBuilderFactory();
                document = factory.newDocumentBuilder().parse(new ByteArrayInputStream(rawContent));
            }
            catch (IOException ioe) {
                IOException iOException = ioe;
            }
            catch (ParserConfigurationException pce) {
                ParserConfigurationException parserConfigurationException = pce;
            }
            catch (SAXException saxe) {
                SAXException sAXException = saxe;
            }
            if (var4_9 != null) {
                logger.error((Object)"Failed to parse remote-info XML", (Throwable)var4_9);
                return;
            } else {
                Element root = document.getDocumentElement();
                List<ComponentEvent> events = null;
                Point p = OperationSetDesktopSharingServerSipImpl.this.getOrigin();
                if (OperationSetDesktopSharingServerSipImpl.this.size == null) {
                    OperationSetDesktopSharingServerSipImpl.this.size = ((VideoMediaFormat)((CallSipImpl)this.callPeer.getCall()).getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
                }
                events = DesktopSharingProtocolSipImpl.parse(root, OperationSetDesktopSharingServerSipImpl.this.size, p);
                for (ComponentEvent evt : events) {
                    if (evt instanceof MouseEvent) {
                        OperationSetDesktopSharingServerSipImpl.this.processMouseEvent((MouseEvent)evt);
                        continue;
                    }
                    if (!(evt instanceof KeyEvent)) continue;
                    OperationSetDesktopSharingServerSipImpl.this.processKeyboardEvent((KeyEvent)evt);
                }
            }
        }

        @Override
        protected void processFailureResponse(ResponseEvent responseEvent, int statusCode) {
            OperationSetDesktopSharingServerSipImpl.this.remoteControlEnabled = false;
        }

        @Override
        protected void processSuccessResponse(ResponseEvent responseEvent, int statusCode) {
            switch (statusCode) {
                case 200: 
                case 202: {
                    OperationSetDesktopSharingServerSipImpl.this.remoteControlEnabled = true;
                }
            }
        }

        @Override
        protected void processTerminatedRequest(RequestEvent requestEvent, String reasonCode) {
            if ("deactivated".equals(reasonCode)) {
                try {
                    OperationSetDesktopSharingServerSipImpl.this.subscriber.poll(this);
                }
                catch (OperationFailedException ofe) {
                    logger.error((Object)("Failed to renew the remote-control subscription " + this), (Throwable)ofe);
                }
            }
        }
    }
}

