/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.core.net.AddressResolver;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportAlreadySupportedException;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.EventHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import net.java.sip.communicator.impl.protocol.sip.AddressResolverImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.SipApplicationData;
import net.java.sip.communicator.impl.protocol.sip.SipStackProperties;
import net.java.sip.communicator.service.netaddr.event.ChangeEvent;
import net.java.sip.communicator.service.netaddr.event.NetworkConfigurationChangeListener;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import org.jitsi.util.OSUtils;

public class SipStackSharing
implements SipListener,
NetworkConfigurationChangeListener {
    public static final String CONTACT_ADDRESS_CUSTOM_PARAM_NAME = "registering_acc";
    private static final Logger logger = Logger.getLogger(SipStackSharing.class);
    private final SipStack stack;
    private SipProvider clearJainSipProvider = null;
    private SipProvider secureJainSipProvider = null;
    private final Set<ProtocolProviderServiceSipImpl> listeners = new HashSet<ProtocolProviderServiceSipImpl>();
    private static final String PREFERRED_CLEAR_PORT_PROPERTY_NAME = "net.java.sip.communicator.SIP_PREFERRED_CLEAR_PORT";
    private static final String PREFERRED_SECURE_PORT_PROPERTY_NAME = "net.java.sip.communicator.SIP_PREFERRED_SECURE_PORT";
    Map<String, TimerTask> resetListeningPointsTimers = new HashMap<String, TimerTask>();

    SipStackSharing() throws OperationFailedException {
        try {
            SipFactory sipFactory = SipFactory.getInstance();
            if (OSUtils.IS_ANDROID) {
                sipFactory.setPathName("org.jitsi.gov.nist");
            } else {
                sipFactory.setPathName("gov.nist");
            }
            SipStackProperties sipStackProperties = new SipStackProperties();
            this.stack = sipFactory.createSipStack((Properties)sipStackProperties);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Created stack: " + this.stack));
            }
            AddressResolverImpl addressResolver = new AddressResolverImpl();
            ((SIPTransactionStack)this.stack).setAddressResolver((AddressResolver)addressResolver);
            SipActivator.getNetworkAddressManagerService().addNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)this);
        }
        catch (Exception ex) {
            logger.fatal((Object)"Failed to get SIP Factory.", (Throwable)ex);
            throw new OperationFailedException("Failed to get SIP Factory", 4, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSipListener(ProtocolProviderServiceSipImpl listener) throws OperationFailedException {
        Set<ProtocolProviderServiceSipImpl> set = this.listeners;
        synchronized (set) {
            if (this.listeners.size() == 0) {
                this.startListening();
            }
            this.listeners.add(listener);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this.listeners.size() + " listeners now"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSipListener(ProtocolProviderServiceSipImpl listener) {
        Set<ProtocolProviderServiceSipImpl> set = this.listeners;
        synchronized (set) {
            this.listeners.remove((Object)listener);
            int listenerCount = this.listeners.size();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(listenerCount + " listeners left"));
            }
            if (listenerCount == 0) {
                this.stopListening();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ProtocolProviderServiceSipImpl> getSipListeners() {
        Set<ProtocolProviderServiceSipImpl> set = this.listeners;
        synchronized (set) {
            return new HashSet<ProtocolProviderServiceSipImpl>(this.listeners);
        }
    }

    public ListeningPoint getLP(String transport) {
        Iterator it = this.stack.getListeningPoints();
        while (it.hasNext()) {
            ListeningPoint lp = (ListeningPoint)it.next();
            if (!lp.getTransport().toLowerCase().equals(transport.toLowerCase())) continue;
            return lp;
        }
        throw new IllegalArgumentException("Invalid transport: " + transport);
    }

    private void startListening() throws OperationFailedException {
        try {
            int bindRetriesValue = this.getBindRetriesValue();
            this.createProvider(this.getPreferredClearPort(), bindRetriesValue, false);
            this.createProvider(this.getPreferredSecurePort(), bindRetriesValue, true);
            this.stack.start();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"started listening");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"An unexpected error happened while creating theSipProviders and ListeningPoints.");
            throw new OperationFailedException("An unexpected error hapennedwhile initializing the SIP stack", 4, (Throwable)ex);
        }
    }

    private void createProvider(int preferredPort, int retries, boolean secure) throws TransportNotSupportedException, InvalidArgumentException, ObjectInUseException, TransportAlreadySupportedException, TooManyListenersException {
        String context;
        String string = context = secure ? "TLS: " : "clear UDP/TCP: ";
        if (retries < 0) {
            logger.error((Object)(context + "couldn't find free ports to listen on."));
            return;
        }
        ListeningPoint tlsLP = null;
        ListeningPoint udpLP = null;
        ListeningPoint tcpLP = null;
        try {
            if (secure) {
                tlsLP = this.stack.createListeningPoint(NetworkUtils.IN_ADDR_ANY, preferredPort, "TLS");
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"TLS secure ListeningPoint has been created.");
                }
                this.secureJainSipProvider = this.stack.createSipProvider(tlsLP);
                this.secureJainSipProvider.addSipListener((SipListener)this);
            } else {
                udpLP = this.stack.createListeningPoint(NetworkUtils.IN_ADDR_ANY, preferredPort, "UDP");
                tcpLP = this.stack.createListeningPoint(NetworkUtils.IN_ADDR_ANY, preferredPort, "TCP");
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"UDP and TCP clear ListeningPoints have been created.");
                }
                this.clearJainSipProvider = this.stack.createSipProvider(udpLP);
                this.clearJainSipProvider.addListeningPoint(tcpLP);
                this.clearJainSipProvider.addSipListener((SipListener)this);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(context + "SipProvider has been created."));
            }
        }
        catch (InvalidArgumentException ex) {
            if (secure) {
                if (tlsLP != null) {
                    this.stack.deleteListeningPoint(tlsLP);
                }
                HashSet<ListeningPoint> lpsToDelete = new HashSet<ListeningPoint>();
                Iterator lps = this.stack.getListeningPoints();
                while (lps.hasNext()) {
                    ListeningPoint lp = (ListeningPoint)lps.next();
                    if (!"TLS".equalsIgnoreCase(lp.getTransport()) || lp.getPort() != preferredPort) continue;
                    lpsToDelete.add(lp);
                }
                for (ListeningPoint lp : lpsToDelete) {
                    this.stack.deleteListeningPoint(lp);
                }
            }
            if (udpLP != null) {
                this.stack.deleteListeningPoint(udpLP);
            }
            if (tcpLP != null) {
                this.stack.deleteListeningPoint(tcpLP);
            }
            if (ex.getCause() instanceof IOException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Port " + preferredPort + " seems in use for either TCP or UDP."));
                }
                int currentlyTriedPort = NetworkUtils.getRandomPortNumber();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Retrying bind on port " + currentlyTriedPort));
                }
                this.createProvider(currentlyTriedPort, retries - 1, secure);
            }
            throw ex;
        }
    }

    private void stopListening() {
        try {
            if (this.secureJainSipProvider != null) {
                this.secureJainSipProvider.removeSipListener((SipListener)this);
                this.stack.deleteSipProvider(this.secureJainSipProvider);
                this.secureJainSipProvider = null;
            }
            if (this.clearJainSipProvider != null) {
                this.clearJainSipProvider.removeSipListener((SipListener)this);
                this.stack.deleteSipProvider(this.clearJainSipProvider);
                this.clearJainSipProvider = null;
            }
            Iterator it = this.stack.getListeningPoints();
            Vector lpointsToRemove = new Vector();
            while (it.hasNext()) {
                lpointsToRemove.add(it.next());
            }
            it = lpointsToRemove.iterator();
            while (it.hasNext()) {
                this.stack.deleteListeningPoint((ListeningPoint)it.next());
            }
            this.stack.stop();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"stopped listening");
            }
        }
        catch (ObjectInUseException ex) {
            logger.fatal((Object)"Failed to stop listening", (Throwable)ex);
        }
    }

    public SipProvider getJainSipProvider(String transport) {
        SipProvider sp = null;
        if (transport.equalsIgnoreCase("UDP") || transport.equalsIgnoreCase("TCP")) {
            sp = this.clearJainSipProvider;
        } else if (transport.equalsIgnoreCase("TLS")) {
            sp = this.secureJainSipProvider;
        }
        if (sp == null) {
            throw new IllegalArgumentException("invalid transport");
        }
        return sp;
    }

    private int getPreferredClearPort() {
        int preferredPort = SipActivator.getConfigurationService().getInt(PREFERRED_CLEAR_PORT_PROPERTY_NAME, -1);
        if (preferredPort <= 1) {
            preferredPort = SipActivator.getResources().getSettingsInt(PREFERRED_CLEAR_PORT_PROPERTY_NAME);
        }
        if (preferredPort <= 1) {
            return 5060;
        }
        return preferredPort;
    }

    private int getPreferredSecurePort() {
        int preferredPort = SipActivator.getConfigurationService().getInt(PREFERRED_SECURE_PORT_PROPERTY_NAME, -1);
        if (preferredPort <= 1) {
            preferredPort = SipActivator.getResources().getSettingsInt(PREFERRED_SECURE_PORT_PROPERTY_NAME);
        }
        if (preferredPort <= 1) {
            return 5061;
        }
        return preferredPort;
    }

    private int getBindRetriesValue() {
        return SipActivator.getConfigurationService().getInt("net.java.sip.communicator.service.protocol.BIND_RETRIES", 50);
    }

    public void processDialogTerminated(DialogTerminatedEvent event) {
        try {
            ProtocolProviderServiceSipImpl recipient = (ProtocolProviderServiceSipImpl)((Object)SipApplicationData.getApplicationData(event.getDialog(), "service"));
            if (recipient == null) {
                logger.error((Object)"Dialog wasn't marked, please report this to dev@jitsi.org");
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"service was found with dialog data");
                }
                recipient.processDialogTerminated(event);
            }
        }
        catch (Throwable exc) {
            this.logApplicationException(DialogTerminatedEvent.class, exc);
        }
    }

    public void processIOException(IOExceptionEvent event) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)event);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"@todo implement processIOException()");
            }
        }
        catch (Throwable exc) {
            this.logApplicationException(DialogTerminatedEvent.class, exc);
        }
    }

    public void processRequest(RequestEvent event) {
        block13: {
            try {
                ProtocolProviderServiceSipImpl service;
                Request request = event.getRequest();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("received request: " + request.getMethod()));
                }
                if (event.getServerTransaction() == null) {
                    try {
                        if (this.applyNonConformanceHacks(event)) {
                            return;
                        }
                        SipProvider source = (SipProvider)event.getSource();
                        ServerTransaction transaction = source.getNewServerTransaction(request);
                        event = new RequestEvent((Object)source, transaction, transaction.getDialog(), request);
                    }
                    catch (SipException ex) {
                        logger.error((Object)"couldn't create transaction, please report this to dev@jitsi.org", (Throwable)ex);
                    }
                }
                if ((service = this.getServiceData((Transaction)event.getServerTransaction())) != null) {
                    service.processRequest(event);
                } else {
                    service = this.findTargetFor(request);
                    if (service == null) {
                        logger.error((Object)"couldn't find a ProtocolProviderServiceSipImpl to dispatch to");
                        if (event.getServerTransaction() != null) {
                            event.getServerTransaction().terminate();
                        }
                    } else {
                        Dialog container = event.getDialog();
                        if (container == null) {
                            container = request;
                        }
                        SipApplicationData.setApplicationData(container, "service", (Object)service);
                        service.processRequest(event);
                    }
                }
            }
            catch (Throwable exc) {
                this.logApplicationException(DialogTerminatedEvent.class, exc);
                if (!(exc instanceof ThreadDeath)) break block13;
                throw (ThreadDeath)exc;
            }
        }
    }

    public void processResponse(ResponseEvent event) {
        try {
            ClientTransaction transaction = event.getClientTransaction();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("received response: " + event.getResponse().getStatusCode() + " " + event.getResponse().getReasonPhrase()));
            }
            if (transaction == null) {
                logger.warn((Object)("Transaction is null, probably already expired! Status=" + event.getResponse().getStatusCode()));
                return;
            }
            ProtocolProviderServiceSipImpl service = this.getServiceData((Transaction)transaction);
            if (service != null) {
                if (event.getDialog() != null) {
                    SipApplicationData.setApplicationData(event.getDialog(), "service", (Object)service);
                }
                service.processResponse(event);
            } else {
                logger.error((Object)"We received a response which wasn't marked, please report this to dev@jitsi.org");
            }
        }
        catch (Throwable exc) {
            this.logApplicationException(DialogTerminatedEvent.class, exc);
        }
    }

    public void processTimeout(TimeoutEvent event) {
        try {
            Object transaction = event.isServerTransaction() ? event.getServerTransaction() : event.getClientTransaction();
            ProtocolProviderServiceSipImpl recipient = this.getServiceData((Transaction)transaction);
            if (recipient == null) {
                logger.error((Object)"We received a timeout which wasn't marked, please report this to dev@jitsi.org");
            } else {
                recipient.processTimeout(event);
            }
        }
        catch (Throwable exc) {
            this.logApplicationException(DialogTerminatedEvent.class, exc);
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent event) {
        try {
            Object transaction = event.isServerTransaction() ? event.getServerTransaction() : event.getClientTransaction();
            ProtocolProviderServiceSipImpl recipient = this.getServiceData((Transaction)transaction);
            if (recipient == null) {
                logger.error((Object)"We received a transaction terminated which wasn't marked, please report this to dev@jitsi.org");
            } else {
                recipient.processTransactionTerminated(event);
            }
        }
        catch (Throwable exc) {
            this.logApplicationException(DialogTerminatedEvent.class, exc);
        }
    }

    private ProtocolProviderServiceSipImpl findTargetFor(Request request) {
        if (request == null) {
            logger.error((Object)"request shouldn't be null.");
            return null;
        }
        ArrayList<ProtocolProviderServiceSipImpl> currentListenersCopy = new ArrayList<ProtocolProviderServiceSipImpl>(this.getSipListeners());
        this.filterByAddress(currentListenersCopy, request);
        if (currentListenersCopy.size() == 0) {
            logger.error((Object)"no listeners");
            return null;
        }
        URI requestURI = request.getRequestURI();
        if (requestURI.isSipURI()) {
            ProtocolProviderServiceSipImpl target;
            String requestUser = ((SipURI)requestURI).getUser();
            ArrayList<ProtocolProviderServiceSipImpl> candidates = new ArrayList<ProtocolProviderServiceSipImpl>();
            for (ProtocolProviderServiceSipImpl listener : currentListenersCopy) {
                String ourUserID = listener.getAccountID().getUserID();
                if (!ourUserID.equals(requestUser)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("suitable candidate found: " + listener.getAccountID()));
                }
                candidates.add(listener);
            }
            if (candidates.size() == 1) {
                ProtocolProviderServiceSipImpl perfectMatch = (ProtocolProviderServiceSipImpl)((Object)candidates.get(0));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Will dispatch to \"" + perfectMatch.getAccountID() + "\""));
                }
                return perfectMatch;
            }
            if (candidates.size() > 1) {
                for (ProtocolProviderServiceSipImpl candidate : candidates) {
                    String hostValue = ((SipURI)requestURI).getParameter(CONTACT_ADDRESS_CUSTOM_PARAM_NAME);
                    if (hostValue == null || !hostValue.equals(candidate.getContactAddressCustomParamValue())) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Will dispatch to \"" + candidate.getAccountID() + "\" because \" the custom param was set"));
                    }
                    return candidate;
                }
                for (ProtocolProviderServiceSipImpl candidate : candidates) {
                    String toHost;
                    URI fromURI = ((FromHeader)request.getHeader("From")).getAddress().getURI();
                    if (!fromURI.isSipURI()) continue;
                    SipURI ourURI = (SipURI)candidate.getOurSipAddress((SipURI)fromURI).getURI();
                    String ourHost = ourURI.getHost();
                    URI toURI = ((ToHeader)request.getHeader("To")).getAddress().getURI();
                    if (!toURI.isSipURI() || !(toHost = ((SipURI)toURI).getHost()).equals(ourHost)) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Will dispatch to \"" + candidate.getAccountID() + "\" because host in the To: is the same as in our AOR"));
                    }
                    return candidate;
                }
                target = (ProtocolProviderServiceSipImpl)((Object)candidates.iterator().next());
                logger.info((Object)("Will randomly dispatch to \"" + target.getAccountID() + "\" because there is ambiguity on the username from the Request-URI"));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("\n" + request));
                }
                return target;
            }
            target = (ProtocolProviderServiceSipImpl)((Object)currentListenersCopy.iterator().next());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Will randomly dispatch to \"" + target.getAccountID() + "\" because the username in the Request-URI is unknown or empty"));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("\n" + request));
            }
            return target;
        }
        logger.error((Object)"Request-URI is not a SIP URI, dropping");
        return null;
    }

    private void filterByAddress(List<ProtocolProviderServiceSipImpl> candidates, Request request) {
        Iterator<ProtocolProviderServiceSipImpl> iterPP = candidates.iterator();
        while (iterPP.hasNext()) {
            ProtocolProviderServiceSipImpl candidate = iterPP.next();
            boolean forceProxyBypass = candidate.getAccountID().getAccountPropertyBoolean((Object)"FORCE_PROXY_BYPASS", false);
            if (forceProxyBypass || candidate.getRegistrarConnection() == null || candidate.getRegistrarConnection().isRegistrarless() || candidate.getRegistrarConnection().isRequestFromSameConnection(request)) continue;
            iterPP.remove();
        }
    }

    private ProtocolProviderServiceSipImpl getServiceData(Transaction transaction) {
        ProtocolProviderServiceSipImpl service = (ProtocolProviderServiceSipImpl)((Object)SipApplicationData.getApplicationData(transaction.getRequest(), "service"));
        if (service != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"service was found in request data");
            }
            return service;
        }
        service = (ProtocolProviderServiceSipImpl)((Object)SipApplicationData.getApplicationData(transaction.getDialog(), "service"));
        if (service != null && logger.isTraceEnabled()) {
            logger.trace((Object)"service was found in dialog data");
        }
        return service;
    }

    private void logApplicationException(Class<DialogTerminatedEvent> eventClass, Throwable exc) {
        String message = "An error occurred while processing event of type: " + eventClass.getName();
        logger.error((Object)message, exc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)message, exc);
        }
    }

    public static ServerTransaction getOrCreateServerTransaction(RequestEvent event) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        ServerTransaction serverTransaction = event.getServerTransaction();
        if (serverTransaction == null) {
            SipProvider jainSipProvider = (SipProvider)event.getSource();
            serverTransaction = jainSipProvider.getNewServerTransaction(event.getRequest());
        }
        return serverTransaction;
    }

    public InetSocketAddress getLocalAddressForDestination(InetAddress dst, int dstPort, InetAddress localAddress, String transport) throws IOException {
        logger.info((Object)("Gettting source address for " + localAddress + " -> " + dst + ":" + dstPort + "(" + transport + ")"));
        if ("TLS".equalsIgnoreCase(transport)) {
            return (InetSocketAddress)((SipStackImpl)this.stack).getLocalAddressForTlsDst(dst, dstPort, localAddress);
        }
        return (InetSocketAddress)((SipStackImpl)this.stack).getLocalAddressForTcpDst(dst, dstPort, localAddress, 0);
    }

    private boolean applyNonConformanceHacks(RequestEvent event) {
        Request request = event.getRequest();
        try {
            if (request.getHeader("Max-Forwards") == null) {
                MaxForwardsHeader maxForwards = SipFactory.getInstance().createHeaderFactory().createMaxForwardsHeader(70);
                request.setHeader((Header)maxForwards);
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)"Cannot apply incoming request modification!", ex);
        }
        try {
            if (request.getMethod().equals("NOTIFY") && request.getHeader("Event") != null && ((EventHeader)request.getHeader("Event")).getEventType().equals("message-summary") && request.getHeader("Subscription-State") == null) {
                request.addHeader((Header)new HeaderFactoryImpl().createSubscriptionStateHeader("active"));
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)"Cannot apply incoming request modification!", ex);
        }
        try {
            if (request.getMethod().equals("NOTIFY") && request.getHeader("Subscription-State") == null) {
                return true;
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)"Cannot apply incoming request modification!", ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged(ChangeEvent event) {
        if (event.isInitial()) {
            return;
        }
        if (event.getType() == 2) {
            for (ProtocolProviderServiceSipImpl pp : this.listeners) {
                ResetListeningPoint reseter;
                if (pp.getRegistrarConnection().getTransport() == null || !pp.getRegistrarConnection().getTransport().equals("TCP") && !pp.getRegistrarConnection().getTransport().equals("TLS")) continue;
                Map<String, TimerTask> map = this.resetListeningPointsTimers;
                synchronized (map) {
                    if (this.resetListeningPointsTimers.containsKey(pp.getRegistrarConnection().getTransport())) {
                        continue;
                    }
                    reseter = new ResetListeningPoint(pp);
                    this.resetListeningPointsTimers.put(pp.getRegistrarConnection().getTransport(), reseter);
                }
                pp.addRegistrationStateChangeListener(reseter);
            }
        }
    }

    private class ResetListeningPoint
    extends TimerTask
    implements RegistrationStateChangeListener {
        private static final int TIME_FOR_PP_TO_UNREGISTER = 20000;
        private final ProtocolProviderServiceSipImpl protocolProvider;

        ResetListeningPoint(ProtocolProviderServiceSipImpl pp) {
            this.protocolProvider = pp;
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.UNREGISTERING) {
                new Timer().schedule((TimerTask)this, 20000L);
            } else {
                this.protocolProvider.removeRegistrationStateChangeListener(this);
                SipStackSharing.this.resetListeningPointsTimers.remove(this.protocolProvider.getRegistrarConnection().getTransport());
            }
        }

        @Override
        public void run() {
            if (this.protocolProvider.getRegistrationState() == RegistrationState.UNREGISTERING) {
                String transport = this.protocolProvider.getRegistrarConnection().getTransport();
                ListeningPoint old = SipStackSharing.this.getLP(transport);
                try {
                    SipStackSharing.this.stack.deleteListeningPoint(old);
                }
                catch (Throwable t) {
                    logger.warn((Object)("Error replacing ListeningPoint for " + transport), t);
                }
                try {
                    ListeningPoint tcpLP = SipStackSharing.this.stack.createListeningPoint(NetworkUtils.IN_ADDR_ANY, transport.equals("TCP") ? SipStackSharing.this.getPreferredClearPort() : SipStackSharing.this.getPreferredSecurePort(), transport);
                    SipStackSharing.this.clearJainSipProvider.addListeningPoint(tcpLP);
                }
                catch (Throwable t) {
                    logger.warn((Object)("Error replacing ListeningPoint for " + this.protocolProvider.getRegistrarConnection().getTransport()), t);
                }
            }
            SipStackSharing.this.resetListeningPointsTimers.remove(this.protocolProvider.getRegistrarConnection().getTransport());
        }
    }
}

