/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.jdic;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.impl.osdependent.jdic.StatusSubMenu;
import net.java.sip.communicator.plugin.desktoputil.presence.StatusMessageMenu;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class StatusSelector
implements ActionListener,
ItemListener {
    private final ProtocolProviderService provider;
    private final OperationSetPresence presence;
    private final Logger logger = Logger.getLogger(StatusSelector.class);
    private final Object menu;

    public StatusSelector(ProtocolProviderService provider, OperationSetPresence presence, boolean swing) {
        this.provider = provider;
        this.presence = presence;
        String text = provider.getAccountID().getDisplayName();
        if (swing) {
            JMenu menu = new JMenu(text);
            byte[] icBytes = presence.getPresenceStatus().getStatusIcon();
            if (icBytes != null) {
                menu.setIcon(new ImageIcon(icBytes));
            }
            this.menu = menu;
        } else {
            this.menu = new Menu(text);
        }
        PresenceStatus offlineStatus = null;
        Iterator statusIterator = this.presence.getSupportedStatusSet();
        while (statusIterator.hasNext()) {
            ItemSelectable item;
            PresenceStatus status = (PresenceStatus)statusIterator.next();
            if (status.getStatus() < 1) {
                offlineStatus = status;
            }
            String text2 = status.getStatusName();
            if (this.menu instanceof Container) {
                item = new JCheckBoxMenuItem(text2);
                byte[] icBytes = status.getStatusIcon();
                if (icBytes != null) {
                    ((AbstractButton)item).setIcon(new ImageIcon(icBytes));
                }
                ((AbstractButton)item).addActionListener(this);
                ((Container)this.menu).add((Component)((Object)item));
                continue;
            }
            item = new CheckboxMenuItem(text2);
            ((CheckboxMenuItem)item).addItemListener(this);
            ((Menu)this.menu).add((MenuItem)((Object)item));
        }
        this.addSeparator();
        StatusSubMenu.addMenuItem(this.menu, new StatusMessageMenu(provider, swing).getMenu());
        if (offlineStatus != null) {
            this.updateStatus(offlineStatus);
        }
    }

    private void addSeparator() {
        if (this.menu instanceof JMenu) {
            ((JMenu)this.menu).addSeparator();
        } else {
            ((Menu)this.menu).addSeparator();
        }
    }

    public Object getMenu() {
        return this.menu;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String menuItemText = source instanceof AbstractButton ? ((AbstractButton)source).getText() : ((MenuItem)source).getLabel();
        this.changeStatus(menuItemText);
    }

    private void changeStatus(String statusName) {
        Iterator statusSet = this.presence.getSupportedStatusSet();
        while (statusSet.hasNext()) {
            PresenceStatus status = (PresenceStatus)statusSet.next();
            if (!status.getStatusName().equals(statusName)) continue;
            OsDependentActivator.getGlobalStatusService().publishStatus(this.provider, status);
            break;
        }
    }

    public void updateStatus(PresenceStatus presenceStatus) {
        block5: {
            Accessible theMenu;
            String presenceStatusName;
            block4: {
                byte[] bytes;
                presenceStatusName = presenceStatus.getStatusName();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Systray update status for provider: " + this.provider.getAccountID().getAccountAddress() + ". The new status will be: " + presenceStatusName));
                }
                if (this.menu instanceof AbstractButton && (bytes = presenceStatus.getStatusIcon()) != null) {
                    ((AbstractButton)this.menu).setIcon(new ImageIcon());
                }
                if (!(this.menu instanceof Menu)) break block4;
                theMenu = (Menu)this.menu;
                int count = ((Menu)theMenu).getItemCount();
                for (int i = 0; i < count; ++i) {
                    MenuItem item = ((Menu)theMenu).getItem(i);
                    if (!(item instanceof CheckboxMenuItem)) continue;
                    ((CheckboxMenuItem)item).setState(item.getLabel().equals(presenceStatusName));
                }
                break block5;
            }
            if (!(this.menu instanceof JMenu)) break block5;
            theMenu = (JMenu)this.menu;
            int count = ((JMenu)theMenu).getItemCount();
            for (int i = 0; i < count; ++i) {
                JMenuItem item = ((JMenu)theMenu).getItem(i);
                if (!(item instanceof JCheckBoxMenuItem)) continue;
                item.setSelected(item.getText().equals(presenceStatusName));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object sourceItem = e.getSource();
        if (e.getStateChange() == 1) {
            if (sourceItem instanceof CheckboxMenuItem) {
                this.changeStatus(((CheckboxMenuItem)sourceItem).getLabel());
            }
        } else if (e.getStateChange() == 2 && sourceItem instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)sourceItem).setState(true);
        }
    }
}

