/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.DSourceListMail;
import com.explodingpixels.macwidgets.MacIcons;
import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.SourceList;
import com.explodingpixels.macwidgets.SourceListControlBar;
import com.explodingpixels.widgets.PopupMenuCustomizer;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DSourceListControlBar {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceList sourceList = DSourceListMail.createSourceList();
                SourceListControlBar controlBar = new SourceListControlBar();
                sourceList.installSourceListControlBar(controlBar);
                controlBar.createAndAddButton(MacIcons.PLUS, null);
                controlBar.createAndAddButton(MacIcons.MINUS, null);
                controlBar.createAndAddPopdownButton(MacIcons.GEAR, new PopupMenuCustomizer(){

                    public void customizePopup(JPopupMenu popup) {
                        popup.removeAll();
                        popup.add(new JMenuItem("Item One"));
                        popup.add(new JMenuItem("Item Two"));
                        popup.add(new JMenuItem("Item Three"));
                    }
                });
                JSplitPane splitPane = MacWidgetFactory.createSplitPaneForSourceList(sourceList, new JTextArea());
                splitPane.setDividerLocation(200);
                controlBar.installDraggableWidgetOnSplitPane(splitPane);
                JFrame frame = new JFrame();
                WindowUtils.createAndInstallRepaintWindowFocusListener(frame);
                frame.add((Component)sourceList.getComponent(), "Center");
                frame.setSize(225, 275);
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
    }
}

