/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.util.skin.Skinnable;

public class FullScreenButton
extends SIPCommButton
implements PropertyChangeListener,
Skinnable {
    private final CallPanel callContainer;

    public FullScreenButton(CallPanel callContainer) {
        this.callContainer = callContainer;
        this.loadSkin();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallPanel callPanel;
                callPanel.setFullScreen(!(callPanel = FullScreenButton.this.callContainer).isFullScreen());
            }
        });
        this.callContainer.addPropertyChangeListener("fullScreen", this);
    }

    public void loadSkin() {
        boolean fullScreen = this.callContainer.isFullScreen();
        this.setIconImage(ImageLoader.getImage(fullScreen ? ImageLoader.EXIT_FULL_SCREEN_BUTTON : ImageLoader.ENTER_FULL_SCREEN_BUTTON));
        this.setPreferredSize(new Dimension(44, 38));
        this.setToolTipText(GuiActivator.getResources().getI18NString(fullScreen ? "service.gui.EXIT_FULL_SCREEN_TOOL_TIP" : "service.gui.ENTER_FULL_SCREEN_TOOL_TIP"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("fullScreen".equals(ev.getPropertyName()) && this.callContainer.equals(ev.getSource())) {
            this.loadSkin();
        }
    }
}

