/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JToolTip;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.util.ConfigurationUtils;

public class ContactPhotoPanel
extends JLayeredPane {
    private final JLabel photoLabel = new JLabel();
    private final JLabel addContactButton = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_CHAT_ICON)));
    private ImageIcon tooltipIcon;
    private ChatSession chatSession;

    public ContactPhotoPanel() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(35, 25));
        this.add((Component)this.photoLabel, 1);
        this.photoLabel.setBounds(5, 0, 25, 25);
        this.addContactButton.setBounds(19, 9, 16, 16);
        this.addContactButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ContactPhotoPanel.this.chatSession != null) {
                    AddContactDialog dialog = new AddContactDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()));
                    dialog.setSelectedAccount(ContactPhotoPanel.this.chatSession.getCurrentChatTransport().getProtocolProvider());
                    dialog.setContactAddress(ContactPhotoPanel.this.chatSession.getPersistableAddress());
                    dialog.setVisible(true);
                }
            }
        });
    }

    public void setChatSession(ChatSession chatSession) {
        this.chatSession = chatSession;
        byte[] chatAvatar = chatSession.getChatAvatar();
        if (chatAvatar != null && chatAvatar.length > 0) {
            this.tooltipIcon = new ImageIcon(chatAvatar);
            ImageIcon contactPhotoIcon = ImageUtils.getScaledRoundedIcon((byte[])chatAvatar, (int)25, (int)25);
            if (contactPhotoIcon != null) {
                this.photoLabel.setIcon(contactPhotoIcon);
            }
        } else {
            this.photoLabel.setIcon(null);
            this.tooltipIcon = null;
        }
        this.setToolTipText("");
        if (!(chatSession.isDescriptorPersistent() || chatSession instanceof ConferenceChatSession || ConfigurationUtils.isAddContactDisabled() || chatSession.getPersistableAddress() == null)) {
            this.add((Component)this.addContactButton, 0);
        } else {
            this.remove(this.addContactButton);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public JToolTip createToolTip() {
        ExtendedTooltip tip = new ExtendedTooltip(true);
        if (this.tooltipIcon != null) {
            tip.setImage(this.tooltipIcon);
        }
        tip.setTitle(this.chatSession.getChatName());
        Iterator<ChatTransport> transports = this.chatSession.getChatTransports();
        while (transports.hasNext()) {
            ChatTransport transport = transports.next();
            ImageIcon protocolStatusIcon = transport.getStatus() != null ? new ImageIcon(transport.getStatus().getStatusIcon()) : new ImageIcon();
            String transportAddress = transport.getName();
            tip.addLine((Icon)protocolStatusIcon, transportAddress);
        }
        tip.setComponent((JComponent)this);
        return tip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.chatSession.getChatName();
    }
}

