/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.menus;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindow;
import net.java.sip.communicator.impl.gui.main.chat.menus.ChatFileMenu;
import net.java.sip.communicator.impl.gui.main.chat.menus.ChatToolsMenu;
import net.java.sip.communicator.impl.gui.main.chat.menus.EditMenu;
import net.java.sip.communicator.impl.gui.main.chat.menus.HelpMenu;
import net.java.sip.communicator.impl.gui.main.menus.SIPCommWindowMenuBar;
import net.java.sip.communicator.impl.gui.utils.PluginContainer;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;

public class MessageWindowMenuBar
extends SIPCommWindowMenuBar {
    private final ChatFileMenu fileMenu;
    private final EditMenu editMenu;
    private final ChatToolsMenu optionsMenu;
    private final HelpMenu helpMenu;
    private final PluginContainer pluginContainer;

    public MessageWindowMenuBar(ChatWindow parentWindow) {
        super("service.gui.CHAT_MENU_FOREGROUND");
        this.fileMenu = new ChatFileMenu(parentWindow);
        this.editMenu = new EditMenu(parentWindow);
        this.optionsMenu = new ChatToolsMenu(parentWindow);
        this.helpMenu = new HelpMenu(parentWindow);
        this.init();
        this.pluginContainer = new PluginContainer(this, Container.CONTAINER_CHAT_MENU_BAR){

            @Override
            protected void addComponentToContainer(Component component, JComponent container, int preferredIndex) {
                if (component instanceof SIPCommMenu) {
                    ((SIPCommMenu)component).setOpaque(false);
                }
                container.add(component, MessageWindowMenuBar.this.getComponentIndex((Component)((Object)MessageWindowMenuBar.this.helpMenu)));
            }
        };
        parentWindow.addChatChangeListener(new ChatChangeListener(){

            @Override
            public void chatChanged(ChatPanel panel) {
                MetaContact contact = GuiActivator.getUIService().getChatContact(panel);
                for (PluginComponent c : MessageWindowMenuBar.this.pluginContainer.getPluginComponents()) {
                    c.setCurrentContact(contact);
                }
            }
        });
    }

    public void dispose() {
        this.pluginContainer.dispose();
        this.helpMenu.dispose();
        this.optionsMenu.dispose();
    }

    private void init() {
        this.add((JMenu)((Object)this.fileMenu));
        this.add((JMenu)((Object)this.editMenu));
        this.add((JMenu)((Object)this.optionsMenu));
        this.add((JMenu)((Object)this.helpMenu));
    }

    public JMenu getSelectedMenu() {
        int menuCount = this.getMenuCount();
        for (int i = 0; i < menuCount; ++i) {
            JMenu menu = this.getMenu(i);
            if (!menu.isSelected()) continue;
            return menu;
        }
        return null;
    }
}

