/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.toolBars;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.ChatToolbarButton;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.chat.ChatChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.MetaContactChatSession;
import net.java.sip.communicator.impl.gui.main.chat.SmileysSelectorBox;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatInviteDialog;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.toolBars.HistorySelectorBox;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.impl.gui.utils.PluginContainer;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenuBar;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.UIContactDetailImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.call.MetaContactPhoneUtil;
import net.java.sip.communicator.util.skin.Skinnable;

public class MainToolBar
extends TransparentPanel
implements ActionListener,
ChatChangeListener,
ChatSessionChangeListener,
ChatRoomLocalUserRoleListener,
Skinnable {
    private static final long serialVersionUID = -5572510509556499465L;
    private final ChatToolbarButton inviteButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.ADD_TO_CHAT_ICON));
    private final HistorySelectorBox historyButton;
    private final ChatToolbarButton sendFileButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.SEND_FILE_ICON));
    private final ChatToolbarButton previousButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.PREVIOUS_ICON));
    private final ChatToolbarButton nextButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.NEXT_ICON));
    private final ChatToolbarButton leaveChatRoomButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.LEAVE_ICON));
    private final ChatToolbarButton callButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.CHAT_CALL));
    private final ChatToolbarButton callVideoButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.CHAT_VIDEO_CALL));
    private final ChatToolbarButton optionsButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.CHAT_CONFIGURE_ICON));
    private final ChatToolbarButton desktopSharingButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.CHAT_DESKTOP_SHARING));
    private final ChatToolbarButton fontButton = new ChatToolbarButton(ImageLoader.getImage(ImageLoader.FONT_ICON));
    private SmileysSelectorBox smileysBox;
    private ChatSession chatSession;
    protected final ChatContainer chatContainer;
    private final PluginContainer pluginContainer;
    private MetaContactPhoneUtil contactPhoneUtil = null;

    public MainToolBar(ChatContainer chatContainer) {
        this.chatContainer = chatContainer;
        this.historyButton = new HistorySelectorBox(chatContainer);
        this.init();
        this.pluginContainer = new PluginContainer((JComponent)((Object)this), Container.CONTAINER_CHAT_TOOL_BAR);
        this.chatContainer.addChatChangeListener(this);
    }

    protected void init() {
        this.setLayout(new FlowLayout(0, 3, 0));
        this.setOpaque(false);
        this.add((Component)((Object)this.inviteButton));
        if (!ConfigurationUtils.isLeaveChatRoomOnWindowCloseEnabled()) {
            this.add((Component)((Object)this.leaveChatRoomButton));
        }
        this.add((Component)((Object)this.callButton));
        this.add((Component)((Object)this.callVideoButton));
        this.add((Component)((Object)this.desktopSharingButton));
        this.add((Component)((Object)this.sendFileButton));
        ChatPanel chatPanel = this.chatContainer.getCurrentChat();
        if (chatPanel == null || !(chatPanel.getChatSession() instanceof MetaContactChatSession)) {
            this.sendFileButton.setEnabled(false);
        }
        if (chatPanel != null && chatPanel.isPrivateMessagingChat()) {
            this.inviteButton.setEnabled(false);
        }
        if (chatPanel == null || !(chatPanel.getChatSession() instanceof ConferenceChatSession)) {
            this.desktopSharingButton.setEnabled(false);
        }
        this.addSeparator();
        SIPCommMenuBar historyMenuBar = new SIPCommMenuBar();
        historyMenuBar.setOpaque(false);
        historyMenuBar.setLayout((LayoutManager)new FlowLayout(1, 0, 0));
        historyMenuBar.add((JMenu)((Object)this.historyButton));
        this.add((Component)historyMenuBar);
        this.add((Component)((Object)this.previousButton));
        this.add((Component)((Object)this.nextButton));
        Boolean showOptionsProp = GuiActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.main.configforms.SHOW_OPTIONS_WINDOW", false);
        if (showOptionsProp.booleanValue()) {
            this.add((Component)((Object)this.optionsButton));
        }
        this.addSeparator();
        if (ConfigurationUtils.isFontSupportEnabled()) {
            this.add((Component)((Object)this.fontButton));
            this.fontButton.setName("font");
            this.fontButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CHANGE_FONT"));
            this.fontButton.addActionListener(this);
        }
        this.initSmiliesSelectorBox();
        this.addSeparator();
        this.inviteButton.setName("invite");
        this.inviteButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.INVITE"));
        this.leaveChatRoomButton.setName("leave");
        this.leaveChatRoomButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.LEAVE"));
        this.setCallButtonsName();
        this.setCallButtonsIcons();
        this.desktopSharingButton.setName("desktop");
        this.desktopSharingButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.SHARE_DESKTOP_WITH_CONTACT"));
        this.optionsButton.setName("options");
        this.optionsButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.OPTIONS"));
        this.sendFileButton.setName("sendFile");
        this.sendFileButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.SEND_FILE"));
        this.previousButton.setName("previous");
        this.previousButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.PREVIOUS"));
        this.nextButton.setName("next");
        this.nextButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.NEXT"));
        this.inviteButton.addActionListener(this);
        this.leaveChatRoomButton.addActionListener(this);
        this.callButton.addActionListener(this);
        this.callVideoButton.addActionListener(this);
        this.desktopSharingButton.addActionListener(this);
        this.optionsButton.addActionListener(this);
        this.sendFileButton.addActionListener(this);
        this.previousButton.addActionListener(this);
        this.nextButton.addActionListener(this);
    }

    private void initSmiliesSelectorBox() {
        this.smileysBox = new SmileysSelectorBox();
        this.smileysBox.setName("smiley");
        this.smileysBox.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.INSERT_SMILEY") + " Ctrl-M");
        SIPCommMenuBar smileyMenuBar = new SIPCommMenuBar();
        smileyMenuBar.setOpaque(false);
        smileyMenuBar.setLayout((LayoutManager)new FlowLayout(1, 0, 0));
        smileyMenuBar.add((JMenu)((Object)this.smileysBox));
        this.add((Component)smileyMenuBar);
    }

    public void dispose() {
        this.pluginContainer.dispose();
        this.historyButton.dispose();
        if (this.chatSession != null && this.chatSession instanceof MetaContactChatSession) {
            this.chatSession.removeChatTransportChangeListener(this);
        }
        if (this.chatSession != null && this.chatSession instanceof ConferenceChatSession) {
            ((ConferenceChatSession)this.chatSession).removeLocalUserRoleListener(this);
        }
    }

    @Override
    public void chatChanged(ChatPanel chatPanel) {
        if (chatPanel == null) {
            this.setChatSession(null);
        } else {
            MetaContact contact = GuiActivator.getUIService().getChatContact(chatPanel);
            for (PluginComponent c : this.pluginContainer.getPluginComponents()) {
                c.setCurrentContact(contact);
            }
            ChatSession chatSession = chatPanel.getChatSession();
            this.setChatSession(chatSession);
            this.leaveChatRoomButton.setEnabled(chatSession instanceof ConferenceChatSession);
            this.desktopSharingButton.setEnabled(!(chatSession instanceof ConferenceChatSession));
            this.inviteButton.setEnabled(chatPanel.findInviteChatTransport() != null);
            this.sendFileButton.setEnabled(chatPanel.findFileTransferChatTransport() != null);
            this.inviteButton.setEnabled(!chatPanel.isPrivateMessagingChat());
            if (chatSession instanceof ConferenceChatSession) {
                this.updateInviteContactButton();
                this.callButton.setVisible(false);
                this.callVideoButton.setVisible(false);
                this.callButton.setEnabled(true);
                this.callVideoButton.setEnabled(true);
            } else if (contact != null) {
                this.callButton.setVisible(true);
                this.callVideoButton.setVisible(true);
                new UpdateCallButtonWorker(contact).start();
            }
            this.changeHistoryButtonsState(chatPanel);
            this.setCallButtonsName();
            this.setCallButtonsIcons();
            this.currentChatTransportChanged(chatSession);
        }
    }

    private List<ChatTransport> getOperationSetForCapabilities(List<ChatTransport> transports, Class<? extends OperationSet> opSetClass) {
        ArrayList<ChatTransport> list = new ArrayList<ChatTransport>();
        for (ChatTransport transport : transports) {
            Contact contact;
            ProtocolProviderService protocolProvider = transport.getProtocolProvider();
            OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)protocolProvider.getOperationSet(OperationSetContactCapabilities.class);
            OperationSetPersistentPresence presOpSet = (OperationSetPersistentPresence)protocolProvider.getOperationSet(OperationSetPersistentPresence.class);
            if (capOpSet == null) {
                list.add(transport);
                continue;
            }
            if (presOpSet == null || (contact = presOpSet.findContactByID(transport.getName())) == null || capOpSet.getOperationSet(contact, opSetClass) == null) continue;
            list.add(transport);
        }
        return list;
    }

    @Override
    public void currentChatTransportChanged(ChatSession chatSession) {
        if (chatSession == null) {
            return;
        }
        ChatTransport currentTransport = chatSession.getCurrentChatTransport();
        Object currentDescriptor = currentTransport.getDescriptor();
        if (currentDescriptor instanceof Contact) {
            Contact contact = (Contact)currentDescriptor;
            for (PluginComponent c : this.pluginContainer.getPluginComponents()) {
                c.setCurrentContact(contact, currentTransport.getResourceName());
            }
        }
    }

    @Override
    public void currentChatTransportUpdated(int eventID) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        String buttonText = button.getName();
        ChatPanel chatPanel = this.chatContainer.getCurrentChat();
        if (buttonText.equals("previous")) {
            chatPanel.loadPreviousPageFromHistory();
        } else if (buttonText.equals("next")) {
            chatPanel.loadNextPageFromHistory();
        } else if (buttonText.equals("sendFile")) {
            SipCommFileChooser scfc = GenericFileDialog.create(null, (String)"Send file...", (int)0, (String)ConfigurationUtils.getSendFileLastDir());
            File selectedFile = scfc.getFileFromDialog();
            if (selectedFile != null) {
                ConfigurationUtils.setSendFileLastDir((String)selectedFile.getParent());
                this.chatContainer.getCurrentChat().sendFile(selectedFile);
            }
        } else if (buttonText.equals("invite")) {
            ChatInviteDialog inviteDialog = new ChatInviteDialog(chatPanel);
            inviteDialog.setVisible(true);
        } else if (buttonText.equals("leave")) {
            ChatRoomWrapper chatRoomWrapper = (ChatRoomWrapper)chatPanel.getChatSession().getDescriptor();
            ChatRoomWrapper chatRoomWrapper2 = GuiActivator.getMUCService().leaveChatRoom(chatRoomWrapper);
        } else if (buttonText.equals("call")) {
            this.call(false, false);
        } else if (buttonText.equals("callVideo")) {
            this.call(true, false);
        } else if (buttonText.equals("desktop")) {
            this.call(true, true);
        } else if (buttonText.equals("options")) {
            GuiActivator.getUIService().getConfigurationContainer().setVisible(true);
        } else if (buttonText.equals("font")) {
            chatPanel.showFontChooserDialog();
        } else if (buttonText.equals("createConference")) {
            chatPanel.showChatConferenceDialog();
        }
    }

    public HistorySelectorBox getHistoryButton() {
        return this.historyButton;
    }

    public SmileysSelectorBox getSmileysBox() {
        return this.smileysBox;
    }

    public void changeHistoryButtonsState(ChatPanel chatPanel) {
        ChatConversationPanel convPanel = chatPanel.getChatConversationPanel();
        long firstMsgInHistory = chatPanel.getFirstHistoryMsgTimestamp().getTime();
        long lastMsgInHistory = chatPanel.getLastHistoryMsgTimestamp().getTime();
        Date firstMsgInPage = convPanel.getPageFirstMsgTimestamp();
        Date lastMsgInPage = convPanel.getPageLastMsgTimestamp();
        if (firstMsgInHistory == 0L || lastMsgInHistory == 0L) {
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            return;
        }
        this.previousButton.setEnabled(firstMsgInHistory < firstMsgInPage.getTime());
        this.nextButton.setEnabled(lastMsgInPage.getTime() > 0L && lastMsgInHistory > lastMsgInPage.getTime());
    }

    private void setChatSession(ChatSession chatSession) {
        if (this.chatSession != chatSession) {
            if (this.chatSession instanceof MetaContactChatSession) {
                this.chatSession.removeChatTransportChangeListener(this);
            }
            if (this.chatSession instanceof ConferenceChatSession) {
                ((ConferenceChatSession)this.chatSession).removeLocalUserRoleListener(this);
            }
            this.chatSession = chatSession;
            if (this.chatSession instanceof MetaContactChatSession) {
                this.chatSession.addChatTransportChangeListener(this);
            }
            if (this.chatSession instanceof ConferenceChatSession) {
                ((ConferenceChatSession)this.chatSession).addLocalUserRoleListener(this);
            }
        }
    }

    private void addSeparator() {
        this.add(new JSeparator(1));
    }

    public void loadSkin() {
        this.inviteButton.setIconImage(ImageLoader.getImage(ImageLoader.ADD_TO_CHAT_ICON));
        this.historyButton.loadSkin();
        this.sendFileButton.setIconImage(ImageLoader.getImage(ImageLoader.SEND_FILE_ICON));
        this.fontButton.setIconImage(ImageLoader.getImage(ImageLoader.FONT_ICON));
        this.previousButton.setIconImage(ImageLoader.getImage(ImageLoader.PREVIOUS_ICON));
        this.nextButton.setIconImage(ImageLoader.getImage(ImageLoader.NEXT_ICON));
        this.leaveChatRoomButton.setIconImage(ImageLoader.getImage(ImageLoader.LEAVE_ICON));
        this.desktopSharingButton.setIconImage(ImageLoader.getImage(ImageLoader.CHAT_DESKTOP_SHARING));
        this.optionsButton.setIconImage(ImageLoader.getImage(ImageLoader.CHAT_CONFIGURE_ICON));
        this.setCallButtonsIcons();
    }

    private void call(boolean isVideo, boolean isDesktopSharing) {
        ChatPanel chatPanel = this.chatContainer.getCurrentChat();
        ChatSession chatSession = chatPanel.getChatSession();
        Class opSetClass = isVideo ? (isDesktopSharing ? OperationSetDesktopStreaming.class : OperationSetVideoTelephony.class) : OperationSetBasicTelephony.class;
        List<ChatTransport> telTransports = null;
        if (chatSession != null) {
            telTransports = chatSession.getTransportsForOperationSet(opSetClass);
        }
        List<ChatTransport> contactOpSetSupported = this.getOperationSetForCapabilities(telTransports, opSetClass);
        ArrayList<UIContactDetail> res = new ArrayList<UIContactDetail>();
        for (ChatTransport ct : contactOpSetSupported) {
            HashMap<Class<OperationSetBasicTelephony>, ProtocolProviderService> m = new HashMap<Class<OperationSetBasicTelephony>, ProtocolProviderService>();
            m.put(opSetClass, ct.getProtocolProvider());
            UIContactDetailImpl d = new UIContactDetailImpl(ct.getName() + (ct.getResourceName() == null ? "" : "/" + ct.getResourceName()), ct.getDisplayName(), null, ct.getResourceName() == null ? Arrays.asList(GuiActivator.getResources().getI18NString("service.gui.VIA") + ": " + ct.getProtocolProvider().getAccountID().getAccountAddress()) : null, null, m, null, (Object)ct);
            PresenceStatus status = ct.getStatus();
            byte[] statusIconBytes = status.getStatusIcon();
            if (statusIconBytes != null && statusIconBytes.length > 0) {
                d.setStatusIcon(new ImageIcon(ImageLoader.getIndexedProtocolImage(ImageUtils.getBytesInImage((byte[])statusIconBytes), ct.getProtocolProvider())));
            }
            res.add((UIContactDetail)d);
        }
        Point location = new Point(this.callButton.getX(), this.callButton.getY() + this.callButton.getHeight());
        SwingUtilities.convertPointToScreen(location, (Component)((Object)this));
        MetaContact metaContact = GuiActivator.getUIService().getChatContact(chatPanel);
        UIContactImpl uiContact = null;
        if (metaContact != null) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
        }
        CallManager.call(res, uiContact, isVideo, isDesktopSharing, (JComponent)((Object)this.callButton), location);
    }

    private void setCallButtonsName() {
        if (this.chatSession instanceof ConferenceChatSession) {
            this.callButton.setName("createConference");
            this.callVideoButton.setName("createConference");
            this.callButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CREATE_JOIN_VIDEO_CONFERENCE"));
            this.callVideoButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CREATE_JOIN_VIDEO_CONFERENCE"));
        } else {
            this.callButton.setName("call");
            this.callVideoButton.setName("callVideo");
            this.callButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CALL_CONTACT"));
            this.callVideoButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CALL_CONTACT"));
        }
    }

    private void setCallButtonsIcons() {
        if (this.chatSession instanceof ConferenceChatSession) {
            this.callButton.setIconImage(ImageLoader.getImage(ImageLoader.CHAT_ROOM_CALL));
            this.callVideoButton.setIconImage(ImageLoader.getImage(ImageLoader.CHAT_ROOM_VIDEO_CALL));
            this.callButton.setPreferredSize(new Dimension(29, 25));
            this.callVideoButton.setPreferredSize(new Dimension(29, 25));
        } else {
            this.callButton.setIconImage(ImageLoader.getImage(ImageLoader.CHAT_CALL));
            this.callVideoButton.setIconImage(ImageLoader.getImage(ImageLoader.CHAT_VIDEO_CALL));
            this.callButton.setPreferredSize(new Dimension(25, 25));
            this.callVideoButton.setPreferredSize(new Dimension(25, 25));
        }
        this.callButton.repaint();
        this.callVideoButton.repaint();
    }

    public void localUserRoleChanged(ChatRoomLocalUserRoleChangeEvent evt) {
        this.updateInviteContactButton();
    }

    private void updateInviteContactButton() {
        if (this.chatSession instanceof ConferenceChatSession) {
            ChatRoomMemberRole role = ((ChatRoomWrapper)this.chatSession.getDescriptor()).getChatRoom().getUserRole();
            this.inviteButton.setEnabled(role.getRoleIndex() >= 50);
        }
    }

    private class UpdateCallButtonWorker
    extends SwingWorker {
        private MetaContact contact;
        private boolean isCallEnabled = false;
        private boolean isVideoCallEnabled = false;
        private boolean isDesktopSharingEnabled = false;

        UpdateCallButtonWorker(MetaContact contact) {
            this.contact = contact;
        }

        protected Object construct() throws Exception {
            MainToolBar.this.contactPhoneUtil = MetaContactPhoneUtil.getPhoneUtil((MetaContact)this.contact);
            this.isCallEnabled = MainToolBar.this.contactPhoneUtil.isCallEnabled();
            this.isVideoCallEnabled = MainToolBar.this.contactPhoneUtil.isVideoCallEnabled();
            this.isDesktopSharingEnabled = MainToolBar.this.contactPhoneUtil.isDesktopSharingEnabled();
            return null;
        }

        protected void finished() {
            MainToolBar.this.callButton.setEnabled(this.isCallEnabled);
            MainToolBar.this.callVideoButton.setEnabled(this.isVideoCallEnabled);
            MainToolBar.this.desktopSharingButton.setEnabled(this.isDesktopSharingEnabled);
        }
    }
}

