/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.configforms;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.impl.gui.main.configforms.ConfigFormDescriptor;
import net.java.sip.communicator.impl.gui.main.configforms.ConfigFormListCellRenderer;
import net.java.sip.communicator.impl.gui.main.configforms.ConfigurationFrame;
import net.java.sip.communicator.service.gui.ConfigurationForm;

public class ConfigFormList
extends JList
implements ListSelectionListener {
    private final DefaultListModel listModel = new DefaultListModel();
    private final ConfigurationFrame configFrame;

    public ConfigFormList(ConfigurationFrame configFrame) {
        this.configFrame = configFrame;
        this.setOpaque(false);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(1);
        this.setCellRenderer(new ConfigFormListCellRenderer());
        this.setModel(this.listModel);
        this.addListSelectionListener(this);
    }

    public void addConfigForm(ConfigurationForm configForm) {
        ConfigFormDescriptor descriptor;
        int i;
        if (configForm == null) {
            throw new IllegalArgumentException("configForm");
        }
        int count = this.listModel.size();
        int configFormIndex = configForm.getIndex();
        for (i = 0; i < count && configFormIndex >= (descriptor = (ConfigFormDescriptor)this.listModel.get(i)).getConfigForm().getIndex(); ++i) {
        }
        this.listModel.add(i, new ConfigFormDescriptor(configForm));
    }

    public void removeConfigForm(ConfigurationForm configForm) {
        ConfigFormDescriptor descriptor = this.findDescriptor(configForm);
        if (descriptor != null) {
            this.listModel.removeElement(descriptor);
        }
    }

    public void setSelected(ConfigurationForm configForm) {
        ConfigFormDescriptor descriptor = this.findDescriptor(configForm);
        if (descriptor != null) {
            this.setSelectedValue(descriptor, true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ConfigFormDescriptor configFormDescriptor;
        if (!e.getValueIsAdjusting() && (configFormDescriptor = (ConfigFormDescriptor)this.getSelectedValue()) != null) {
            this.configFrame.showFormContent(configFormDescriptor);
        }
    }

    private ConfigFormDescriptor findDescriptor(ConfigurationForm configForm) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            ConfigFormDescriptor descriptor = (ConfigFormDescriptor)this.listModel.getElementAt(i);
            if (!descriptor.getConfigForm().equals(configForm)) continue;
            return descriptor;
        }
        return null;
    }
}

