/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.busylampfield;

import java.util.LinkedHashMap;
import java.util.Map;
import net.java.sip.communicator.plugin.busylampfield.BLFContactSourceService;
import net.java.sip.communicator.plugin.busylampfield.CustomActionsBLFSourceContact;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.customcontactactions.CustomContactActionsService;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyBLF;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.BLFStatusEvent;
import net.java.sip.communicator.service.protocol.event.BLFStatusListener;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class BLFActivator
implements BundleActivator,
ServiceListener,
BLFStatusListener {
    static BundleContext bundleContext;
    private static final String BLF_PLUGIN_ENABLED = "net.java.sip.communicator.plugin.busylampfield.ENABLED";
    private static final String BLF_DEFAULT_GROUP_NAME = "Monitored Lines";
    private Map<String, ServiceRegistration<ContactSourceService>> currentBLFGroups = new LinkedHashMap<String, ServiceRegistration<ContactSourceService>>();

    public void start(BundleContext bundleContext) throws Exception {
        ConfigurationService config = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        if (!config.getBoolean(BLF_PLUGIN_ENABLED, false)) {
            return;
        }
        BLFActivator.bundleContext = bundleContext;
        bundleContext.addServiceListener((ServiceListener)this);
        this.initProviders();
        bundleContext.registerService(CustomContactActionsService.class.getName(), (Object)new CustomActionsBLFSourceContact(), null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object service = bundleContext.getService(serviceRef);
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        switch (serviceEvent.getType()) {
            case 1: {
                this.handleProviderAdded((ProtocolProviderService)service);
                break;
            }
            case 4: {
                this.handleProviderRemoved((ProtocolProviderService)service);
            }
        }
    }

    private void initProviders() {
        for (ServiceReference serRef : ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderService.class)) {
            this.handleProviderAdded((ProtocolProviderService)bundleContext.getService(serRef));
        }
    }

    private void handleProviderAdded(ProtocolProviderService protocolProvider) {
        OperationSetTelephonyBLF opset = (OperationSetTelephonyBLF)protocolProvider.getOperationSet(OperationSetTelephonyBLF.class);
        if (opset == null) {
            return;
        }
        opset.addStatusListener((BLFStatusListener)this);
        for (OperationSetTelephonyBLF.Line line : opset.getCurrentlyMonitoredLines()) {
            BLFContactSourceService css;
            ServiceRegistration serviceReg;
            String groupName = line.getGroup();
            if (groupName == null) {
                groupName = BLF_DEFAULT_GROUP_NAME;
            }
            if ((serviceReg = this.currentBLFGroups.get(groupName)) != null) {
                css = (BLFContactSourceService)bundleContext.getService(serviceReg.getReference());
                css.addLine(line);
                continue;
            }
            css = new BLFContactSourceService(groupName, this.currentBLFGroups.size() + 1);
            serviceReg = bundleContext.registerService(ContactSourceService.class, (Object)css, null);
            this.currentBLFGroups.put(groupName, (ServiceRegistration<ContactSourceService>)serviceReg);
            css.addLine(line);
        }
    }

    private void handleProviderRemoved(ProtocolProviderService protocolProvider) {
        OperationSetTelephonyBLF opset = (OperationSetTelephonyBLF)protocolProvider.getOperationSet(OperationSetTelephonyBLF.class);
        if (opset == null) {
            return;
        }
        opset.removeStatusListener((BLFStatusListener)this);
        for (OperationSetTelephonyBLF.Line line : opset.getCurrentlyMonitoredLines()) {
            ServiceRegistration<ContactSourceService> serviceReg;
            String groupName = line.getGroup();
            if (groupName == null) {
                groupName = BLF_DEFAULT_GROUP_NAME;
            }
            if ((serviceReg = this.currentBLFGroups.remove(groupName)) == null) continue;
            serviceReg.unregister();
        }
    }

    public void blfStatusChanged(BLFStatusEvent event) {
        ServiceRegistration<ContactSourceService> serviceReg;
        if (!(event.getSource() instanceof OperationSetTelephonyBLF.Line)) {
            return;
        }
        OperationSetTelephonyBLF.Line line = (OperationSetTelephonyBLF.Line)event.getSource();
        String gr = line.getGroup();
        if (gr == null) {
            gr = BLF_DEFAULT_GROUP_NAME;
        }
        if ((serviceReg = this.currentBLFGroups.get(gr)) == null) {
            return;
        }
        BLFContactSourceService css = (BLFContactSourceService)bundleContext.getService(serviceReg.getReference());
        css.updateLineStatus(line, event.getType());
    }
}

