/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globaldisplaydetails;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.globaldisplaydetails.GlobalDisplayDetailsActivator;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.globaldisplaydetails.event.GlobalAvatarChangeEvent;
import net.java.sip.communicator.service.globaldisplaydetails.event.GlobalDisplayDetailsListener;
import net.java.sip.communicator.service.globaldisplaydetails.event.GlobalDisplayNameChangeEvent;
import net.java.sip.communicator.service.protocol.AccountInfoUtils;
import net.java.sip.communicator.service.protocol.OperationSetAvatar;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.AvatarEvent;
import net.java.sip.communicator.service.protocol.event.AvatarListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.ServerStoredDetailsChangeEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredDetailsChangeListener;
import net.java.sip.communicator.util.AvatarCacheUtils;
import net.java.sip.communicator.util.account.AccountUtils;
import org.jitsi.util.StringUtils;

public class GlobalDisplayDetailsImpl
implements GlobalDisplayDetailsService,
RegistrationStateChangeListener,
ServerStoredDetailsChangeListener,
AvatarListener {
    private static final String GLOBAL_DISPLAY_NAME_PROP = "net.java.sip.communicator.impl.gui.main.presence.GLOBAL_DISPLAY_NAME";
    private List<GlobalDisplayDetailsListener> displayDetailsListeners = new ArrayList<GlobalDisplayDetailsListener>();
    private String currentFirstName;
    private String currentLastName;
    private String currentDisplayName;
    private String provisionedDisplayName = GlobalDisplayDetailsActivator.getConfigurationService().getString("net.java.sip.communicator.impl.gui.main.presence.GLOBAL_DISPLAY_NAME", null);
    private static byte[] globalAvatar;
    private String globalDisplayName;

    public GlobalDisplayDetailsImpl() {
        Iterator providersIter = AccountUtils.getRegisteredProviders().iterator();
        while (providersIter.hasNext()) {
            ((ProtocolProviderService)providersIter.next()).addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        }
    }

    @Override
    public String getDisplayName(ProtocolProviderService pps) {
        int atIndex;
        OperationSetServerStoredAccountInfo accountInfoOpSet = (OperationSetServerStoredAccountInfo)pps.getOperationSet(OperationSetServerStoredAccountInfo.class);
        String displayName = "";
        if (accountInfoOpSet != null) {
            displayName = AccountInfoUtils.getDisplayName((OperationSetServerStoredAccountInfo)accountInfoOpSet);
        }
        if (!(displayName != null && displayName.length() != 0 || (displayName = this.getGlobalDisplayName()) != null && displayName.length() != 0 || (displayName = pps.getAccountID().getUserID()) == null || (atIndex = displayName.lastIndexOf("@")) <= 0)) {
            displayName = displayName.substring(0, atIndex);
        }
        return displayName;
    }

    @Override
    public String getGlobalDisplayName() {
        if (!StringUtils.isNullOrEmpty((String)this.provisionedDisplayName)) {
            return this.provisionedDisplayName;
        }
        return this.globalDisplayName;
    }

    @Override
    public void setGlobalDisplayName(String displayName) {
        this.globalDisplayName = displayName;
    }

    @Override
    public byte[] getGlobalDisplayAvatar() {
        return globalAvatar;
    }

    @Override
    public void setGlobalDisplayAvatar(byte[] avatar) {
        globalAvatar = avatar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlobalDisplayDetailsListener(GlobalDisplayDetailsListener l) {
        List<GlobalDisplayDetailsListener> list = this.displayDetailsListeners;
        synchronized (list) {
            if (!this.displayDetailsListeners.contains(l)) {
                this.displayDetailsListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGlobalDisplayDetailsListener(GlobalDisplayDetailsListener l) {
        List<GlobalDisplayDetailsListener> list = this.displayDetailsListeners;
        synchronized (list) {
            if (this.displayDetailsListeners.contains(l)) {
                this.displayDetailsListeners.remove(l);
            }
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        ProtocolProviderService protocolProvider = evt.getProvider();
        if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
            OperationSetServerStoredAccountInfo serverStoredAccountInfo;
            OperationSetAvatar avatarOpSet;
            OperationSetServerStoredAccountInfo accountInfoOpSet = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class);
            if (accountInfoOpSet != null) {
                new UpdateAccountInfo(protocolProvider, accountInfoOpSet, false).start();
            }
            if ((avatarOpSet = (OperationSetAvatar)protocolProvider.getOperationSet(OperationSetAvatar.class)) != null) {
                avatarOpSet.addAvatarListener((AvatarListener)this);
            }
            if ((serverStoredAccountInfo = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class)) != null) {
                serverStoredAccountInfo.addServerStoredDetailsChangeListener((ServerStoredDetailsChangeListener)this);
            }
        } else if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERING) || evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
            OperationSetServerStoredAccountInfo serverStoredAccountInfo;
            OperationSetAvatar avatarOpSet = (OperationSetAvatar)protocolProvider.getOperationSet(OperationSetAvatar.class);
            if (avatarOpSet != null) {
                avatarOpSet.removeAvatarListener((AvatarListener)this);
            }
            if ((serverStoredAccountInfo = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class)) != null) {
                serverStoredAccountInfo.removeServerStoredDetailsChangeListener((ServerStoredDetailsChangeListener)this);
            }
        }
    }

    public void avatarChanged(AvatarEvent event) {
        globalAvatar = event.getNewAvatar();
        if (globalAvatar == null) {
            globalAvatar = GlobalDisplayDetailsActivator.getResources().getImageInBytes("service.gui.DEFAULT_USER_PHOTO");
        }
        AvatarCacheUtils.cacheAvatar((ProtocolProviderService)event.getSourceProvider(), (byte[])globalAvatar);
        this.fireGlobalAvatarEvent(globalAvatar);
    }

    public void serverStoredDetailsChanged(ServerStoredDetailsChangeEvent evt) {
        if (!StringUtils.isNullOrEmpty((String)this.provisionedDisplayName)) {
            return;
        }
        if (evt.getNewValue() instanceof ServerStoredDetails.DisplayNameDetail && (evt.getEventID() == 1 || evt.getEventID() == 3)) {
            ProtocolProviderService protocolProvider = evt.getProvider();
            OperationSetServerStoredAccountInfo accountInfoOpSet = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class);
            new UpdateAccountInfo(evt.getProvider(), accountInfoOpSet, true).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGlobalDisplayNameEvent(String displayName) {
        List<GlobalDisplayDetailsListener> listeners;
        List<GlobalDisplayDetailsListener> list = this.displayDetailsListeners;
        synchronized (list) {
            listeners = Collections.unmodifiableList(this.displayDetailsListeners);
        }
        Iterator<GlobalDisplayDetailsListener> listIter = listeners.iterator();
        while (listIter.hasNext()) {
            listIter.next().globalDisplayNameChanged(new GlobalDisplayNameChangeEvent(this, displayName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGlobalAvatarEvent(byte[] avatar) {
        List<GlobalDisplayDetailsListener> listeners;
        List<GlobalDisplayDetailsListener> list = this.displayDetailsListeners;
        synchronized (list) {
            listeners = Collections.unmodifiableList(this.displayDetailsListeners);
        }
        Iterator<GlobalDisplayDetailsListener> listIter = listeners.iterator();
        while (listIter.hasNext()) {
            listIter.next().globalDisplayAvatarChanged(new GlobalAvatarChangeEvent(this, avatar));
        }
    }

    static /* synthetic */ byte[] access$002(byte[] x0) {
        globalAvatar = x0;
        return x0;
    }

    private class UpdateAccountInfo
    extends Thread {
        private ProtocolProviderService protocolProvider;
        private OperationSetServerStoredAccountInfo accountInfoOpSet;
        private boolean isUpdate;

        UpdateAccountInfo(ProtocolProviderService protocolProvider, OperationSetServerStoredAccountInfo accountInfoOpSet, boolean isUpdate) {
            this.protocolProvider = protocolProvider;
            this.accountInfoOpSet = accountInfoOpSet;
        }

        @Override
        public void run() {
            String displayName;
            String lastName;
            String firstName;
            if (globalAvatar == null) {
                byte[] accountImage;
                GlobalDisplayDetailsImpl.access$002(AvatarCacheUtils.getCachedAvatar((ProtocolProviderService)this.protocolProvider));
                if (globalAvatar == null && (accountImage = AccountInfoUtils.getImage((OperationSetServerStoredAccountInfo)this.accountInfoOpSet)) != null && accountImage.length > 0) {
                    GlobalDisplayDetailsImpl.access$002(accountImage);
                    AvatarCacheUtils.cacheAvatar((ProtocolProviderService)this.protocolProvider, (byte[])accountImage);
                }
                if (globalAvatar != null && globalAvatar.length > 0) {
                    GlobalDisplayDetailsImpl.this.fireGlobalAvatarEvent(globalAvatar);
                }
            }
            if (!StringUtils.isNullOrEmpty((String)GlobalDisplayDetailsImpl.this.provisionedDisplayName) || !StringUtils.isNullOrEmpty((String)GlobalDisplayDetailsImpl.this.globalDisplayName) && !this.isUpdate) {
                return;
            }
            if (GlobalDisplayDetailsImpl.this.currentFirstName == null && !StringUtils.isNullOrEmpty((String)(firstName = AccountInfoUtils.getFirstName((OperationSetServerStoredAccountInfo)this.accountInfoOpSet)))) {
                GlobalDisplayDetailsImpl.this.currentFirstName = firstName;
            }
            if (GlobalDisplayDetailsImpl.this.currentLastName == null && !StringUtils.isNullOrEmpty((String)(lastName = AccountInfoUtils.getLastName((OperationSetServerStoredAccountInfo)this.accountInfoOpSet)))) {
                GlobalDisplayDetailsImpl.this.currentLastName = lastName;
            }
            if (GlobalDisplayDetailsImpl.this.currentFirstName == null && GlobalDisplayDetailsImpl.this.currentLastName == null && (displayName = AccountInfoUtils.getDisplayName((OperationSetServerStoredAccountInfo)this.accountInfoOpSet)) != null) {
                GlobalDisplayDetailsImpl.this.currentDisplayName = displayName;
            }
            this.setGlobalDisplayName();
        }

        protected void setGlobalDisplayName() {
            String accountName = null;
            if (!StringUtils.isNullOrEmpty((String)GlobalDisplayDetailsImpl.this.currentFirstName)) {
                accountName = GlobalDisplayDetailsImpl.this.currentFirstName;
            }
            if (!StringUtils.isNullOrEmpty((String)GlobalDisplayDetailsImpl.this.currentLastName)) {
                accountName = StringUtils.isNullOrEmpty((String)accountName) ? GlobalDisplayDetailsImpl.this.currentLastName : accountName + " " + GlobalDisplayDetailsImpl.this.currentLastName;
            }
            if (GlobalDisplayDetailsImpl.this.currentFirstName == null && GlobalDisplayDetailsImpl.this.currentLastName == null && GlobalDisplayDetailsImpl.this.currentDisplayName != null) {
                accountName = GlobalDisplayDetailsImpl.this.currentDisplayName;
            }
            GlobalDisplayDetailsImpl.this.globalDisplayName = accountName;
            if (!StringUtils.isNullOrEmpty((String)GlobalDisplayDetailsImpl.this.globalDisplayName)) {
                GlobalDisplayDetailsImpl.this.fireGlobalDisplayNameEvent(GlobalDisplayDetailsImpl.this.globalDisplayName);
            }
        }
    }
}

