/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.generic;

import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.TransformLayer;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.Logger;

public class PredictableTransformLayer
implements TransformLayer {
    private static final Logger logger = Logger.getLogger(PredictableTransformLayer.class);

    public MessageDeliveredEvent messageDelivered(MessageDeliveredEvent evt) {
        logger.debug((Object)"Message Delivered Transformation, transform a message after it has been sent.");
        logger.debug((Object)("IN: " + evt.getSourceMessage().getContent()));
        Message transformedMessage = this.createMessage(evt.getDestinationContact(), evt.getSourceMessage(), "DELIVERED");
        logger.debug((Object)("OUT: " + transformedMessage.getContent()));
        return new MessageDeliveredEvent(transformedMessage, evt.getDestinationContact(), evt.getTimestamp());
    }

    public MessageDeliveryFailedEvent messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
        logger.debug((Object)"Message Delivery Failed Transformation, transform a message after it has failed to be sent.");
        logger.debug((Object)("IN: " + evt.getSourceMessage().getContent()));
        Message transformedMessage = this.createMessage(evt.getDestinationContact(), evt.getSourceMessage(), "DELIVERY_FAILED");
        logger.debug((Object)("OUT: " + transformedMessage.getContent()));
        return new MessageDeliveryFailedEvent(transformedMessage, evt.getDestinationContact(), evt.getErrorCode());
    }

    public MessageDeliveredEvent[] messageDeliveryPending(MessageDeliveredEvent evt) {
        logger.debug((Object)"Message Delivered Transformation, transform a message after it has failed to be sent.");
        logger.debug((Object)("IN: " + evt.getSourceMessage().getContent()));
        Message transformedMessage = this.createMessage(evt.getDestinationContact(), evt.getSourceMessage(), "DELIVERY_PENDING");
        logger.debug((Object)("OUT: " + transformedMessage.getContent()));
        return new MessageDeliveredEvent[]{new MessageDeliveredEvent(transformedMessage, evt.getDestinationContact(), evt.getTimestamp())};
    }

    public MessageReceivedEvent messageReceived(MessageReceivedEvent evt) {
        logger.debug((Object)"Message Received Transformation, transform a message after it has been received.");
        logger.debug((Object)("IN: " + evt.getSourceMessage().getContent()));
        Message transformedMessage = this.createMessage(evt.getSourceContact(), evt.getSourceMessage(), "RECEIVED");
        logger.debug((Object)("OUT: " + transformedMessage.getContent()));
        return new MessageReceivedEvent(transformedMessage, evt.getSourceContact(), evt.getTimestamp());
    }

    private Message createMessage(Contact contact, Message message, String action) {
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        return imOpSet.createMessage("__" + action + "__" + message.getContent());
    }
}

