/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.audio;

import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;
import net.sf.fmj.media.AbstractGainControl;

class JavaSoundGainControl
extends AbstractGainControl {
    private final FloatControl masterGainControl;
    private final BooleanControl muteControl;
    private final float max;
    private final float min;
    private final float range;
    private final boolean gainUnitsDb;

    public JavaSoundGainControl(FloatControl masterGainControl, BooleanControl muteControl) {
        this.masterGainControl = masterGainControl;
        this.muteControl = muteControl;
        if (masterGainControl != null) {
            this.min = masterGainControl.getMinimum();
            this.max = masterGainControl.getMaximum();
            this.gainUnitsDb = masterGainControl.getUnits().equals("dB");
        } else {
            this.max = 0.0f;
            this.min = 0.0f;
            this.gainUnitsDb = false;
        }
        this.range = this.max - this.min;
    }

    @Override
    public float getDB() {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            return this.masterGainControl.getValue();
        }
        return JavaSoundGainControl.levelToDb(this.getLevel());
    }

    @Override
    public float getLevel() {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            return JavaSoundGainControl.dBToLevel(this.masterGainControl.getValue());
        }
        float value = this.masterGainControl.getValue();
        return (value - this.min) / this.range;
    }

    @Override
    public boolean getMute() {
        if (this.muteControl == null) {
            return false;
        }
        return this.muteControl.getValue();
    }

    @Override
    public float setDB(float gain) {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            this.masterGainControl.setValue(gain);
        } else {
            this.setLevel(JavaSoundGainControl.dBToLevel(gain));
        }
        float result = this.getDB();
        this.notifyListenersGainChangeEvent();
        return result;
    }

    @Override
    public float setLevel(float level) {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            this.masterGainControl.setValue(JavaSoundGainControl.levelToDb(level));
        } else {
            level = this.min + level * this.range;
            this.masterGainControl.setValue(level);
        }
        float result = this.getLevel();
        this.notifyListenersGainChangeEvent();
        return result;
    }

    @Override
    public void setMute(boolean mute) {
        if (this.muteControl == null) {
            return;
        }
        this.muteControl.setValue(mute);
        this.notifyListenersGainChangeEvent();
    }
}

