/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.util.ArrayList;
import java.util.Arrays;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.ActiveSpeakerDetector;
import org.jitsi.service.neomedia.event.ActiveSpeakerChangedListener;

public class ActiveSpeakerDetectorImpl
implements ActiveSpeakerDetector {
    private static final String IMPL_CLASS_NAME_PNAME = ActiveSpeakerDetectorImpl.class.getName() + ".implClassName";
    private static final String[] IMPL_CLASS_NAMES = new String[]{".DominantSpeakerIdentification", ".BasicActiveSpeakerDetector"};
    private final ActiveSpeakerDetector impl;

    public ActiveSpeakerDetectorImpl() {
        this(ActiveSpeakerDetectorImpl.getImplClassNames());
    }

    public ActiveSpeakerDetectorImpl(String ... implClassNames) {
        ActiveSpeakerDetector impl = null;
        Throwable cause = null;
        for (String implClassName : implClassNames) {
            try {
                Class<?> implClass = Class.forName(ActiveSpeakerDetectorImpl.normalizeClassName(implClassName));
                if (implClass != null && ActiveSpeakerDetector.class.isAssignableFrom(implClass)) {
                    impl = (ActiveSpeakerDetector)implClass.newInstance();
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                cause = t;
            }
            if (impl != null) break;
        }
        if (impl == null) {
            throw new RuntimeException("Failed to initialize an actual ActiveSpeakerDetector implementation, tried classes: " + Arrays.toString(implClassNames), cause);
        }
        this.impl = impl;
    }

    @Override
    public void addActiveSpeakerChangedListener(ActiveSpeakerChangedListener listener) {
        this.impl.addActiveSpeakerChangedListener(listener);
    }

    public ActiveSpeakerDetector getImpl() {
        return this.impl;
    }

    private static String[] getImplClassNames() {
        String[] implClassNames;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        String implClassName = null;
        if (cfg != null && (implClassName = cfg.getString(IMPL_CLASS_NAME_PNAME)) != null && implClassName.length() == 0) {
            implClassName = null;
        }
        if (implClassName == null) {
            implClassNames = IMPL_CLASS_NAMES;
        } else {
            ArrayList<String> implClassNameList = new ArrayList<String>(1 + IMPL_CLASS_NAMES.length);
            implClassNameList.add(ActiveSpeakerDetectorImpl.normalizeClassName(implClassName));
            for (String anImplClassName : IMPL_CLASS_NAMES) {
                if (implClassNameList.contains(anImplClassName = ActiveSpeakerDetectorImpl.normalizeClassName(anImplClassName))) continue;
                implClassNameList.add(anImplClassName);
            }
            implClassNames = implClassNameList.toArray(new String[implClassNameList.size()]);
        }
        return implClassNames;
    }

    @Override
    public void levelChanged(long ssrc, int level) {
        this.impl.levelChanged(ssrc, level);
    }

    private static String normalizeClassName(String className) {
        Package pkg;
        if (className.startsWith(".") && (pkg = ActiveSpeakerDetectorImpl.class.getPackage()) != null) {
            className = pkg.getName() + className;
        }
        return className;
    }

    @Override
    public void removeActiveSpeakerChangedListener(ActiveSpeakerChangedListener listener) {
        this.impl.removeActiveSpeakerChangedListener(listener);
    }
}

