/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.alaw;

import com.ibm.media.codec.audio.AudioPacketizer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class Packetizer
extends AudioPacketizer {
    public Packetizer() {
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ALAW/rtp", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};
        this.packetSize = 160;
        this.PLUGIN_NAME = "A-law Packetizer";
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("alaw", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[]{new PacketSizeAdapter((Codec)this, this.packetSize, true)};
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        double sampleRate = af.getSampleRate();
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("ALAW/rtp", sampleRate, 8, 1, -1, -1, 8, sampleRate, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.setPacketSize(this.packetSize);
        this.reset();
    }

    private synchronized void setPacketSize(int newPacketSize) {
        this.sample_count = this.packetSize = newPacketSize;
        if (this.history == null) {
            this.history = new byte[this.packetSize];
        } else if (this.packetSize > this.history.length) {
            byte[] newHistory = new byte[this.packetSize];
            System.arraycopy(this.history, 0, newHistory, 0, this.historyLength);
            this.history = newHistory;
        }
    }

    private static class PacketSizeAdapter
    extends com.sun.media.controls.PacketSizeAdapter {
        public PacketSizeAdapter(Codec owner, int packetSize, boolean settable) {
            super(owner, packetSize, settable);
        }

        public int setPacketSize(int numBytes) {
            if (numBytes < 10) {
                numBytes = 10;
            }
            if (numBytes > 8000) {
                numBytes = 8000;
            }
            this.packetSize = numBytes;
            ((Packetizer)this.owner).setPacketSize(this.packetSize);
            return this.packetSize;
        }
    }
}

