/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.MessageSipImpl;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.SipMessageProcessor;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.impl.protocol.sip.SipStatusEnum;
import net.java.sip.communicator.service.protocol.AbstractOperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;

public class OperationSetBasicInstantMessagingSipImpl
extends AbstractOperationSetBasicInstantMessaging {
    private static final Logger logger = Logger.getLogger(OperationSetBasicInstantMessagingSipImpl.class);
    private final List<SipMessageProcessor> messageProcessors = new Vector<SipMessageProcessor>();
    private final ProtocolProviderServiceSipImpl sipProvider;
    private final RegistrationStateListener registrationListener;
    private OperationSetPresenceSipImpl opSetPersPresence = null;
    private long seqN = ((Object)((Object)this)).hashCode();
    private final Map<String, Message> sentMsg = new Hashtable<String, Message>(3);
    private final boolean offlineMessageSupported;
    private final SipStatusEnum sipStatusEnum;

    OperationSetBasicInstantMessagingSipImpl(ProtocolProviderServiceSipImpl provider) {
        this.sipProvider = provider;
        this.registrationListener = new RegistrationStateListener();
        provider.addRegistrationStateChangeListener(this.registrationListener);
        this.offlineMessageSupported = provider.getAccountID().getAccountPropertyBoolean((Object)"OFFLINE_MSG_SUPPORTED", false);
        this.sipProvider.registerMethodProcessor("MESSAGE", new BasicInstantMessagingMethodProcessor());
        this.sipStatusEnum = this.sipProvider.getSipStatusEnum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessageProcessor(SipMessageProcessor processor) {
        List<SipMessageProcessor> list = this.messageProcessors;
        synchronized (list) {
            if (!this.messageProcessors.contains(processor)) {
                this.messageProcessors.add(processor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessageProcessor(SipMessageProcessor processor) {
        List<SipMessageProcessor> list = this.messageProcessors;
        synchronized (list) {
            this.messageProcessors.remove(processor);
        }
    }

    public Message createMessage(String content, String contentType, String encoding, String subject) {
        return new MessageSipImpl(content, contentType, encoding, subject);
    }

    public boolean isOfflineMessagingSupported() {
        return this.offlineMessageSupported;
    }

    public boolean isContentTypeSupported(String contentType) {
        return contentType.equals("text/plain") || contentType.equals("text/html");
    }

    public void sendInstantMessage(Contact to, Message message) throws IllegalStateException, IllegalArgumentException {
        Message[] transformedMessages;
        if (!(to instanceof ContactSipImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Sip contact." + to);
        }
        this.assertConnected();
        if (to.getPresenceStatus().equals((Object)this.sipStatusEnum.getStatus("Offline")) && !this.offlineMessageSupported) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"trying to send a message to an offline contact");
            }
            this.fireMessageDeliveryFailed(message, to, 5);
            return;
        }
        for (Message msg : transformedMessages = this.transformSIPMessage(to, message)) {
            Request mes;
            try {
                mes = this.createMessageRequest(to, msg);
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Failed to create the message.", (Throwable)ex);
                this.fireMessageDeliveryFailed(message, to, 4);
                continue;
            }
            try {
                this.sendMessageRequest(mes, to, message);
            }
            catch (TransactionUnavailableException ex) {
                logger.error((Object)"Failed to create messageTransaction.\nThis is most probably a network connection error.", (Throwable)ex);
                this.fireMessageDeliveryFailed(message, to, 2);
            }
            catch (SipException ex) {
                logger.error((Object)"Failed to send the message.", (Throwable)ex);
                this.fireMessageDeliveryFailed(message, to, 4);
            }
        }
    }

    void sendMessageRequest(Request messageRequest, Contact to, Message messageContent) throws TransactionUnavailableException, SipException {
        SipProvider jainSipProvider = this.sipProvider.getDefaultJainSipProvider();
        ClientTransaction messageTransaction = jainSipProvider.getNewClientTransaction(messageRequest);
        messageTransaction.sendRequest();
        String key = ((CallIdHeader)messageRequest.getHeader("Call-ID")).getCallId();
        this.sentMsg.put(key, messageContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request createMessageRequest(Contact to, Message message) throws OperationFailedException {
        Request req;
        ContentLengthHeader contLengthHeader;
        ContentTypeHeader contTypeHeader;
        Address toAddress = null;
        try {
            toAddress = this.sipProvider.parseAddressString(to.getAddress());
        }
        catch (ParseException exc) {
            logger.error((Object)"An unexpected error occurred whileconstructing the address", (Throwable)exc);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the address", 4, (Throwable)exc);
        }
        CallIdHeader callIdHeader = this.sipProvider.getDefaultJainSipProvider().getNewCallId();
        CSeqHeader cSeqHeader = null;
        try {
            OperationSetBasicInstantMessagingSipImpl operationSetBasicInstantMessagingSipImpl = this;
            synchronized (operationSetBasicInstantMessagingSipImpl) {
                cSeqHeader = this.sipProvider.getHeaderFactory().createCSeqHeader(this.seqN++, "MESSAGE");
            }
        }
        catch (InvalidArgumentException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the CSeqHeadder", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the CSeqHeadder", 4, (Throwable)ex);
        }
        catch (ParseException exc) {
            logger.error((Object)"An unexpected error occurred whileconstructing the CSeqHeadder", (Throwable)exc);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the CSeqHeadder", 4, (Throwable)exc);
        }
        String localTag = SipMessageFactory.generateLocalTag();
        FromHeader fromHeader = null;
        ToHeader toHeader = null;
        try {
            fromHeader = this.sipProvider.getHeaderFactory().createFromHeader(this.sipProvider.getOurSipAddress(toAddress), localTag);
            toHeader = this.sipProvider.getHeaderFactory().createToHeader(toAddress, null);
        }
        catch (ParseException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the FromHeader or ToHeader", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the FromHeader or ToHeader", 4, (Throwable)ex);
        }
        ArrayList<ViaHeader> viaHeaders = this.sipProvider.getLocalViaHeaders(toAddress);
        MaxForwardsHeader maxForwards = this.sipProvider.getMaxForwardsHeader();
        try {
            contTypeHeader = this.sipProvider.getHeaderFactory().createContentTypeHeader(this.getType(message), this.getSubType(message));
            if (!"UTF-8".equalsIgnoreCase(message.getEncoding())) {
                contTypeHeader.setParameter("charset", message.getEncoding());
            }
            contLengthHeader = this.sipProvider.getHeaderFactory().createContentLengthHeader(message.getSize());
        }
        catch (ParseException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the content headers", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the content headers", 4, (Throwable)ex);
        }
        catch (InvalidArgumentException exc) {
            logger.error((Object)"An unexpected error occurred whileconstructing the content length header", (Throwable)exc);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the content length header", 4, (Throwable)exc);
        }
        try {
            req = this.sipProvider.getMessageFactory().createRequest(toHeader.getAddress().getURI(), "MESSAGE", callIdHeader, cSeqHeader, fromHeader, toHeader, (List)viaHeaders, maxForwards, contTypeHeader, message.getRawData());
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to create message Request!", (Throwable)ex);
            throw new OperationFailedException("Failed to create message Request!", 4, (Throwable)ex);
        }
        req.addHeader((Header)contLengthHeader);
        return req;
    }

    private Message[] transformSIPMessage(Contact to, Message message) {
        MessageDeliveredEvent msgDeliveryPendingEvt = new MessageDeliveredEvent(message, to);
        MessageDeliveredEvent[] msgDeliveryPendingEvts = this.messageDeliveryPendingTransform(msgDeliveryPendingEvt);
        if (msgDeliveryPendingEvts == null || msgDeliveryPendingEvts.length == 0) {
            return new Message[0];
        }
        OperationSetBasicInstantMessaging opSetBasicIM = (OperationSetBasicInstantMessaging)this.sipProvider.getSupportedOperationSets().get(OperationSetBasicInstantMessaging.class.getName());
        Message[] transformedMessages = new Message[msgDeliveryPendingEvts.length];
        for (int i = 0; i < msgDeliveryPendingEvts.length; ++i) {
            MessageDeliveredEvent event = msgDeliveryPendingEvts[i];
            String content = event.getSourceMessage().getContent();
            transformedMessages[i] = opSetBasicIM.createMessage(content, message.getContentType(), message.getEncoding(), message.getSubject());
        }
        return transformedMessages;
    }

    private String getType(Message msg) {
        String type = msg.getContentType();
        return type.substring(0, type.indexOf(47));
    }

    private String getSubType(Message msg) {
        String subtype = msg.getContentType();
        return subtype.substring(subtype.indexOf(47) + 1);
    }

    private void assertConnected() throws IllegalStateException {
        if (this.sipProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to communicate.");
        }
        if (!this.sipProvider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    void shutdown() {
        this.sipProvider.removeRegistrationStateChangeListener(this.registrationListener);
    }

    private class BasicInstantMessagingMethodProcessor
    extends MethodProcessorAdapter {
        private BasicInstantMessagingMethodProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean processTimeout(TimeoutEvent timeoutEvent) {
            List list = OperationSetBasicInstantMessagingSipImpl.this.messageProcessors;
            synchronized (list) {
                for (SipMessageProcessor listener : OperationSetBasicInstantMessagingSipImpl.this.messageProcessors) {
                    if (listener.processTimeout(timeoutEvent, OperationSetBasicInstantMessagingSipImpl.this.sentMsg)) continue;
                    return true;
                }
            }
            logger.error((Object)("Timeout event thrown : " + timeoutEvent.toString()));
            if (timeoutEvent.isServerTransaction()) {
                logger.warn((Object)"The sender has probably not received our OK");
                return false;
            }
            Request req = timeoutEvent.getClientTransaction().getRequest();
            String content = null;
            try {
                content = new String(req.getRawContent(), this.getCharset(req));
            }
            catch (UnsupportedEncodingException ex) {
                logger.warn((Object)"failed to convert the message charset", (Throwable)ex);
                content = new String(req.getRawContent());
            }
            ToHeader toHeader = (ToHeader)req.getHeader("To");
            if (toHeader == null) {
                logger.error((Object)"received a request without a to header");
                return false;
            }
            ContactSipImpl to = OperationSetBasicInstantMessagingSipImpl.this.opSetPersPresence.resolveContactID(toHeader.getAddress().getURI().toString());
            Message failedMessage = null;
            if (to == null) {
                logger.error((Object)("timeout on a message sent to an unknown contact : " + toHeader.getAddress().getURI().toString()));
                failedMessage = OperationSetBasicInstantMessagingSipImpl.this.createMessage(content);
            } else {
                String key = ((CallIdHeader)req.getHeader("Call-ID")).getCallId();
                failedMessage = (Message)OperationSetBasicInstantMessagingSipImpl.this.sentMsg.get(key);
                if (failedMessage == null) {
                    logger.error((Object)"Couldn't find the sent message.");
                    failedMessage = OperationSetBasicInstantMessagingSipImpl.this.createMessage(content);
                }
            }
            OperationSetBasicInstantMessagingSipImpl.this.fireMessageDeliveryFailed(failedMessage, (Contact)to, 4);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean processRequest(RequestEvent requestEvent) {
            Message newMessage;
            ContactSipImpl from;
            block17: {
                List list = OperationSetBasicInstantMessagingSipImpl.this.messageProcessors;
                synchronized (list) {
                    for (SipMessageProcessor listener : OperationSetBasicInstantMessagingSipImpl.this.messageProcessors) {
                        if (listener.processMessage(requestEvent)) continue;
                        return true;
                    }
                }
                String content = null;
                Request req = requestEvent.getRequest();
                try {
                    content = new String(req.getRawContent(), this.getCharset(req));
                }
                catch (UnsupportedEncodingException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"failed to convert the message charset");
                    }
                    content = new String(requestEvent.getRequest().getRawContent());
                }
                FromHeader fromHeader = (FromHeader)requestEvent.getRequest().getHeader("From");
                if (fromHeader == null) {
                    logger.error((Object)"received a request without a from header");
                    return false;
                }
                from = OperationSetBasicInstantMessagingSipImpl.this.opSetPersPresence.resolveContactID(fromHeader.getAddress().getURI().toString());
                ContentTypeHeader ctheader = (ContentTypeHeader)req.getHeader("Content-Type");
                String ctype = null;
                String cencoding = null;
                if (ctheader == null) {
                    ctype = "text/plain";
                } else {
                    ctype = ctheader.getContentType() + "/" + ctheader.getContentSubType();
                    cencoding = ctheader.getParameter("charset");
                }
                if (cencoding == null) {
                    cencoding = "UTF-8";
                }
                newMessage = OperationSetBasicInstantMessagingSipImpl.this.createMessage(content, ctype, cencoding, null);
                if (from == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("received a message from an unknown contact: " + fromHeader.getAddress().getURI().toString()));
                    }
                    from = fromHeader.getAddress().getDisplayName() != null ? OperationSetBasicInstantMessagingSipImpl.this.opSetPersPresence.createVolatileContact(fromHeader.getAddress().getURI().toString(), fromHeader.getAddress().getDisplayName().toString()) : OperationSetBasicInstantMessagingSipImpl.this.opSetPersPresence.createVolatileContact(fromHeader.getAddress().getURI().toString());
                }
                try {
                    Response ok = OperationSetBasicInstantMessagingSipImpl.this.sipProvider.getMessageFactory().createResponse(200, requestEvent.getRequest());
                    SipStackSharing.getOrCreateServerTransaction(requestEvent).sendResponse(ok);
                }
                catch (ParseException exc) {
                    logger.error((Object)"failed to build the response", (Throwable)exc);
                }
                catch (SipException exc) {
                    logger.error((Object)("failed to send the response : " + exc.getMessage()), (Throwable)exc);
                }
                catch (InvalidArgumentException exc) {
                    if (!logger.isDebugEnabled()) break block17;
                    logger.debug((Object)("Invalid argument for createResponse : " + exc.getMessage()), (Throwable)exc);
                }
            }
            MessageReceivedEvent msgReceivedEvt = new MessageReceivedEvent(newMessage, (Contact)from, new Date());
            OperationSetBasicInstantMessagingSipImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean processResponse(ResponseEvent responseEvent) {
            List list = OperationSetBasicInstantMessagingSipImpl.this.messageProcessors;
            synchronized (list) {
                for (SipMessageProcessor listener : OperationSetBasicInstantMessagingSipImpl.this.messageProcessors) {
                    if (listener.processResponse(responseEvent, OperationSetBasicInstantMessagingSipImpl.this.sentMsg)) continue;
                    return true;
                }
            }
            Request req = responseEvent.getClientTransaction().getRequest();
            int status = responseEvent.getResponse().getStatusCode();
            String content = null;
            try {
                content = new String(req.getRawContent(), this.getCharset(req));
            }
            catch (UnsupportedEncodingException exc) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"failed to convert the message charset", (Throwable)exc);
                }
                content = new String(req.getRawContent());
            }
            ToHeader toHeader = (ToHeader)req.getHeader("To");
            if (toHeader == null) {
                logger.error((Object)"send a request without a to header");
                return false;
            }
            ContactSipImpl to = OperationSetBasicInstantMessagingSipImpl.this.opSetPersPresence.resolveContactID(toHeader.getAddress().getURI().toString());
            if (to == null) {
                logger.error((Object)("Error received a response from an unknown contact : " + toHeader.getAddress().getURI().toString() + " : " + responseEvent.getResponse().getStatusCode() + " " + responseEvent.getResponse().getReasonPhrase()));
                OperationSetBasicInstantMessagingSipImpl.this.fireMessageDeliveryFailed(OperationSetBasicInstantMessagingSipImpl.this.createMessage(content), (Contact)to, 4);
                return false;
            }
            String key = ((CallIdHeader)req.getHeader("Call-ID")).getCallId();
            Message newMessage = (Message)OperationSetBasicInstantMessagingSipImpl.this.sentMsg.get(key);
            if (newMessage == null) {
                logger.error((Object)"Couldn't find the message sent");
                OperationSetBasicInstantMessagingSipImpl.this.fireMessageDeliveryFailed(OperationSetBasicInstantMessagingSipImpl.this.createMessage(content), (Contact)to, 4);
                return true;
            }
            if (status >= 400 && status != 401 && status != 407) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(responseEvent.getResponse().getStatusCode() + " " + responseEvent.getResponse().getReasonPhrase()));
                }
                MessageDeliveryFailedEvent evt = new MessageDeliveryFailedEvent(newMessage, (Contact)to, 2, System.currentTimeMillis(), responseEvent.getResponse().getStatusCode() + " " + responseEvent.getResponse().getReasonPhrase());
                OperationSetBasicInstantMessagingSipImpl.this.fireMessageEvent((EventObject)evt);
                OperationSetBasicInstantMessagingSipImpl.this.sentMsg.remove(key);
            } else if (status == 401 || status == 407) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("proxy asks authentication : " + responseEvent.getResponse().getStatusCode() + " " + responseEvent.getResponse().getReasonPhrase()));
                }
                ClientTransaction clientTransaction = responseEvent.getClientTransaction();
                SipProvider sourceProvider = (SipProvider)responseEvent.getSource();
                try {
                    this.processAuthenticationChallenge(clientTransaction, responseEvent.getResponse(), sourceProvider);
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)"can't solve the challenge", (Throwable)ex);
                    MessageDeliveryFailedEvent evt = new MessageDeliveryFailedEvent(newMessage, (Contact)to, 2, System.currentTimeMillis(), ex.getMessage());
                    OperationSetBasicInstantMessagingSipImpl.this.fireMessageEvent((EventObject)evt);
                    OperationSetBasicInstantMessagingSipImpl.this.sentMsg.remove(key);
                }
            } else if (status >= 200) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Ack received from the network : " + responseEvent.getResponse().getStatusCode() + " " + responseEvent.getResponse().getReasonPhrase()));
                }
                MessageDeliveredEvent msgDeliveredEvt = new MessageDeliveredEvent(newMessage, (Contact)to, new Date());
                OperationSetBasicInstantMessagingSipImpl.this.fireMessageEvent((EventObject)msgDeliveredEvt);
                OperationSetBasicInstantMessagingSipImpl.this.sentMsg.remove(key);
            }
            return true;
        }

        private String getCharset(Request req) {
            String charset = null;
            Header contentTypeHeader = req.getHeader("Content-Type");
            if (contentTypeHeader instanceof ContentTypeHeader) {
                charset = ((ContentTypeHeader)contentTypeHeader).getParameter("charset");
            }
            if (charset == null) {
                charset = "UTF-8";
            }
            return charset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAuthenticationChallenge(ClientTransaction clientTransaction, Response response, SipProvider jainSipProvider) throws OperationFailedException {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Authenticating a message request.");
                }
                ClientTransaction retryTran = null;
                BasicInstantMessagingMethodProcessor basicInstantMessagingMethodProcessor = this;
                synchronized (basicInstantMessagingMethodProcessor) {
                    retryTran = OperationSetBasicInstantMessagingSipImpl.this.sipProvider.getSipSecurityManager().handleChallenge(response, clientTransaction, jainSipProvider, OperationSetBasicInstantMessagingSipImpl.this.seqN++);
                }
                if (retryTran == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"No password supplied or error occured!");
                    }
                    return;
                }
                retryTran.sendRequest();
                return;
            }
            catch (Exception exc) {
                logger.error((Object)"We failed to authenticate a message request.", (Throwable)exc);
                throw new OperationFailedException("Failed to authenticatea message request", 4, (Throwable)exc);
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetBasicInstantMessagingSipImpl.this.opSetPersPresence = (OperationSetPresenceSipImpl)OperationSetBasicInstantMessagingSipImpl.this.sipProvider.getOperationSet(OperationSetPersistentPresence.class);
            }
        }
    }
}

