/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.header.extensions.Replaces;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSubscriber;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyBLF;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.BLFStatusEvent;
import net.java.sip.communicator.service.protocol.event.BLFStatusListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.StringUtils;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OperationSetTelephonyBLFSipImpl
implements OperationSetTelephonyBLF,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(OperationSetTelephonyBLFSipImpl.class);
    public static final String BLF_ENABLED_ACC_PROP = "BLF_ENABLED";
    public static final String BLF_LINE_ACC_PROP_PREFIX = "BLF_LINE";
    public static final String BLF_LINE_ADDR_ACC_PROP_SUFFIX = "Address";
    public static final String BLF_LINE_NAME_ACC_PROP_PREFIX = "Name";
    public static final String BLF_LINE_GROUP_ACC_PROP_PREFIX = "Group";
    public static final String BLF_LINE_PICKUP_ACC_PROP_PREFIX = "Pickup";
    static final String EVENT_PACKAGE = "dialog";
    private static final String CONTENT_SUB_TYPE = "dialog-info+xml";
    private static final int SUBSCRIPTION_DURATION = 3600;
    private static final int REFRESH_MARGIN = 60;
    private final List<BLFStatusListener> listeners = new ArrayList<BLFStatusListener>();
    private List<OperationSetTelephonyBLF.Line> lines = new ArrayList<OperationSetTelephonyBLF.Line>();
    private ProtocolProviderServiceSipImpl provider;
    private final EventPackageSubscriber subscriber;
    private final TimerScheduler timer = new TimerScheduler();
    private static final String ANY_NS = "*";
    private static final String DATA_PROP = LineDetails.class.getCanonicalName();

    public OperationSetTelephonyBLFSipImpl(ProtocolProviderServiceSipImpl provider) {
        this.provider = provider;
        this.provider.addRegistrationStateChangeListener(this);
        this.initLines();
        this.subscriber = new EventPackageSubscriber(this.provider, EVENT_PACKAGE, 3600, CONTENT_SUB_TYPE, this.timer, 60);
        this.provider.registerEvent(EVENT_PACKAGE);
    }

    private void initLines() {
        Map props = this.provider.getAccountID().getAccountProperties();
        HashMap<String, String[]> lines = new HashMap<String, String[]>();
        for (Map.Entry entry : props.entrySet()) {
            String pName = (String)entry.getKey();
            String entryValue = (String)entry.getValue();
            if (!pName.startsWith(BLF_LINE_ACC_PROP_PREFIX) || entryValue == null) continue;
            entryValue = entryValue.trim();
            if (!pName.contains(".") || !(pName = pName.replaceAll("BLF_LINE.", "")).contains(".")) continue;
            String ix = pName.substring(0, pName.lastIndexOf(46)).trim();
            String[] lineValues = (String[])lines.get(ix);
            if (lineValues == null) {
                lineValues = new String[4];
                lines.put(ix, lineValues);
            }
            if (pName.contains(BLF_LINE_ADDR_ACC_PROP_SUFFIX)) {
                lineValues[0] = entryValue;
                continue;
            }
            if (pName.contains(BLF_LINE_NAME_ACC_PROP_PREFIX)) {
                lineValues[1] = entryValue;
                continue;
            }
            if (pName.contains(BLF_LINE_GROUP_ACC_PROP_PREFIX)) {
                lineValues[2] = entryValue;
                continue;
            }
            if (!pName.contains(BLF_LINE_PICKUP_ACC_PROP_PREFIX)) continue;
            lineValues[3] = entryValue;
        }
        for (Map.Entry en : lines.entrySet()) {
            String[] vals = (String[])en.getValue();
            this.lines.add(new OperationSetTelephonyBLF.Line(vals[0], vals[1], vals[2], vals[3], (ProtocolProviderService)this.provider));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(BLFStatusListener listener) {
        List<BLFStatusListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(BLFStatusListener listener) {
        List<BLFStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void pickup(OperationSetTelephonyBLF.Line line) throws OperationFailedException {
        LineDetails details = (LineDetails)line.getData((Object)DATA_PROP);
        if (details == null) {
            return;
        }
        Address targetAddress = null;
        try {
            String address = line.getAddress();
            if (this.asteriskMode(details)) {
                if (StringUtils.isNullOrEmpty((String)line.getPickupTemplate(), (boolean)true)) {
                    return;
                }
                address = line.getPickupTemplate().replace("\\1", address);
            }
            targetAddress = this.provider.parseAddressString(address);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to parse address string " + line.getAddress(), 11, ex, logger);
        }
        OperationSetBasicTelephonySipImpl telOpSet = (OperationSetBasicTelephonySipImpl)this.provider.getOperationSet(OperationSetBasicTelephony.class);
        if (this.asteriskMode(details)) {
            telOpSet.createOutgoingCall(targetAddress, null, null);
            return;
        }
        Replaces replacesHeader = null;
        SipURI sipURI = (SipURI)targetAddress.getURI();
        try {
            replacesHeader = (Replaces)((HeaderFactoryImpl)this.provider.getHeaderFactory()).createReplacesHeader(details.callID, details.remoteTag, details.localTag);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create Replaces header for target call-id " + details.callID, 11, ex, logger);
        }
        try {
            sipURI.setHeader("Replaces", URLEncoder.encode(replacesHeader.encodeBody(new StringBuilder()).toString(), "UTF-8"));
        }
        catch (Exception ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to set Replaces header " + replacesHeader + " to SipURI " + sipURI, 4, ex, logger);
        }
        telOpSet.createOutgoingCall(targetAddress, null, null);
    }

    private boolean asteriskMode(LineDetails details) {
        return StringUtils.isNullOrEmpty((String)details.callID) || StringUtils.isNullOrEmpty((String)details.localTag) || StringUtils.isNullOrEmpty((String)details.remoteTag);
    }

    public List<OperationSetTelephonyBLF.Line> getCurrentlyMonitoredLines() {
        return new ArrayList<OperationSetTelephonyBLF.Line>(this.lines);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
            for (OperationSetTelephonyBLF.Line line : this.lines) {
                try {
                    this.subscriber.poll(new DialogInfoSubscriberSubscription(this.provider.parseAddressString(line.getAddress()), line));
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)"Failed to create and send the subscription", (Throwable)ex);
                }
                catch (ParseException ex) {
                    logger.error((Object)"Failed to create and send the subscription", (Throwable)ex);
                }
            }
        } else if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERING)) {
            this.timer.cancel();
        } else if (evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || evt.getNewState().equals((Object)RegistrationState.AUTHENTICATION_FAILED) || evt.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
            if (this.subscriber != null) {
                for (OperationSetTelephonyBLF.Line line : this.lines) {
                    block13: {
                        try {
                            this.subscriber.removeSubscription(this.provider.parseAddressString(line.getAddress()));
                        }
                        catch (ParseException ex) {
                            if (!logger.isDebugEnabled()) break block13;
                            logger.debug((Object)("Failed to remove subscription for " + line.getAddress()));
                        }
                    }
                    this.fireEvent(line, 0);
                }
            }
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(OperationSetTelephonyBLF.Line line, int eventType) {
        ArrayList<BLFStatusListener> listeners;
        LineDetails details = (LineDetails)line.getData((Object)DATA_PROP);
        if (details == null) {
            details = new LineDetails();
            line.setData((Object)DATA_PROP, (Object)details);
        }
        details.lastStatusEvent = eventType;
        BLFStatusEvent evt = new BLFStatusEvent((Object)line, eventType);
        List<BLFStatusListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<BLFStatusListener>(this.listeners);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Dispatching BLF change. Listeners=" + listeners.size() + " evt=" + evt + " line=" + line.getAddress()));
        }
        for (BLFStatusListener listener : listeners) {
            listener.blfStatusChanged(evt);
        }
    }

    Document convertDocument(byte[] document) {
        try {
            return XMLUtils.createDocument((String)new String(document, "UTF-8"));
        }
        catch (Exception e) {
            logger.error((Object)"Can't convert the string into a xml document", (Throwable)e);
            return null;
        }
    }

    private String getTextContent(Element node) {
        String res = XMLUtils.getText((Element)node);
        if (res == null) {
            logger.warn((Object)("no text for element '" + node.getNodeName() + "'"));
            return "";
        }
        return res;
    }

    private class LineDetails {
        int lastStatusEvent = 0;
        String id = null;
        String direction;
        String callID = null;
        String localTag = null;
        String remoteTag = null;

        private LineDetails() {
        }
    }

    private class DialogInfoSubscriberSubscription
    extends EventPackageSubscriber.Subscription {
        private final OperationSetTelephonyBLF.Line line;

        public DialogInfoSubscriberSubscription(Address address, OperationSetTelephonyBLF.Line line) throws OperationFailedException {
            super(address);
            this.line = line;
        }

        @Override
        protected void processActiveRequest(RequestEvent requestEvent, byte[] rawContent) {
            NodeList dialogList;
            LineDetails details;
            if (rawContent == null) {
                return;
            }
            Document doc = OperationSetTelephonyBLFSipImpl.this.convertDocument(rawContent);
            if (doc == null) {
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("parsing:\n" + new String(rawContent)));
            }
            if ((details = (LineDetails)this.line.getData((Object)DATA_PROP)) == null) {
                details = new LineDetails();
                this.line.setData((Object)DATA_PROP, (Object)details);
            }
            if ((dialogList = doc.getElementsByTagNameNS(OperationSetTelephonyBLFSipImpl.ANY_NS, OperationSetTelephonyBLFSipImpl.EVENT_PACKAGE)).getLength() == 0) {
                this.updateLineState(details, "Terminated");
                return;
            }
            for (int i = 0; i < dialogList.getLength(); ++i) {
                Node dialogNode = dialogList.item(i);
                Element dialogElem = (Element)dialogNode;
                details.id = dialogElem.getAttribute("id");
                details.direction = dialogElem.getAttribute("direction");
                details.callID = dialogElem.getAttribute("call-id");
                details.localTag = dialogElem.getAttribute("local-tag");
                details.remoteTag = dialogElem.getAttribute("remote-tag");
                NodeList states = ((Element)dialogNode).getElementsByTagNameNS(OperationSetTelephonyBLFSipImpl.ANY_NS, "state");
                if (states.getLength() == 0) continue;
                this.updateLineState(details, OperationSetTelephonyBLFSipImpl.this.getTextContent((Element)states.item(0)));
            }
        }

        private void updateLineState(LineDetails details, String state) {
            int newEvent = 0;
            switch (details.lastStatusEvent) {
                case 0: {
                    if (state.equalsIgnoreCase("Trying") || state.equalsIgnoreCase("Proceeding") || state.equalsIgnoreCase("Early")) {
                        newEvent = 1;
                        break;
                    }
                    if (state.equalsIgnoreCase("Confirmed")) {
                        newEvent = 2;
                        break;
                    }
                    if (!state.equalsIgnoreCase("Terminated")) break;
                    newEvent = 3;
                    break;
                }
                case 3: {
                    if (state.equalsIgnoreCase("Trying") || state.equalsIgnoreCase("Proceeding") || state.equalsIgnoreCase("Early")) {
                        newEvent = 1;
                        break;
                    }
                    if (state.equalsIgnoreCase("Confirmed")) {
                        newEvent = 2;
                        break;
                    }
                    if (!state.equalsIgnoreCase("Terminated")) break;
                    return;
                }
                case 2: {
                    if (state.equalsIgnoreCase("Terminated")) {
                        newEvent = 3;
                        break;
                    }
                    return;
                }
                case 1: {
                    if (state.equalsIgnoreCase("Confirmed")) {
                        newEvent = 2;
                        break;
                    }
                    if (state.equalsIgnoreCase("Terminated")) {
                        newEvent = 3;
                        break;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            OperationSetTelephonyBLFSipImpl.this.fireEvent(this.line, newEvent);
        }

        @Override
        protected void processFailureResponse(ResponseEvent responseEvent, int statusCode) {
            OperationSetTelephonyBLFSipImpl.this.fireEvent(this.line, 0);
        }

        @Override
        protected void processSuccessResponse(ResponseEvent responseEvent, int statusCode) {
            switch (statusCode) {
                case 200: 
                case 202: {
                    OperationSetTelephonyBLFSipImpl.this.fireEvent(this.line, 3);
                }
            }
        }

        @Override
        protected void processTerminatedRequest(RequestEvent requestEvent, String reasonCode) {
            OperationSetTelephonyBLFSipImpl.this.fireEvent(this.line, 0);
        }
    }
}

