/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror;

import net.java.sip.communicator.impl.protocol.sip.xcap.model.ParsingException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.BaseXCapError;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.CannotDeleteType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.CannotInsertType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.ConstraintFailureType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.ExtensionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.NoParentType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.NotUtf8Type;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.NotWellFormedType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.NotXmlAttValueType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.SchemaValidationErrorType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.UniquenessFailureType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.XCapError;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcaperror.XCapErrorType;
import org.jitsi.util.StringUtils;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XCapErrorParser {
    private static final String NAMESPACE = "urn:ietf:params:xml:ns:xcap-error";
    private static final String XCAP_ERROR_ELEMENT = "xcap-error";
    private static final String CANNOT_DELETE_ELEMENT = "cannot-delete";
    private static final String CANNOT_INSERT_ELEMENT = "cannot-insert";
    private static final String CONSTRAINT_FAILURE_ELEMENT = "constraint-failure";
    private static final String EXTENSION_ELEMENT = "extension";
    private static final String NOPARENT_ELEMENT = "no-parent";
    private static final String NOPARENT_ANCESTOR_ELEMENT = "ancestor";
    private static final String NOT_UTF8_ELEMENT = "not-utf-8";
    private static final String NOT_WELL_FORMED_ELEMENT = "not-well-formed";
    private static final String NOT_XML_ATT_VALUE_ELEMENT = "not-xml-att-value";
    private static final String NOT_XMLF_FRAG_ELEMENT = "not-xml-frag";
    private static final String SCHEMA_VALIDATION_ERROR_ELEMENT = "schema-validation-error";
    private static final String UNIQUENESS_FAILURE_ELEMENT = "uniqueness-failure";
    private static final String UNIQUENESS_FAILURE_EXISTS_ELEMENT = "exists";
    private static final String UNIQUENESS_FAILURE_EXISTS_FIELD_ATTR = "field";
    private static final String UNIQUENESS_FAILURE_EXISTS_ALT_VALUE_ELEMENT = "alt-value";
    private static final String PHRASE_ATTR = "phrase";

    public static XCapErrorType fromXml(String xml) throws ParsingException {
        if (StringUtils.isNullOrEmpty((String)xml)) {
            throw new IllegalArgumentException("XML cannot be null or empty");
        }
        try {
            XCapErrorType error = new XCapErrorType();
            Document document = XMLUtils.createDocument((String)xml);
            Element xCapErrorElement = document.getDocumentElement();
            if (!NAMESPACE.equals(xCapErrorElement.getNamespaceURI()) || !XCAP_ERROR_ELEMENT.equals(xCapErrorElement.getLocalName())) {
                throw new Exception("Document doesn't contain xcap-error element");
            }
            NamedNodeMap attributes = xCapErrorElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
                if (namespaceUri != null && XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
                throw new Exception("xcap-error element is invalid");
            }
            NodeList childNodes = xCapErrorElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
                if (!NAMESPACE.equals(namespaceUri)) {
                    throw new Exception("xcap-error element is invalid");
                }
                error.setError(XCapErrorParser.errorFromElement(element));
            }
            return error;
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    private static XCapError errorFromElement(Element element) throws Exception {
        BaseXCapError error;
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("error-element element is invalid");
        }
        String localName = element.getLocalName();
        if (CANNOT_DELETE_ELEMENT.equals(localName)) {
            error = new CannotDeleteType(XCapErrorParser.getPhraseAttribute(element));
        } else if (CANNOT_INSERT_ELEMENT.equals(localName)) {
            error = new CannotInsertType(XCapErrorParser.getPhraseAttribute(element));
        } else if (CONSTRAINT_FAILURE_ELEMENT.equals(localName)) {
            error = new ConstraintFailureType(XCapErrorParser.getPhraseAttribute(element));
        } else if (EXTENSION_ELEMENT.equals(localName)) {
            error = XCapErrorParser.getExtensionFromElement(element);
        } else if (NOPARENT_ELEMENT.equals(localName)) {
            error = XCapErrorParser.getNoParentFromElement(element);
        } else if (NOT_UTF8_ELEMENT.equals(localName)) {
            error = new NotUtf8Type(XCapErrorParser.getPhraseAttribute(element));
        } else if (NOT_WELL_FORMED_ELEMENT.equals(localName)) {
            error = new NotWellFormedType(XCapErrorParser.getPhraseAttribute(element));
        } else if (NOT_XML_ATT_VALUE_ELEMENT.equals(localName)) {
            error = new NotXmlAttValueType(XCapErrorParser.getPhraseAttribute(element));
        } else if (NOT_XMLF_FRAG_ELEMENT.equals(localName)) {
            error = new NotXmlAttValueType(XCapErrorParser.getPhraseAttribute(element));
        } else if (SCHEMA_VALIDATION_ERROR_ELEMENT.equals(localName)) {
            error = new SchemaValidationErrorType(XCapErrorParser.getPhraseAttribute(element));
        } else if (UNIQUENESS_FAILURE_ELEMENT.equals(element.getLocalName())) {
            error = XCapErrorParser.getUniquenessFailureFromElement(element);
        } else {
            throw new Exception("content element is invalid");
        }
        return error;
    }

    private static String getPhraseAttribute(Element element) throws Exception {
        String result = null;
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("error element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("data element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !PHRASE_ATTR.equals(attribute.getLocalName()) || result != null) {
                throw new Exception("error element is invalid");
            }
            result = attribute.getValue();
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("error element is invalid");
        }
        return result;
    }

    private static ExtensionType getExtensionFromElement(Element element) throws Exception {
        ExtensionType result = new ExtensionType();
        if (!EXTENSION_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("extension element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri != null && XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("extension element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (namespaceUri == null) {
                throw new Exception("extension element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri)) {
                throw new Exception("extension element is invalid");
            }
            result.getAny().add(childElement);
        }
        return result;
    }

    private static NoParentType getNoParentFromElement(Element element) throws Exception {
        NoParentType result = new NoParentType();
        if (!NOPARENT_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("no-parent element is invalid");
        }
        String phrase = null;
        String ancestor = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("no-parent element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !PHRASE_ATTR.equals(attribute.getLocalName()) || phrase != null) {
                throw new Exception("no-parent element is invalid");
            }
            phrase = attribute.getValue();
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            String localName = childElement.getLocalName();
            if (namespaceUri == null) {
                throw new Exception("no-parent element is invalid");
            }
            if (!NAMESPACE.equals(namespaceUri) || !NOPARENT_ANCESTOR_ELEMENT.equals(localName) || ancestor != null) {
                throw new Exception("no-parent element is invalid");
            }
            ancestor = childElement.getTextContent();
        }
        result.setPhrase(phrase);
        result.setAncestor(ancestor);
        return result;
    }

    private static UniquenessFailureType getUniquenessFailureFromElement(Element element) throws Exception {
        UniquenessFailureType result = new UniquenessFailureType();
        if (!UNIQUENESS_FAILURE_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("uniqueness-failure element is invalid");
        }
        String phrase = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("uniqueness-failure element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !PHRASE_ATTR.equals(attribute.getLocalName()) || phrase != null) {
                throw new Exception("uniqueness-failure element is invalid");
            }
            phrase = attribute.getValue();
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            String localName = childElement.getLocalName();
            if (namespaceUri == null) {
                throw new Exception("uniqueness-failure element is invalid");
            }
            if (!NAMESPACE.equals(namespaceUri) || !UNIQUENESS_FAILURE_EXISTS_ELEMENT.equals(localName)) {
                throw new Exception("uniqueness-failure element is invalid");
            }
            result.getExists().add(XCapErrorParser.getExistsFromElement(childElement));
        }
        result.setPhrase(phrase);
        return result;
    }

    private static UniquenessFailureType.ExistsType getExistsFromElement(Element element) throws Exception {
        UniquenessFailureType.ExistsType result = new UniquenessFailureType.ExistsType();
        if (!UNIQUENESS_FAILURE_EXISTS_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("exists element is invalid");
        }
        String field = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("exists element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !UNIQUENESS_FAILURE_EXISTS_FIELD_ATTR.equals(attribute.getLocalName()) || field != null) {
                throw new Exception("exists element is invalid");
            }
            field = attribute.getValue();
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            String localName = childElement.getLocalName();
            if (namespaceUri == null) {
                throw new Exception("exists element is invalid");
            }
            if (!NAMESPACE.equals(namespaceUri) || !UNIQUENESS_FAILURE_EXISTS_ALT_VALUE_ELEMENT.equals(localName)) {
                throw new Exception("exists element is invalid");
            }
            result.getAltValue().add(childElement.getTextContent());
        }
        if (field == null) {
            throw new Exception("exists element is invalid");
        }
        result.setField(field);
        return result;
    }
}

