/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.Hashtable;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountInstallation
extends TestCase {
    public TestAccountInstallation(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInstallAccount() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=Jabber)";
        try {
            serRefs = JabberSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"Failed to find a provider factory service for protocol Jabber", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        ServiceReference confReference = JabberSlickFixture.bc.getServiceReference(ConfigurationService.class.getName());
        ConfigurationService configurationService = (ConfigurationService)JabberSlickFixture.bc.getService(confReference);
        configurationService.setProperty("net.java.sip.communicator.service.gui.ALWAYS_TRUST_MODE_ENABLED", (Object)Boolean.TRUE);
        ProtocolProviderFactory jabberProviderFactory = (ProtocolProviderFactory)JabberSlickFixture.bc.getService(serRefs[0]);
        TestAccountInstallation.assertTrue((String)"There was an account registered with the account mananger before we've installed any", (jabberProviderFactory.getRegisteredAccounts().size() == 0 ? 1 : 0) != 0);
        Hashtable<String, String> jabberAccount1Properties = this.getAccountProperties("accounts.jabber.account1.");
        Hashtable<String, String> jabberAccount2Properties = this.getAccountProperties("accounts.jabber.account2.");
        Hashtable<String, String> jabberAccount3Properties = this.getAccountProperties("accounts.jabber.account3.");
        try {
            jabberProviderFactory.installAccount(null, jabberAccount1Properties);
            TestAccountInstallation.fail((String)"installing an account with a null account id must result in a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        jabberProviderFactory.installAccount(jabberAccount1Properties.get("USER_ID"), jabberAccount1Properties);
        jabberProviderFactory.installAccount(jabberAccount2Properties.get("USER_ID"), jabberAccount2Properties);
        jabberProviderFactory.installAccount(jabberAccount3Properties.get("USER_ID"), jabberAccount3Properties);
        try {
            jabberProviderFactory.installAccount(jabberAccount1Properties.get("USER_ID"), jabberAccount1Properties);
            TestAccountInstallation.fail((String)"An IllegalStateException must be thrown when trying to install a duplicate account");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestAccountInstallation.assertTrue((String)"The newly installed account was not in the acc man's registered accounts!", (jabberProviderFactory.getRegisteredAccounts().size() == 3 ? 1 : 0) != 0);
        osgiFilter = "(&(PROTOCOL_NAME=Jabber)(USER_ID=" + jabberAccount1Properties.get("USER_ID") + "))";
        try {
            serRefs = JabberSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestAccountInstallation.fail((String)(osgiFilter + "is not a valid osgi filter"));
        }
        TestAccountInstallation.assertTrue((String)"An protocol provider was apparently not installed as requested.", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        Object jabberProtocolProvider = JabberSlickFixture.bc.getService(serRefs[0]);
        TestAccountInstallation.assertTrue((String)"The installed protocol provider does not implement the protocol provider service.", (boolean)(jabberProtocolProvider instanceof ProtocolProviderService));
    }

    private Hashtable<String, String> getAccountProperties(String accountPrefix) {
        String serverPort;
        Hashtable<String, String> table = new Hashtable<String, String>();
        String userID = System.getProperty(accountPrefix + "USER_ID", null);
        TestAccountInstallation.assertNotNull((String)("The system property named " + accountPrefix + "USER_ID" + " has to tontain a valid Jabber address that could be used during SIP Communicator's tests."), (Object)userID);
        table.put("USER_ID", userID);
        String passwd = System.getProperty(accountPrefix + "PASSWORD", null);
        TestAccountInstallation.assertNotNull((String)("The system property named " + accountPrefix + "PASSWORD" + " has to contain the password corresponding to the account specified in " + accountPrefix + "USER_ID"), (Object)passwd);
        table.put("PASSWORD", passwd);
        String serverAddress = System.getProperty(accountPrefix + "SERVER_ADDRESS", null);
        if (serverAddress != null) {
            table.put("SERVER_ADDRESS", serverAddress);
        }
        if ((serverPort = System.getProperty(accountPrefix + "SERVER_PORT", null)) != null) {
            table.put("SERVER_PORT", serverPort);
        }
        return table;
    }
}

