/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.slick.protocol.generic.SecurityAuthorityImpl;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestProtocolProviderServiceJabberImpl
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestProtocolProviderServiceJabberImpl.class);
    private JabberSlickFixture fixture = new JabberSlickFixture();
    public RegistrationEventCollector regEvtCollector1 = new RegistrationEventCollector();
    public RegistrationEventCollector regEvtCollector2 = new RegistrationEventCollector();
    public RegistrationEventCollector regEvtCollector3 = new RegistrationEventCollector();

    public TestProtocolProviderServiceJabberImpl(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public void testRegister() throws OperationFailedException {
        this.fixture.provider1.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector1);
        this.fixture.provider2.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector2);
        this.fixture.provider3.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector3);
        this.fixture.provider1.register((SecurityAuthority)new SecurityAuthorityImpl(System.getProperty("accounts.jabber.account1.PASSWORD").toCharArray()));
        this.fixture.provider2.register((SecurityAuthority)new SecurityAuthorityImpl(System.getProperty("accounts.jabber.account2.PASSWORD").toCharArray()));
        this.fixture.provider3.register((SecurityAuthority)new SecurityAuthorityImpl(System.getProperty("accounts.jabber.account3.PASSWORD").toCharArray()));
        logger.debug((Object)"Waiting for registration to complete ...");
        this.regEvtCollector1.waitForEvent(15000L);
        this.regEvtCollector2.waitForEvent(40000L);
        this.regEvtCollector3.waitForEvent(60000L);
        TestProtocolProviderServiceJabberImpl.assertTrue((String)"No events were dispatched during the registration process.", (this.regEvtCollector1.collectedNewStates.size() > 0 ? 1 : 0) != 0);
        TestProtocolProviderServiceJabberImpl.assertTrue((String)("No registration event notifying of registration was dispatched. All events were: " + this.regEvtCollector1.collectedNewStates), (boolean)this.regEvtCollector1.collectedNewStates.contains(RegistrationState.REGISTERED));
        TestProtocolProviderServiceJabberImpl.assertTrue((String)"No events were dispatched during the registration process of provider2.", (this.regEvtCollector2.collectedNewStates.size() > 0 ? 1 : 0) != 0);
        TestProtocolProviderServiceJabberImpl.assertTrue((String)("No registration event notifying of registration was dispatched. All events were: " + this.regEvtCollector2.collectedNewStates), (boolean)this.regEvtCollector2.collectedNewStates.contains(RegistrationState.REGISTERED));
        TestProtocolProviderServiceJabberImpl.assertTrue((String)"No events were dispatched during the registration process of provider3.", (this.regEvtCollector3.collectedNewStates.size() > 0 ? 1 : 0) != 0);
        TestProtocolProviderServiceJabberImpl.assertTrue((String)("No registration event notifying of registration was dispatched. All events were: " + this.regEvtCollector3.collectedNewStates), (boolean)this.regEvtCollector3.collectedNewStates.contains(RegistrationState.REGISTERED));
        this.fixture.provider1.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector1);
        this.fixture.provider2.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector2);
        this.fixture.provider3.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector3);
    }

    public void testOperationSetTypes() throws Exception {
        Map supportedOperationSets = this.fixture.provider1.getSupportedOperationSets();
        for (Map.Entry entry : supportedOperationSets.entrySet()) {
            String setName = (String)entry.getKey();
            Object opSet = entry.getValue();
            TestProtocolProviderServiceJabberImpl.assertTrue((String)(opSet + " was not an instance of " + setName + " as declared"), (boolean)Class.forName(setName).isInstance(opSet));
        }
    }

    public class RegistrationEventCollector
    implements RegistrationStateChangeListener {
        public List<RegistrationState> collectedNewStates = new LinkedList<RegistrationState>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            logger.debug((Object)("Received a RegistrationStateChangeEvent: " + evt));
            this.collectedNewStates.add(evt.getNewState());
            if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                logger.debug((Object)"We're registered and will notify those who wait");
                RegistrationEventCollector registrationEventCollector = this;
                synchronized (registrationEventCollector) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a RegistrationStateChangeEvent ");
            RegistrationEventCollector registrationEventCollector = this;
            synchronized (registrationEventCollector) {
                if (this.collectedNewStates.contains(RegistrationState.REGISTERED)) {
                    logger.trace((Object)("Event already received. " + this.collectedNewStates));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedNewStates.size() > 0) {
                        logger.trace((Object)"Received a RegistrationStateChangeEvent.");
                    } else {
                        logger.trace((Object)("No RegistrationStateChangeEvent received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a RegistrationStateChangeEvent", (Throwable)ex);
                }
            }
        }
    }
}

