/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.keybindingchooser.KeybindingChooserActivator;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingChooser;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingEntry;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.GlobalShortcutConfigForm;
import net.java.sip.communicator.service.keybindings.KeybindingSet;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class KeybindingsConfigPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final HashMap<KeybindingSet, SIPChooser> choosers = new HashMap();

    private static KeybindingsService getKeybindingsService() {
        BundleContext bundleContext = KeybindingChooserActivator.getBundleContext();
        ServiceReference keybindingRef = bundleContext.getServiceReference(KeybindingsService.class.getName());
        return (KeybindingsService)bundleContext.getService(keybindingRef);
    }

    public KeybindingsConfigPanel() {
        super((LayoutManager)new BorderLayout());
        KeybindingsService service = KeybindingsConfigPanel.getKeybindingsService();
        this.setFocusable(true);
        SIPCommTabbedPane chooserPanes = new SIPCommTabbedPane();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                for (SIPChooser chooser : KeybindingsConfigPanel.this.choosers.values()) {
                    chooser.setSelected(null);
                }
            }
        });
        GlobalShortcutConfigForm globalBindingPanel = new GlobalShortcutConfigForm();
        chooserPanes.addTab(KeybindingChooserActivator.getResources().getI18NString("plugin.keybindings.GLOBAL"), (Component)((Object)globalBindingPanel));
        for (KeybindingSet.Category category : KeybindingSet.Category.values()) {
            KeybindingSet bindingSet = service.getBindings(category);
            if (bindingSet == null) continue;
            SIPChooser newChooser = new SIPChooser();
            newChooser.putAllBindings(bindingSet);
            TransparentPanel chooserWrapper = new TransparentPanel((LayoutManager)new BorderLayout());
            chooserWrapper.add((Component)((Object)newChooser), "North");
            JScrollPane scroller = new JScrollPane((Component)chooserWrapper);
            this.addKeyListener(newChooser.makeAdaptor());
            chooserPanes.addTab(KeybindingChooserActivator.getResources().getI18NString("plugin.keybindings." + category.toString()), scroller);
            this.choosers.put(bindingSet, newChooser);
        }
        this.add((Component)chooserPanes);
    }

    private class SIPChooser
    extends BindingChooser {
        private static final long serialVersionUID = 0L;
        private HashMap<String, String> actionLabels = new HashMap();

        private SIPChooser() {
        }

        @Override
        protected void onClick(MouseEvent event, BindingEntry entry, BindingEntry.Field field) {
            super.onClick(event, entry, field);
            KeybindingsConfigPanel.this.requestFocus();
        }

        @Override
        public boolean putBinding(BindingEntry newEntry, int index) {
            String actionInternal = newEntry.getAction();
            String actionLabel = this.getI18NString(actionInternal);
            this.actionLabels.put(actionLabel, actionInternal);
            newEntry.setAction(actionLabel);
            newEntry.removeAll();
            newEntry.setLayout(new BorderLayout());
            TransparentPanel left = new TransparentPanel((LayoutManager)new FlowLayout(0, 0, 0));
            left.add(newEntry.getField(BindingEntry.Field.INDENT));
            left.add(newEntry.getField(BindingEntry.Field.ACTION));
            newEntry.add((Component)left, "West");
            newEntry.add(newEntry.getField(BindingEntry.Field.SHORTCUT));
            return super.putBinding(newEntry, index);
        }

        private String getI18NString(String key) {
            StringBuilder newKey = new StringBuilder();
            newKey.append("plugin.keybindings.");
            for (char keyChar : key.toCharArray()) {
                if (Character.isLowerCase(keyChar)) {
                    newKey.append(Character.toUpperCase(keyChar));
                    continue;
                }
                if (Character.isUpperCase(keyChar)) {
                    newKey.append('_');
                    newKey.append(keyChar);
                    continue;
                }
                newKey.append('_');
            }
            return KeybindingChooserActivator.getResources().getI18NString(newKey.toString());
        }

        @Override
        public LinkedHashMap<KeyStroke, String> getBindingMap() {
            LinkedHashMap<KeyStroke, String> bindings = new LinkedHashMap<KeyStroke, String>();
            for (BindingEntry entry : super.getBindings()) {
                bindings.put(entry.getShortcut(), this.actionLabels.get(entry.getAction()));
            }
            return bindings;
        }
    }
}

