/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.directimage;

import java.net.HttpURLConnection;
import java.net.URL;
import net.java.sip.communicator.impl.replacement.directimage.DirectImageActivator;
import net.java.sip.communicator.service.replacement.directimage.DirectImageReplacementService;
import net.java.sip.communicator.util.FTPUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;

public class ReplacementServiceDirectImageImpl
implements DirectImageReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceDirectImageImpl.class);
    public static final String URL_PATTERN = "https?\\:\\/\\/.*\\.(?:jpg|png|gif)";
    public static final String DIRECT_IMAGE_CONFIG_LABEL = "Direct Image Link";
    public static final String SOURCE_NAME = "DIRECTIMAGE";
    private long imgMaxSize = 0x200000L;
    private static final String MAX_IMG_SIZE = "net.java.sip.communicator.impl.replacement.directimage.MAX_IMG_SIZE";

    public ReplacementServiceDirectImageImpl() {
        this.setMaxImgSizeFromConf();
        logger.trace((Object)"Creating a Direct Image Link Source.");
    }

    private void setMaxImgSizeFromConf() {
        block5: {
            ConfigurationService configService = DirectImageActivator.getConfigService();
            if (configService != null) {
                String confImgSizeStr = (String)configService.getProperty(MAX_IMG_SIZE);
                try {
                    if (confImgSizeStr != null) {
                        this.imgMaxSize = Long.parseLong(confImgSizeStr);
                    } else {
                        configService.setProperty(MAX_IMG_SIZE, (Object)this.imgMaxSize);
                    }
                }
                catch (NumberFormatException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)("Failed to parse max image size: " + confImgSizeStr + ". Going for default."));
                }
            }
        }
    }

    public String getReplacement(String sourceString) {
        return sourceString;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return URL_PATTERN;
    }

    public int getImageSize(String sourceString) {
        int length = -1;
        try {
            URL url = new URL(sourceString);
            String protocol = url.getProtocol();
            if (protocol.equals("http") || protocol.equals("https")) {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                length = connection.getContentLength();
                connection.disconnect();
            } else if (protocol.equals("ftp")) {
                FTPUtils ftp = new FTPUtils(sourceString);
                length = ftp.getSize();
                ftp.disconnect();
            }
            if ((long)length > this.imgMaxSize) {
                length = -1;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to get the length of the image in bytes", (Throwable)e);
        }
        return length;
    }

    public boolean isDirectImage(String sourceString) {
        boolean isDirectImage = false;
        try {
            URL url = new URL(sourceString);
            String protocol = url.getProtocol();
            if (protocol.equals("http") || protocol.equals("https")) {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                isDirectImage = connection.getContentType().contains("image");
                connection.disconnect();
            } else if (protocol.equals("ftp") && (sourceString.endsWith(".png") || sourceString.endsWith(".jpg") || sourceString.endsWith(".gif"))) {
                isDirectImage = true;
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Failed to retrieve content type information for" + sourceString), (Throwable)e);
        }
        return isDirectImage;
    }
}

