/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.dnsconfig;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import net.java.sip.communicator.impl.dns.SecureResolveMode;
import net.java.sip.communicator.plugin.dnsconfig.DnsConfigActivator;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class DnssecTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 0L;
    private List<String> data = new LinkedList<String>();
    private ResourceManagementService R;
    private ConfigurationService config;

    public DnssecTableModel() {
        BundleContext bc = DnsConfigActivator.bundleContext;
        this.R = (ResourceManagementService)ServiceUtils.getService((BundleContext)bc, ResourceManagementService.class);
        this.config = (ConfigurationService)ServiceUtils.getService((BundleContext)bc, ConfigurationService.class);
        this.data = this.config.getPropertyNamesByPrefix("net.java.sip.communicator.util.dns.pin", false);
        Collections.sort(this.data);
        if (this.data == null) {
            this.data = new ArrayList<String>(0);
        }
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.R.getI18NString("plugin.dnsconfig.dnssec.DOMAIN_NAME");
            }
            case 1: {
                return this.R.getI18NString("plugin.dnsconfig.dnssec.MODE");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 1) {
            return String.class;
        }
        return Component.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).substring("net.java.sip.communicator.util.dns.pin".length() + 1).split("\\.")[0].replaceAll("__", ".");
            }
            case 1: {
                return SecureResolveMode.valueOf((String)this.config.getString(this.data.get(rowIndex)));
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        this.config.setProperty(this.data.get(rowIndex), (Object)((SecureResolveMode)aValue).name());
    }
}

