/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.icq.AbstractContactGroupIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ContactIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ServerStoredContactListIcqImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableGroup;

public class ContactGroupIcqImpl
extends AbstractContactGroupIcqImpl {
    private final Map<String, Contact> buddies = new Hashtable<String, Contact>();
    private boolean isResolved = false;
    private MutableGroup joustSimSourceGroup = null;
    private LinkedHashSet<ContactGroup> dummyGroupsList = new LinkedHashSet();
    private String nameCopy = null;
    private ServerStoredContactListIcqImpl ssclCallback = null;
    private boolean isPersistent;

    ContactGroupIcqImpl(MutableGroup joustSimGroup, Iterable<? extends Buddy> groupMembers, ServerStoredContactListIcqImpl ssclCallback, boolean isResolved, boolean isPersistent) {
        this.joustSimSourceGroup = joustSimGroup;
        this.isResolved = isResolved;
        this.isPersistent = isPersistent;
        this.ssclCallback = ssclCallback;
        this.initNameCopy();
        if (groupMembers != null) {
            for (Buddy buddy : groupMembers) {
                if (ssclCallback.findContactByJoustSimBuddy(buddy) != null) continue;
                this.addContact(new ContactIcqImpl(buddy, ssclCallback, true, true));
            }
        }
    }

    public int countContacts() {
        return this.buddies.size();
    }

    public ContactGroup getParentContactGroup() {
        return this.ssclCallback.getRootGroup();
    }

    void addContact(ContactIcqImpl contact) {
        this.buddies.put(contact.getUIN().toLowerCase(), (Contact)contact);
    }

    void removeContact(ContactIcqImpl contact) {
        if (contact == null) {
            return;
        }
        this.buddies.remove(contact.getUIN().toLowerCase());
    }

    public Iterator<Contact> contacts() {
        return this.buddies.values().iterator();
    }

    public Contact getContact(String id) {
        return this.findContact(id);
    }

    public String getGroupName() {
        return this.joustSimSourceGroup.getName();
    }

    public boolean canContainSubgroups() {
        return false;
    }

    public ContactGroup getGroup(int index) {
        return null;
    }

    public ContactGroup getGroup(String groupName) {
        return null;
    }

    public Iterator<ContactGroup> subgroups() {
        return this.dummyGroupsList.iterator();
    }

    public int countSubgroups() {
        return 0;
    }

    public int hashCode() {
        return this.getGroupName().hashCode();
    }

    MutableGroup getJoustSimSourceGroup() {
        return this.joustSimSourceGroup;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ContactGroupIcqImpl)) {
            return false;
        }
        if (!((ContactGroup)obj).getGroupName().equals(this.getGroupName())) {
            return false;
        }
        return this.getProtocolProvider() == ((ContactGroup)obj).getProtocolProvider();
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.ssclCallback.getParentProvider();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("IcqGroup.");
        buff.append(this.getGroupName());
        buff.append(", childContacts=" + this.countContacts() + ":[");
        Iterator<Contact> contacts = this.contacts();
        while (contacts.hasNext()) {
            Contact contact = contacts.next();
            buff.append(contact.toString());
            if (!contacts.hasNext()) continue;
            buff.append(", ");
        }
        return buff.append("]").toString();
    }

    ContactIcqImpl findContact(Buddy joustSimBuddy) {
        Iterator<Contact> contacts = this.contacts();
        while (contacts.hasNext()) {
            ContactIcqImpl item = (ContactIcqImpl)contacts.next();
            if (item.getJoustSimBuddy() != joustSimBuddy) continue;
            return item;
        }
        return null;
    }

    int findContactIndex(Contact contact) {
        Iterator<Contact> contacts = this.contacts();
        int i = 0;
        while (contacts.hasNext()) {
            ContactIcqImpl item = (ContactIcqImpl)contacts.next();
            if (item == contact) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    ContactIcqImpl findContact(String screenName) {
        if (screenName == null) {
            return null;
        }
        String lcScreenName = screenName.toLowerCase();
        return (ContactIcqImpl)this.buddies.get(lcScreenName);
    }

    void initNameCopy() {
        this.nameCopy = this.getGroupName();
    }

    String getNameCopy() {
        return this.nameCopy;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    void setResolved(boolean resolved) {
        this.isResolved = resolved;
        this.isPersistent = true;
    }

    void updateGroup(MutableGroup joustSimGroup, List<? extends Buddy> serverBuddies, List<Contact> newContacts, List<ContactIcqImpl> removedContacts) {
        this.setResolved(true);
        this.joustSimSourceGroup = joustSimGroup;
        for (Buddy buddy : serverBuddies) {
            ContactIcqImpl contact = this.findContact(buddy.getScreenname().getFormatted());
            if (contact == null) {
                contact = new ContactIcqImpl(buddy, this.ssclCallback, true, true);
                newContacts.add((Contact)contact);
                this.addContact(contact);
                continue;
            }
            contact.setJoustSimBuddy(buddy);
            contact.setResolved(true);
        }
    }

    public String getUID() {
        return this.getGroupName();
    }
}

