/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;

public class SecuridResponse
extends AuthCommand {
    private final String securid;

    protected SecuridResponse(SnacPacket packet) {
        super(11);
        ByteBlock data = packet.getData();
        int len = BinaryTools.getUShort(data, 0);
        this.securid = BinaryTools.getAsciiString(data.subBlock(2, len));
    }

    public SecuridResponse(String securid) {
        super(11);
        DefensiveTools.checkNull(securid, "securid");
        this.securid = securid;
    }

    public void writeData(OutputStream out) throws IOException {
        DefensiveTools.checkNull(this.securid, "securid");
        BinaryTools.writeUShort(out, this.securid.length());
        out.write(BinaryTools.getAsciiBytes(this.securid));
    }

    public String getSecurid() {
        return this.securid;
    }
}

