/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractTransferrer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ReceiveFileController;

class FileReceiver
extends AbstractTransferrer {
    private ReceiveFileController controller;
    private final FileChannel fileChannel;

    public FileReceiver(ReceiveFileController controller, FileChannel fileChannel, long offset, long toDownload) {
        super(controller.getStream(), offset, toDownload);
        this.controller = controller;
        this.fileChannel = fileChannel;
    }

    protected boolean isCancelled() {
        return this.controller.shouldStop();
    }

    protected boolean waitIfPaused() {
        return this.controller.waitUntilUnpause();
    }

    protected long transferChunk(ReadableByteChannel readable, WritableByteChannel writable, long transferred, long remaining) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate((int)Math.min(1024L, remaining));
        int res = readable.read(buff);
        if (res == -1 || res == 0) {
            return res;
        }
        buff.rewind();
        this.fileChannel.write(buff, this.offset + transferred);
        return res;
    }

    protected int getSelectionKey() {
        return 1;
    }
}

