/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.info;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.snaccmd.InfoData;
import net.kano.joscar.snaccmd.loc.GetInfoCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.info.InfoResponseListener;
import net.kano.joustsim.oscar.oscar.service.info.MutableInfoService;
import net.kano.joustsim.oscar.oscar.service.info.UserInfoRequestManager;
import net.kano.joustsim.trust.BuddyCertificateInfo;
import net.kano.joustsim.trust.TrustTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateInfoRequestManager
extends UserInfoRequestManager<CertificateInfo> {
    private static final Logger LOGGER = Logger.getLogger(CertificateInfoRequestManager.class.getName());

    public CertificateInfoRequestManager(MutableInfoService service) {
        super(service);
    }

    @Override
    protected SnacCommand generateSnacCommand(Screenname sn) {
        LOGGER.fine("generating cert request for " + sn);
        return new GetInfoCmd(8L, sn.getFormatted());
    }

    @Override
    protected void callListener(InfoResponseListener listener, Screenname sn, CertificateInfo certInfo) {
        BuddyCertificateInfo bci = this.extractBuddyCertificateInfo(sn, certInfo);
        listener.handleCertificateInfo(this.getService(), sn, bci);
    }

    private BuddyCertificateInfo extractBuddyCertificateInfo(Screenname sn, CertificateInfo certInfo) {
        X509Certificate encryption;
        X509Certificate signing;
        ByteBlock encryptionData;
        ByteBlock signingData;
        if (certInfo == null) {
            return null;
        }
        if (certInfo.isCommon()) {
            signingData = certInfo.getCommonCertData();
            encryptionData = certInfo.getCommonCertData();
        } else {
            signingData = certInfo.getSignCertData();
            encryptionData = certInfo.getEncCertData();
        }
        if (signingData == null || encryptionData == null) {
            this.fireInvalidCertsException(sn, null, certInfo);
            return null;
        }
        try {
            signing = TrustTools.decodeCertificate(signingData);
            encryption = TrustTools.decodeCertificate(encryptionData);
        }
        catch (Exception e) {
            this.fireInvalidCertsException(sn, e, certInfo);
            return null;
        }
        return new BuddyCertificateInfo(sn, ByteBlock.wrap(CertificateInfo.getCertInfoHash(certInfo)), encryption, signing);
    }

    private void fireInvalidCertsException(Screenname sn, Exception e, CertificateInfo origCertInfo) {
        Iterator<InfoResponseListener> i$ = this.getListeners(sn).iterator();
        while (i$.hasNext()) {
            InfoResponseListener o;
            InfoResponseListener listener = o = i$.next();
            listener.handleInvalidCertificates(this.getService(), sn, origCertInfo, e);
        }
    }

    @Override
    protected CertificateInfo getDesiredValue(InfoData infodata) {
        return infodata.getCertificateInfo();
    }
}

