/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.httputil;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpInetSocketAddress;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class SSLSocketFactoryEx
extends SSLSocketFactory {
    private SSLContext context;

    public SSLSocketFactoryEx(SSLContext context) throws UnrecoverableKeyException, KeyStoreException, KeyManagementException, NoSuchAlgorithmException {
        super((KeyStore)null);
        this.context = context;
    }

    public Socket createSocket(HttpParams params) throws IOException {
        return this.context.getSocketFactory().createSocket();
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException, UnknownHostException {
        return this.context.getSocketFactory().createSocket(socket, host, port, true);
    }

    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslsock;
        Socket sock;
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Remote address may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Socket socket2 = sock = socket != null ? socket : this.context.getSocketFactory().createSocket();
        if (localAddress != null) {
            sock.setReuseAddress(HttpConnectionParams.getSoReuseaddr((HttpParams)params));
            sock.bind(localAddress);
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
        try {
            sock.setSoTimeout(soTimeout);
            sock.connect(remoteAddress, connTimeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        String hostname = remoteAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)remoteAddress).getHttpHost().getHostName() : remoteAddress.getHostName();
        if (sock instanceof SSLSocket) {
            sslsock = (SSLSocket)sock;
        } else {
            int port = remoteAddress.getPort();
            sslsock = (SSLSocket)this.context.getSocketFactory().createSocket(sock, hostname, port, true);
        }
        return sslsock;
    }
}

