/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.ControlChar;
import net.java.sip.communicator.impl.protocol.irc.FormattedTextBuilder;

public class FormattedTextBuilderTest
extends TestCase {
    public void testConstructFormattedTextBuilder() {
        new FormattedTextBuilder();
    }

    public void testFormatNothing() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        Assert.assertEquals((String)"", (String)formatted.done());
    }

    public void testPlainText() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        formatted.append("Hello world!");
        Assert.assertEquals((String)"Hello world!", (String)formatted.done());
    }

    public void testPlainChar() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        formatted.append('H');
        formatted.append('e');
        formatted.append('l');
        formatted.append('l');
        formatted.append('o');
        Assert.assertEquals((String)"Hello", (String)formatted.done());
    }

    public void testDoneWithoutFormatting() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        formatted.append("Hello world!");
        Assert.assertEquals((String)"Hello world!", (String)formatted.done());
    }

    public void testDoneRepeatedly() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        formatted.append("Hello world!");
        formatted.done();
        formatted.done();
        Assert.assertEquals((String)"Hello world!", (String)formatted.done());
    }

    public void testOnlyFormatting() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        formatted.apply(new ControlChar.Bold());
        Assert.assertEquals((String)"<b></b>", (String)formatted.done());
    }

    public void testMixedFormattingContent() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        formatted.apply(new ControlChar.Bold());
        formatted.append("Hello ");
        formatted.apply(new ControlChar.Italics());
        formatted.append("world");
        formatted.cancel(ControlChar.Bold.class, true);
        formatted.append("!!!");
        Assert.assertEquals((String)"<b>Hello <i>world</i></b><i>!!!</i>", (String)formatted.done());
    }

    public void testToStringIntermediateResult() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        formatted.apply(new ControlChar.Bold());
        formatted.append("Hello ");
        formatted.apply(new ControlChar.Italics());
        Assert.assertEquals((String)"<b>Hello <i>", (String)formatted.toString());
        formatted.append("world");
        formatted.cancel(ControlChar.Bold.class, true);
        formatted.append("!!!");
        Assert.assertEquals((String)"<b>Hello <i>world</i></b><i>!!!", (String)formatted.toString());
        Assert.assertEquals((String)"<b>Hello <i>world</i></b><i>!!!</i>", (String)formatted.done());
        Assert.assertEquals((String)"<b>Hello <i>world</i></b><i>!!!</i>", (String)formatted.toString());
    }

    public void testActiveFormatting() {
        FormattedTextBuilder formatted = new FormattedTextBuilder();
        Assert.assertFalse((boolean)formatted.isActive(ControlChar.Bold.class));
        formatted.apply(new ControlChar.Bold());
        Assert.assertTrue((boolean)formatted.isActive(ControlChar.Bold.class));
        formatted.append("Hello ");
        Assert.assertFalse((boolean)formatted.isActive(ControlChar.Italics.class));
        formatted.apply(new ControlChar.Italics());
        Assert.assertTrue((boolean)formatted.isActive(ControlChar.Italics.class));
        formatted.done();
        Assert.assertFalse((boolean)formatted.isActive(ControlChar.Bold.class));
        Assert.assertFalse((boolean)formatted.isActive(ControlChar.Italics.class));
    }
}

