/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.ISupport;

public class ISupportTest
extends TestCase {
    public void testParseNullDestination() {
        try {
            ISupport.parseChanLimit(null, "");
            Assert.fail((String)"Should not reach this, since it should fail on null destination.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseNullValue() {
        HashMap<Character, Integer> dest = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(dest, null);
        Assert.assertEquals((int)0, (int)dest.size());
    }

    public void testParseEmptyValue() {
        HashMap<Character, Integer> destination = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(destination, "");
        Assert.assertEquals((int)0, (int)destination.size());
    }

    public void testParseSingleSimpleValidValue() {
        HashMap<Character, Integer> destination = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(destination, "#:10");
        Assert.assertEquals((int)1, (int)destination.size());
        Assert.assertEquals((int)10, (int)((Integer)destination.get(Character.valueOf('#'))));
    }

    public void testParseSingleCombinedValidValue() {
        HashMap<Character, Integer> destination = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(destination, "#&+:25");
        Assert.assertEquals((int)3, (int)destination.size());
        Assert.assertEquals((int)25, (int)((Integer)destination.get(Character.valueOf('#'))));
        Assert.assertEquals((int)25, (int)((Integer)destination.get(Character.valueOf('&'))));
        Assert.assertEquals((int)25, (int)((Integer)destination.get(Character.valueOf('+'))));
    }

    public void testParseMultipleSimpleValidValues() {
        HashMap<Character, Integer> destination = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(destination, "#:10,&:20,+:30");
        Assert.assertEquals((int)3, (int)destination.size());
        Assert.assertEquals((int)10, (int)((Integer)destination.get(Character.valueOf('#'))));
        Assert.assertEquals((int)20, (int)((Integer)destination.get(Character.valueOf('&'))));
        Assert.assertEquals((int)30, (int)((Integer)destination.get(Character.valueOf('+'))));
    }

    public void testParseMultipleSimpleValidValuesWithInvalidStuff() {
        HashMap<Character, Integer> destination = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(destination, "#:10,^:20,jadie:abc,+:30,#:abc");
        Assert.assertEquals((int)2, (int)destination.size());
        Assert.assertEquals((int)10, (int)((Integer)destination.get(Character.valueOf('#'))));
        Assert.assertEquals((int)30, (int)((Integer)destination.get(Character.valueOf('+'))));
    }

    public void testParseMultipleCombinedValidValues() {
        HashMap<Character, Integer> destination = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(destination, "#&:100,+:30");
        Assert.assertEquals((int)3, (int)destination.size());
        Assert.assertEquals((int)100, (int)((Integer)destination.get(Character.valueOf('#'))));
        Assert.assertEquals((int)100, (int)((Integer)destination.get(Character.valueOf('&'))));
        Assert.assertEquals((int)30, (int)((Integer)destination.get(Character.valueOf('+'))));
    }

    public void testParseSimpleInvalidValue() {
        HashMap<Character, Integer> destination = new HashMap<Character, Integer>();
        ISupport.parseChanLimit(destination, "bla");
        Assert.assertEquals((int)0, (int)destination.size());
    }
}

