/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.ISupport;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.util.Logger;

public class IdentityManager {
    private static final Logger LOGGER = Logger.getLogger(IdentityManager.class);
    public static final Pattern NICK_PATTERN = Pattern.compile("[A-Za-z\\[\\]\\\\`\\^\\{\\}_\\|][A-Za-z0-9\\-\\[\\]\\\\`\\^\\{\\}_\\|]*");
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final ProtocolProviderServiceIrcImpl provider;
    private final Identity identity = new Identity();
    private final Integer isupportNickLen;

    public IdentityManager(IRCApi irc, IIRCState connectionState, ProtocolProviderServiceIrcImpl provider) {
        if (irc == null) {
            throw new IllegalArgumentException("irc instance cannot be null");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState instance cannot be null");
        }
        this.connectionState = connectionState;
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = provider;
        this.irc.addListener((IMessageListener)new IdentityListener());
        IdentityManager.queryIdentity(this.irc, this.connectionState, new WhoisListener());
        this.isupportNickLen = IdentityManager.parseISupportNickLen(this.connectionState);
    }

    private static void queryIdentity(final IRCApi irc, final IIRCState state, final WhoisListener listener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    irc.addListener((IMessageListener)listener);
                    irc.rawMessage("WHOIS " + state.getNickname());
                }
                catch (RuntimeException e) {
                    LOGGER.error((Object)"Failed to deliver WHOIS message.", (Throwable)e);
                }
            }
        }.start();
    }

    private static Integer parseISupportNickLen(IIRCState state) {
        String value = state.getServerOptions().getKey(ISupport.NICKLEN.name());
        if (value == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Setting ISUPPORT parameter " + ISupport.NICKLEN.name() + " to " + value));
        }
        return new Integer(value);
    }

    public String getNick() {
        return this.connectionState.getNickname();
    }

    public void setNick(String nick) {
        this.irc.changeNick(IdentityManager.checkNick(nick, this.isupportNickLen));
    }

    public static String checkNick(String nick, Integer isupportNickLen) {
        if (nick == null || nick.isEmpty()) {
            throw new IllegalArgumentException("a nick name must be provided");
        }
        if (!NICK_PATTERN.matcher(nick).matches()) {
            throw new IllegalArgumentException("nick name contains invalid characters: only letters, digits and -, \\, [, ], `, ^, {, }, |, _ are allowed");
        }
        if (isupportNickLen != null && nick.length() > isupportNickLen) {
            throw new IllegalArgumentException("the nick name must not be longer than " + isupportNickLen + " characters according to server parameters.");
        }
        return nick;
    }

    public String getIdentityString() {
        String currentNick = this.connectionState.getNickname();
        return this.identity.getString(currentNick);
    }

    private static final class Identity {
        private String user = null;
        private String host = null;

        private Identity() {
        }

        private void setUser(String user) {
            this.user = user;
        }

        private void setHost(String host) {
            this.host = host;
        }

        private boolean isSet() {
            return this.user != null && this.host != null;
        }

        private String getString(String currentNick) {
            return String.format("%s!%s@%s", currentNick, this.user, this.host);
        }
    }

    private final class IdentityListener
    extends AbstractIrcMessageListener {
        public IdentityListener() {
            super(IdentityManager.this.irc, IdentityManager.this.connectionState);
        }

        public void onNickChange(NickMessage msg) {
            if (msg == null || msg.getSource() == null) {
                return;
            }
            String oldNick = msg.getSource().getNick();
            String newNick = msg.getNewNick();
            if (oldNick == null || newNick == null) {
                LOGGER.error((Object)("Incomplete nick change message. Old nick: '" + oldNick + "', new nick: '" + newNick + "'."));
                return;
            }
            IdentityManager.this.provider.getPersistentPresence().updateNick(oldNick, newNick);
        }
    }

    private final class WhoisListener
    extends AbstractIrcMessageListener {
        private static final int RPL_WHOISUSER = 311;

        public WhoisListener() {
            super(IdentityManager.this.irc, IdentityManager.this.connectionState);
        }

        public void onServerNumericMessage(ServerNumericMessage msg) {
            switch (msg.getNumericCode()) {
                case 311: {
                    String whoismsg = msg.getText();
                    int endNickIndex = whoismsg.indexOf(32);
                    String nick = whoismsg.substring(0, endNickIndex);
                    if (!this.localUser(nick)) {
                        return;
                    }
                    this.updateIdentity(whoismsg);
                    this.irc.deleteListener((IMessageListener)this);
                    break;
                }
            }
        }

        private void updateIdentity(String whoismsg) {
            int endNickIndex = whoismsg.indexOf(32);
            int endUserIndex = whoismsg.indexOf(32, endNickIndex + 1);
            int endHostIndex = whoismsg.indexOf(32, endUserIndex + 1);
            String user = whoismsg.substring(endNickIndex + 1, endUserIndex);
            String host = whoismsg.substring(endUserIndex + 1, endHostIndex);
            IdentityManager.this.identity.setHost(host);
            IdentityManager.this.identity.setUser(user);
            LOGGER.debug((Object)String.format("Current identity: %s!%s@%s", this.connectionState.getNickname(), user, host));
        }
    }
}

