/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.mock.MockFileTransferImpl;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;

public class MockOperationSetFileTransfer
implements OperationSetFileTransfer {
    private final Vector<FileTransferListener> fileTransferListeners = new Vector();
    private final MockProvider protocolProvider;

    public MockOperationSetFileTransfer(MockProvider protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public FileTransfer sendFile(Contact toContact, File file) throws IllegalStateException, IllegalArgumentException {
        MockFileTransferImpl fileTrans = new MockFileTransferImpl(toContact, file, this.generateID(), 2);
        this.fireFileTransferCreated(new FileTransferCreatedEvent((FileTransfer)fileTrans, new Date()));
        this.changeFileTransferStatus((FileTransfer)fileTrans, 6);
        return fileTrans;
    }

    public void changeFileTransferStatus(FileTransfer ft, int newstatus) {
        ((MockFileTransferImpl)ft).fireStatusChangeEvent(newstatus);
    }

    private String generateID() {
        return String.valueOf(System.currentTimeMillis()) + String.valueOf(this.hashCode());
    }

    public void receiveFile(final File file, final Contact from) {
        final Date requestDate = new Date();
        final String id = this.generateID();
        this.fireFileTransferRequest(new FileTransferRequestEvent((OperationSetFileTransfer)this, new IncomingFileTransferRequest(){

            public String getID() {
                return id;
            }

            public String getFileName() {
                return file.getName();
            }

            public String getFileDescription() {
                return file.toString();
            }

            public long getFileSize() {
                return file.length();
            }

            public Contact getSender() {
                return from;
            }

            public FileTransfer acceptFile(File file2) {
                MockFileTransferImpl fileTrans = new MockFileTransferImpl(from, file2, id, 1);
                MockOperationSetFileTransfer.this.fireFileTransferCreated(new FileTransferCreatedEvent((FileTransfer)fileTrans, requestDate));
                MockOperationSetFileTransfer.this.changeFileTransferStatus((FileTransfer)fileTrans, 6);
                return fileTrans;
            }

            public void rejectFile() {
            }

            public byte[] getThumbnail() {
                return null;
            }
        }, requestDate));
    }

    public FileTransfer sendFile(Contact toContact, Contact fromContact, String remotePath, String localPath) throws IllegalStateException, IllegalArgumentException {
        return this.sendFile(toContact, new File(localPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransferListener(FileTransferListener listener) {
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            if (!this.fileTransferListeners.contains(listener)) {
                this.fileTransferListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransferListener(FileTransferListener listener) {
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            this.fileTransferListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileTransferRequest(FileTransferRequestEvent event) {
        Iterator<FileTransferListener> listeners = null;
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferCreated(FileTransferCreatedEvent event) {
        Iterator<FileTransferListener> listeners = null;
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferCreated(event);
        }
    }

    public long getMaximumFileLength() {
        return Integer.MIN_VALUE;
    }
}

