/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import gnu.java.zrtp.ZrtpConfigure;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class ZrtpConfigureTableModel<T extends Enum<T>>
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private final ZrtpConfigure active;
    private final ZrtpConfigure inActive;
    private final T algorithm;
    private final Class<T> clazz;
    boolean[] onOff;

    public ZrtpConfigureTableModel(T algo, ZrtpConfigure act, ZrtpConfigure inAct, String savedConf) {
        this.active = act;
        this.inActive = inAct;
        this.algorithm = algo;
        this.clazz = ((Enum)this.algorithm).getDeclaringClass();
        this.initialize(savedConf);
    }

    private void initialize(String savedConf) {
        Enum[] enumValues = (Enum[])this.clazz.getEnumConstants();
        ArrayList<String> fullList = new ArrayList<String>(enumValues.length);
        for (Enum sh : enumValues) {
            fullList.add(sh.name());
        }
        String[] savedAlgos = savedConf.split(";");
        for (String str : savedAlgos) {
            try {
                T algoEnum = Enum.valueOf(this.clazz, str);
                if (algoEnum == null) continue;
                this.active.addAlgo(algoEnum);
                fullList.remove(str);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        for (String str : fullList) {
            T algoEnum = Enum.valueOf(this.clazz, str);
            if (algoEnum == null) continue;
            this.inActive.addAlgo(algoEnum);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.active.getNumConfiguredAlgos(this.algorithm) + this.inActive.getNumConfiguredAlgos(this.algorithm);
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                if (row >= this.active.getNumConfiguredAlgos(this.algorithm)) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 1: {
                if (row >= this.active.getNumConfiguredAlgos(this.algorithm)) {
                    return this.inActive.getAlgoAt(row -= this.active.getNumConfiguredAlgos(this.algorithm), this.algorithm).name();
                }
                return this.active.getAlgoAt(row, this.algorithm).name();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : super.getColumnClass(columnIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 0 && value instanceof Boolean) {
            if (row >= this.active.getNumConfiguredAlgos(this.algorithm)) {
                this.active.addAlgo(this.inActive.getAlgoAt(row -= this.active.getNumConfiguredAlgos(this.algorithm), this.algorithm));
                this.inActive.removeAlgo(this.inActive.getAlgoAt(row, this.algorithm));
            } else {
                this.inActive.addAlgo(this.active.getAlgoAt(row, this.algorithm));
                this.active.removeAlgo(this.active.getAlgoAt(row, this.algorithm));
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
    }

    public int move(int row, boolean up, boolean upSave) {
        if (up) {
            if (row <= 0) {
                throw new IllegalArgumentException("rowIndex");
            }
            return this.move(row - 1, false, upSave) - 1;
        }
        if (row >= this.getRowCount() - 1) {
            throw new IllegalArgumentException("rowIndex");
        }
        if (this.active.getNumConfiguredAlgos(this.algorithm) <= 1) {
            return row;
        }
        Enum swap = this.active.getAlgoAt(row, this.algorithm);
        this.active.removeAlgo(swap);
        this.active.addAlgoAt(row + 1, swap);
        this.fireTableRowsUpdated(0, this.getRowCount());
        return row + 1;
    }

    public boolean checkEnableUp(int row) {
        return row < this.active.getNumConfiguredAlgos(this.algorithm);
    }

    public boolean checkEnableDown(int row) {
        return row < this.active.getNumConfiguredAlgos(this.algorithm) - 1;
    }

    public void saveConfig() {
        StringBuffer algoStr = new StringBuffer();
        for (Enum sh : this.active.algos(this.algorithm)) {
            algoStr.append(sh.name());
            algoStr.append(';');
        }
    }

    public void setStandardConfig() {
        StringBuffer algoStr = new StringBuffer();
        for (Enum sh : this.active.algos(this.algorithm)) {
            algoStr.append(sh.name());
            algoStr.append(';');
        }
        this.initialize(algoStr.toString());
        this.fireTableRowsUpdated(0, this.getRowCount());
    }
}

